/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GenSubsInfoExcel
implements DocGenerate {
    private final int loadPageSize = 500;
    private SSubsInfoDao sSubsInfoDao = null;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "subs";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            String userId = template.getLoginUserId();
            this.sSubsInfoDao = new SSubsInfoDao(conn);
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            HashMap<String, Object> nameParamMap = new HashMap<String, Object>();
            nameParamMap.put("today", today);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), nameParamMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet fieldSheet = EasyExcel.writerSheet((Integer)0, (String)"sheet1").build();
            this.subsInfoListRender(excelWriter, fieldSheet, subsId);
            excelWriter.finish();
            List<File> list = Arrays.asList(targetFile);
            return list;
        }
        catch (Exception e) {
            logger.error("\u7cfb\u7edf\u5bfc\u51fa\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5bfc\u51fa\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public void subsInfoListRender(ExcelWriter excelWriter, WriteSheet sheet, String sysCode) {
        SSubsInfo param = new SSubsInfo();
        param.setSize(500);
        List<SSubsInfo> list = this.sSubsInfoDao.queryAllSubsInfoByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill(list, sheet);
        } else {
            excelWriter.fill(list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(page);
                list = this.sSubsInfoDao.queryAllSubsInfoByPage(param);
                excelWriter.fill(list, sheet);
            }
        }
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }
}

