/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.deliver.console.facade.PaasAdapterPipelineService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasAdapterPipelineDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasTemplateInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasTemplateInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginGitConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class GitPullAloneMediumUrlPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private PluginGitConf pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;
    private String mediumUrl;
    private String gitlabName;
    private String gitlabPwd;

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginGitConf();
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.password"));
        this.gitlabName = paasEnvParamDao.queryByCodeReturnValue("git.username");
        this.gitlabPwd = paasEnvParamDao.queryByCodeReturnValue("git.password");
        PaasAdapterPipelineService paasAdapterPipelineService = (PaasAdapterPipelineService)SpringContextUtils.getBean(PaasAdapterPipelineService.class);
        PaasTemplateInfoService paasTemplateInfoService = (PaasTemplateInfoService)SpringContextUtils.getBean(PaasTemplateInfoService.class);
        PaasAdapterPipelineDTO pipelineParam = new PaasAdapterPipelineDTO();
        pipelineParam.setPipelineTemplateId(this.context.getSzBatchId());
        pipelineParam = (PaasAdapterPipelineDTO)paasAdapterPipelineService.queryByPk((Object)pipelineParam);
        if (pipelineParam == null) {
            this.logger.error("\u83b7\u53d6\u5e94\u7528\u5b89\u88c5\u4ecb\u8d28\u4ed3\u5e93\u5931\u8d25");
            return false;
        }
        String appTemplateId = pipelineParam.getAdapterAppTemplateid();
        if (StringUtils.isBlank((CharSequence)appTemplateId)) {
            this.logger.error("\u83b7\u53d6\u5e94\u7528\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        PaasTemplateInfoDTO templateInfo = new PaasTemplateInfoDTO();
        templateInfo.setAppTemplateId(appTemplateId);
        templateInfo = (PaasTemplateInfoDTO)paasTemplateInfoService.queryByPk((Object)templateInfo);
        if (templateInfo == null) {
            this.logger.error("\u83b7\u53d6\u5e94\u7528\u6a21\u677f\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.prjtemplate.branch.name"));
        this.gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        if (this.gitLocalPath != null) {
            this.logger.info(String.format("\u83b7\u53d6\u5b89\u88c5\u4ecb\u8d28 %s", this.mediumUrl));
            String name = this.mediumUrl.substring(this.mediumUrl.lastIndexOf("/") + 1, this.mediumUrl.lastIndexOf(".git"));
            String localMediumPath = name + "-medium";
            this.repositoryCreate(this.gitLocalPath + localMediumPath, this.mediumUrl, this.gitlabName, this.gitlabPwd, this.pluginParam.getGitBranchName());
            return flag;
        }
        return false;
    }
}

