/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.design.console.types.MarketType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketSysinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketSysinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.UUIDUtil;
import com.irdstudio.allinapaas.portal.console.types.IndustryType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.MapUtils;

public class MarketSaveDBTask
extends AbstractMarketTask {
    private PaasAppsInfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(MapUtils.getString(extParam, (Object)"paasAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            String subsId = MapUtils.getString(this.extParam, (Object)"paasSubsId");
            String subsCode = MapUtils.getString(this.extParam, (Object)"paasSubsCode");
            conn = this.getConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            PaasMarketSysinfoDao paasMarketSysinfoDao = new PaasMarketSysinfoDao(conn);
            PaasMarketAppinfoDao paasMarketAppinfoDao = new PaasMarketAppinfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasMarketAppinfo paasMarketAppinfo = new PaasMarketAppinfo();
            BeanUtils.copyProperties((Object)((Object)paasMarketAppinfo), (Object)((Object)this.appInfo));
            SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            PaasMarketSysinfo paasMarketSysinfo = paasMarketSysinfoDao.queryPaasMarketSysinfo(subsId);
            if (paasMarketSysinfo == null) {
                paasMarketSysinfo = new PaasMarketSysinfo();
                BeanUtils.copyProperties((Object)((Object)paasMarketSysinfo), (Object)((Object)sSubsInfo));
                paasMarketSysinfo.setSubsId(sSubsInfo.getSubsId());
                paasMarketSysinfo.setSubsCode(sSubsInfo.getSubsCode());
                paasMarketSysinfo.setSubsName(sSubsInfo.getSubsName());
                paasMarketSysinfo.setMarketType(MarketType.Original.getCode());
                paasMarketSysinfo.setIndustryType(IndustryType.ALL.getCode());
                paasMarketSysinfoDao.insertPaasMarketSysinfo(paasMarketSysinfo);
            }
            paasMarketAppinfoDao.deletePaasMarketAppinfo(this.appInfo.getAppId(), paasMarketSysinfo.getSubsId());
            paasMarketAppinfo.setSubsId(subsId);
            paasMarketAppinfo.setSubsCode(subsCode);
            paasMarketAppinfo.setSubsName(paasMarketSysinfo.getSubsName());
            int modelCount = modelTableInfoDao.countByProjectId(this.appInfo.getAppId());
            int srvI01Count = srvModelInfoDao.countByAppId(this.appInfo.getAppId(), SrvModelCatalogEnum.SrvServer.getCode());
            int srvA01Count = srvModelInfoDao.countByAppId(this.appInfo.getAppId(), SrvModelCatalogEnum.ComponentServer.getCode());
            int srvInfCount = srvModelInfoDao.countByAppId(this.appInfo.getAppId(), SrvModelCatalogEnum.TradeServer.getCode());
            int srvBackCount = srvModelInfoDao.countByAppId(this.appInfo.getAppId(), SrvModelCatalogEnum.BackServer.getCode());
            String today = CurrentDateUtil.getTodayDate();
            paasMarketAppinfo.setAppTableCount(modelCount);
            paasMarketAppinfo.setAppIsrvCount(srvI01Count);
            paasMarketAppinfo.setAppOsrvCount(srvA01Count + srvInfCount + srvBackCount);
            paasMarketAppinfo.setAppPublishTime(today);
            paasMarketAppinfo.setMarketType(MarketType.Original.getCode());
            paasMarketAppinfo.setIndustryType(IndustryType.ALL.getCode());
            String marketAppGiturl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
            paasMarketAppinfo.setMarketAppGiturl(marketAppGiturl);
            paasMarketAppinfo.setMarketAppId(UUIDUtil.getUUID());
            paasMarketAppinfoDao.insertPaasMarketAppinfo(paasMarketAppinfo);
            if (conn == null) return flag;
        }
        catch (Exception e) {
            try {
                this.logger.error("\u63d0\u4ea4\u5e94\u7528\u4fe1\u606f\u5230\u5e94\u7528\u5e02\u573a\u5931\u8d25", (Throwable)e);
                flag = false;
                if (conn == null) return flag;
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                this.closeConnection(conn);
                throw throwable;
            }
            this.closeConnection(conn);
            return flag;
        }
        this.closeConnection(conn);
        return flag;
    }
}

