/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SysMarketCpDictOptionTask
extends AbstractMarketTask {
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        Connection sqliteConn = null;
        try {
            conn = this.getConnection();
            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            List<PaasAppsInfo> appList = paasAppsInfoDao.queryPaasAppsInfoListBySysCode(subsId);
            if (CollectionUtils.isNotEmpty(appList)) {
                File sqliteFile = this.getSysSqliteFile(this.extParam, null);
                sqliteConn = this.getSqliteConnection(sqliteFile);
                ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
                DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(conn);
                DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(conn);
                HashMap<String, DictOptionInfo> optionInfoMap = new HashMap<String, DictOptionInfo>();
                ArrayList<DictOptionInfo> optionInfoList = new ArrayList<DictOptionInfo>();
                ArrayList<DictOptionEnum> optionEnumList = new ArrayList<DictOptionEnum>();
                for (PaasAppsInfo appInfo : appList) {
                    List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(appInfo.getAppId());
                    if (!CollectionUtils.isNotEmpty(optionsList)) continue;
                    ArrayList codeBoList = new ArrayList(optionsList.size());
                    for (ModelTableField option : optionsList) {
                        if (StringUtils.isBlank((CharSequence)option.getDictId()) || optionInfoMap.get(option.getDictId()) != null) continue;
                        List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                        DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                        if (optionInfo == null) continue;
                        optionInfoMap.put(optionInfo.getDictId(), optionInfo);
                        optionInfoList.add(optionInfo);
                        optionEnumList.addAll(dicts);
                    }
                }
                this.batchInsertPage("dict_option_info", optionInfoList, sqliteConn);
                this.batchInsertPage("dict_option_enum", optionEnumList, sqliteConn);
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u6570\u636e\u9009\u9879\u5230sqlite", (Throwable)e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
        return flag;
    }
}

