/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.reform;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.reform.PluginReformConf;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.reform.PluginReformConfDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.DateCalculate;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.DateConvert;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class ReformTableForDB2Plugin
extends AbstractPlugin {
    private List<PluginReformConf> rcList;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        PluginReformConfDao rcDao = new PluginReformConfDao(conn);
        this.rcList = rcDao.queryPluginReformConfWithCond(" where plugin_conf_id='" + szConfIdentify + "'", "order by conf_sort");
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        for (int i = 0; i < this.rcList.size(); ++i) {
            PluginReformConf rc = this.rcList.get(i);
            if (this.isInValidConf(this.context.getCurrentDataDate(), rc.getValidDate(), rc.getInvalidDate()) || !this.isArrivedNextOpDate(rc)) continue;
            String[] cmdForReform = this.getReformCmd(rc);
            this.logger.info("........................................................................");
            this.logger.info("\u51c6\u5907\u91cd\u6574" + rc.getReformTableSchema() + "." + rc.getReformTableName() + "...");
            boolean bResult = this.callExternCmd(cmdForReform);
            if (bResult) {
                this.writeSuccessLog("\u91cd\u6574" + rc.getReformTableSchema() + "." + rc.getReformTableName());
                String sql = "update urps.plugin_reform_conf set last_reform_date='" + this.context.getCurrentDataDate() + "' where plugin_conf_id='" + rc.getPluginConfId() + "' and conf_sort=" + rc.getConfSort();
                if (this.executeSql(sql)) continue;
                flag = false;
                this.writeFaildLog("\u66f4\u65b0\u4e0a\u6b21\u91cd\u6574\u65e5\u671f");
                continue;
            }
            this.writeFaildLog("\u91cd\u6574" + rc.getReformTableSchema() + "." + rc.getReformTableName());
        }
        return flag;
    }

    private String[] getReformCmd(PluginReformConf rc) {
        String[] cmdParams = new String[]{this.binPath + "db2shell/reformTable.sh", this.context.getDataSourceInfo().getDsDbName(), this.context.getDataSourceInfo().getDsUserId(), this.context.getDataSourceInfo().getDsUserPwd(), rc.getReformTableSchema(), rc.getReformTableName()};
        return cmdParams;
    }

    private boolean isArrivedNextOpDate(PluginReformConf rc) {
        boolean bFlag = false;
        if (rc.getLastReformDate() == null || "".equals(rc.getLastReformDate())) {
            rc.setLastReformDate(this.context.getCurrentDataDate());
        }
        String nextOpDate = DateConvert.toString(DateCalculate.addDays(DateConvert.toDateWithSeparate1(rc.getLastReformDate()), rc.getReformCycleDay()));
        if (this.context.getCurrentDataDate().compareTo(nextOpDate) >= 0) {
            bFlag = true;
        }
        return bFlag;
    }
}

