/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.AppRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinrdm.sam.console.facade.TclComponentInfoService;
import com.irdstudio.allinrdm.sam.console.facade.TclComponentSubsService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclComponentInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclComponentSubsDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceVersionDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SUserProfileDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TclCompScanPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected Map<String, Object> extParam;
    PaasAppsInfoService paasAppsInfoService;
    TclComponentInfoService tclComponentInfoService;
    TclComponentSubsService tclComponentSubsService;
    SummaryService summaryService;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        return true;
    }

    @Override
    public boolean execute() {
        this.tclComponentInfoService = (TclComponentInfoService)SpringContextUtils.getBean(TclComponentInfoService.class);
        this.tclComponentSubsService = (TclComponentSubsService)SpringContextUtils.getBean(TclComponentSubsService.class);
        this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        this.summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        String reportId = MapUtils.getString(this.extParam, (Object)"reportId");
        String userId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String mavenSetting = MapUtils.getString(this.extParam, (Object)"mavenSetting");
        String gitUserName = MapUtils.getString(this.extParam, (Object)"gitUserName");
        String gitUserPassword = MapUtils.getString(this.extParam, (Object)"gitUserPassword");
        String now = CurrentDateUtil.getTodayDateEx2();
        String appId = this.batchInst.getAppId();
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        ILogger pluginOutputLogger = this.logger;
        String appRepoPath = "";
        if (this.context.getBatBatchSource() == null) {
            String user = "";
            String password = "";
            if (StringUtils.isNotBlank((CharSequence)gitUserName)) {
                user = gitUserName;
                password = gitUserPassword;
            } else {
                String currentUserId;
                AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
                SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId"));
                if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                    this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
                }
                user = userProfile.getGitUsername();
                password = userProfile.getGitAccessToken();
                if (StringUtils.isBlank((CharSequence)password)) {
                    password = userProfile.getGitPassword();
                }
            }
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appId, appInfo.getAppGitUrl(), user, password);
            appRepoPullTask.syncRun();
            appRepoPath = appRepoPullTask.getAppPath();
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + reportId + ".log";
            this.logger.info("\u63d2\u4ef6\u8c03\u7528\u65b9\u5f0f\uff0c\u8f93\u51fa\u65e5\u5fd7\u5230 " + fullLogFileName);
            pluginOutputLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
        } else {
            appRepoPath = this.context.getBatBatchSource().getRepoLocalPath();
        }
        File appRepoDir = new File(appRepoPath);
        if (!appRepoDir.exists()) {
            pluginOutputLogger.error("\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25");
            return false;
        }
        pluginOutputLogger.info("\u8bfb\u53d6\u5230\u4ed3\u5e93\u5730\u5740\uff1a" + appRepoPath);
        RecordDependencyLogger recordDependencyLogger = new RecordDependencyLogger(pluginOutputLogger);
        MavenRunner mavenRunner = new MavenRunner("mvn dependency:tree", appRepoDir.getAbsolutePath(), recordDependencyLogger);
        mavenRunner.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
        mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        if (StringUtils.isNotBlank((CharSequence)mavenSetting)) {
            mavenRunner.setSetting(mavenSetting);
        }
        mavenRunner.run();
        List<String> dependencies = recordDependencyLogger.getDependencies();
        HashMap artifactMap = new HashMap();
        int count = 0;
        if (CollectionUtils.isNotEmpty(dependencies)) {
            for (String dependency : dependencies) {
                String[] arr;
                if (StringUtils.equalsAny((CharSequence)dependency, (CharSequence[])new CharSequence[]{"-"}) || (arr = StringUtils.split((String)dependency, (String)":")).length < 3) continue;
                String groupId = arr[0];
                String artifactId = arr[1];
                String fileExt = arr[2];
                String versionId = arr[3];
                TclComponentInfoDTO tclCmp = new TclComponentInfoDTO();
                tclCmp.setTclCmpId(UUIDUtil.getShortUUID());
                tclCmp.setTclCmpName(artifactId);
                tclCmp.setTclCmpVersion(versionId);
                tclCmp.setTclCmpStdGroup(groupId);
                tclCmp.setTclCmpMainCatalog("B");
                tclCmp.setTclCmpSecondCatalog("B00106");
                TclComponentSubsDTO info = this.findComponentInfo(tclCmp, appInfo);
                if (info == null) continue;
                ++count;
            }
        }
        pluginOutputLogger.info("\u6280\u672f\u6808\u626b\u63cf\u7ed3\u675f\uff0c\u7d2f\u8ba1\u626b\u63cf\u5230\u6280\u672f\u6808 " + count + "\u4e2a");
        return true;
    }

    public TclComponentSubsDTO findComponentInfo(TclComponentInfoDTO tclCmp, PaasAppsInfoDTO appInfo) {
        TclComponentSubsDTO result = null;
        try {
            TclComponentInfoDTO info = new TclComponentInfoDTO();
            info.setTclCmpName(tclCmp.getTclCmpName());
            info.setTclCmpVersion(tclCmp.getTclCmpVersion());
            List findInfoList = this.tclComponentInfoService.queryListByPage((Object)info);
            if (CollectionUtils.isNotEmpty((Collection)findInfoList)) {
                TclComponentInfoDTO tclCmpFind = (TclComponentInfoDTO)findInfoList.get(0);
                TclComponentSubsDTO tclCmpSubs = new TclComponentSubsDTO();
                tclCmpSubs.setTclCmpId(tclCmpFind.getTclCmpId());
                tclCmpSubs.setSubsId(appInfo.getSubsId());
                tclCmpSubs.setAppId(appInfo.getAppId());
                List tclCmpSubsList = this.tclComponentSubsService.queryListByPage((Object)tclCmpSubs);
                if (CollectionUtils.isEmpty((Collection)tclCmpSubsList)) {
                    TclComponentSubsDTO newTclCmp = new TclComponentSubsDTO();
                    BeanUtility.beanCopy((Object)tclCmpFind, (Object)newTclCmp);
                    newTclCmp.setSubsTclVersion(tclCmpFind.getTclCmpVersion());
                    newTclCmp.setSubsId(appInfo.getSubsId());
                    newTclCmp.setSubsCode(appInfo.getSubsCode());
                    newTclCmp.setSubsName(appInfo.getSubsName());
                    newTclCmp.setAppId(appInfo.getAppId());
                    newTclCmp.setAppCode(appInfo.getAppCode());
                    newTclCmp.setAppName(appInfo.getAppName());
                    newTclCmp.setSubsTclId(UUIDUtil.getUUID());
                    this.tclComponentSubsService.insert((Object)newTclCmp);
                    result = newTclCmp;
                } else {
                    result = (TclComponentSubsDTO)tclCmpSubsList.get(0);
                }
            } else {
                this.tclComponentInfoService.insert((Object)tclCmp);
                TclComponentSubsDTO newTclCmp = new TclComponentSubsDTO();
                BeanUtility.beanCopy((Object)tclCmp, (Object)newTclCmp);
                newTclCmp.setSubsTclVersion(tclCmp.getTclCmpVersion());
                newTclCmp.setSubsId(appInfo.getSubsId());
                newTclCmp.setSubsCode(appInfo.getSubsCode());
                newTclCmp.setSubsName(appInfo.getSubsName());
                newTclCmp.setAppId(appInfo.getAppId());
                newTclCmp.setAppCode(appInfo.getAppCode());
                newTclCmp.setAppName(appInfo.getAppName());
                newTclCmp.setSubsTclId(UUIDUtil.getUUID());
                this.tclComponentSubsService.insert((Object)newTclCmp);
                result = newTclCmp;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        return result;
    }

    public boolean fetchVulLibInfo(TclOpensourceInfoDTO info, TclOpensourceVersionDTO versionInfo) {
        return false;
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }

    public static class RecordDependencyLogger
    implements ILogger {
        List<String> dependencies = new ArrayList<String>();
        ILogger logger = null;
        Pattern pattern = Pattern.compile("^\\[INFO\\][\\s\\+\\-\\\\\\|]+(\\S++)$");

        public RecordDependencyLogger(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void info(Object message) {
            Matcher m;
            String console = message.toString();
            if (StringUtils.startsWith((CharSequence)console, (CharSequence)"[INFO]") && StringUtils.indexOf((CharSequence)console, (CharSequence)"-----------<") <= 0 && (m = this.pattern.matcher(console)).matches()) {
                this.logger.info("\u8bfb\u53d6\u5230\u4f9d\u8d56 " + console);
                String dependency = m.group(1);
                this.dependencies.add(dependency);
            }
        }

        @Override
        public void debug(Object message) {
            this.info(message);
        }

        @Override
        public void debug(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void error(Object message) {
            this.info(message);
        }

        @Override
        public void error(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void fatal(Object message) {
            this.info(message);
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void info(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void warn(Object message) {
            this.info(message);
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void setName(String categoryName) {
        }

        @Override
        public ILogger makeSubLogger(String subCategoryName) {
            return null;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }
    }
}

