/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.unittest;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsMeasureService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsMeasureDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.AppRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.BatInstBatchDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.BatInstBatch;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan.JacocoReportParser;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinapaas.quality.console.facade.PluginCoverageRptService;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginCoverageRptDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MavenUnitTestPlugin
extends AbstractPlugin {
    protected BatInstBatch batchInst = null;
    protected Map<String, Object> extParam;
    PaasAppsMeasureService paasAppsMeasureService;
    PaasAppsInfoService paasAppsInfoService;
    SummaryService summaryService;
    PluginCoverageRptService pluginCheckstyleRptService;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        BatInstBatchDao batInstBatchDao = new BatInstBatchDao(conn);
        this.batchInst = batInstBatchDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = batInstBatchDao.getExtParam(this.batchInst);
        return true;
    }

    @Override
    public boolean execute() {
        String reportId = MapUtils.getString(this.extParam, (Object)"reportId");
        String userId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String now = CurrentDateUtil.getTodayDateEx2();
        String appId = this.batchInst.getAppId();
        this.paasAppsMeasureService = (PaasAppsMeasureService)SpringContextUtils.getBean(PaasAppsMeasureService.class);
        this.paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        this.summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        this.pluginCheckstyleRptService = (PluginCoverageRptService)SpringContextUtils.getBean(PluginCoverageRptService.class);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(appId);
        appInfo = (PaasAppsInfoDTO)this.paasAppsInfoService.queryByPk((Object)appInfo);
        String appRepoPath = "";
        if (this.context.getBatBatchSource() == null) {
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appId);
            appRepoPullTask.syncRun();
            appRepoPath = appRepoPullTask.getAppPath();
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + reportId + ".log";
            this.logger.info("\u63d2\u4ef6\u8c03\u7528\u65b9\u5f0f\uff0c\u8f93\u51fa\u65e5\u5fd7\u5230 " + fullLogFileName);
            ILogger newLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
            this.setPluginContext(this.context, newLogger);
        } else {
            appRepoPath = this.context.getBatBatchSource().getRepoLocalPath();
        }
        File appRepoDir = new File(appRepoPath);
        if (!appRepoDir.exists()) {
            this.logger.error("\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25");
            return false;
        }
        this.logger.info("\u8bfb\u53d6\u5230\u4ed3\u5e93\u5730\u5740\uff1a" + appRepoPath);
        this.logger.info("\u4ee3\u7801\u89c4\u8303\u626b\u63cf\u5f00\u59cb");
        if (!this.addNeedPluginToPom(appRepoDir)) {
            return false;
        }
        try {
            MavenRunner mavenRunner = new MavenRunner("mvn -DskipTests=false -Dmaven.test.skip=false -Dmaven.test.failure.ignore=true  test surefire-report:report", appRepoDir.getAbsolutePath(), this.logger);
            mavenRunner.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
            mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
            mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
            mavenRunner.run();
            File[] startDirs = appRepoDir.listFiles((dir, name) -> name.endsWith("-start") && dir.isDirectory());
            File startDir = startDirs != null && startDirs.length > 0 ? startDirs[0] : new File(appRepoDir, appRepoDir.getName() + "-start");
            File reportFile = new File(startDir, "target/site/jacoco/index.html");
            PluginCoverageRptDTO reportInfo = JacocoReportParser.parse(reportId, appId, appRepoDir, reportFile, this.logger);
            if (reportInfo != null) {
                reportInfo.setReportId(reportId);
                reportInfo.setTskNm(String.format("%s-jacoco", appInfo.getAppName()));
                reportInfo.setNowFileRte("index.html");
                reportInfo.setGitUrl(appInfo.getAppGitUrl());
                reportInfo.setNowVer("master");
                reportInfo.setDelInd("0");
                reportInfo.setCovTyp(Integer.valueOf(1));
                reportInfo.setScanTyp(Integer.valueOf(1));
                reportInfo.setAppId(appInfo.getAppId());
                reportInfo.setAppName(appInfo.getAppName());
                reportInfo.setSubsId(appInfo.getSubsId());
                reportInfo.setSubsName(appInfo.getSubsName());
                reportInfo.setCreateUser(userId);
                reportInfo.setCreateTime(now);
                reportInfo.setLatestFlag(YesOrNO.YES.getCode());
                this.pluginCheckstyleRptService.insert((Object)reportInfo);
                PaasAppsMeasureDTO measure = new PaasAppsMeasureDTO();
                measure.setAppId(appId);
                measure.setTestCaseCount(reportInfo.getTestCaseTotal());
                measure.setTestPassRate(reportInfo.getTestCaseSucRate());
                measure.setTestCoverRate(reportInfo.getClsCov());
                this.paasAppsMeasureService.updateByPk((Object)measure);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6267\u884cjacoco\u63d2\u4ef6\u5f02\u5e38 " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addNeedPluginToPom(File appRepoPath) {
        File rootPomFile = new File(appRepoPath, "pom.xml");
        if (!rootPomFile.exists()) {
            this.logger.error("\u672a\u627e\u5230pom.xml \u9000\u51fa\u626b\u63cf");
        }
        try (FileInputStream input = new FileInputStream(rootPomFile);){
            block72: {
                File[] startDirs;
                File startDir;
                Document pluginDom;
                Object artifactIdDom;
                Element plugins;
                String xmlString = IOUtils.toString((InputStream)input);
                Document document = DocumentHelper.parseText((String)xmlString);
                Element buildDom = document.getRootElement().element("build");
                if (buildDom == null) {
                    buildDom = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"build", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                    document.getRootElement().add(buildDom);
                }
                if ((plugins = buildDom.element("plugins")) == null) {
                    plugins = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"plugins", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                    buildDom.add(plugins);
                }
                List pluginList = plugins.elements("plugin");
                boolean findSurefireFlag = false;
                boolean findSurefireReportFlag = false;
                boolean findJacocoFlag = false;
                boolean needToWrite = false;
                if (CollectionUtils.isNotEmpty((Collection)pluginList)) {
                    for (Element plugin : pluginList) {
                        artifactIdDom = plugin.element("artifactId");
                        if (artifactIdDom != null && StringUtils.equals((CharSequence)"maven-surefire-plugin", (CharSequence)artifactIdDom.getText())) {
                            findSurefireFlag = true;
                            continue;
                        }
                        if (artifactIdDom != null && StringUtils.equals((CharSequence)"maven-surefire-report-plugin", (CharSequence)artifactIdDom.getText())) {
                            findSurefireReportFlag = true;
                            continue;
                        }
                        if (artifactIdDom == null || !StringUtils.equals((CharSequence)"jacoco-maven-plugin", (CharSequence)artifactIdDom.getText())) continue;
                        findJacocoFlag = true;
                    }
                }
                if (!findSurefireFlag) {
                    pluginDom = DocumentHelper.parseText((String)"<plugin xmlns=\"http://maven.apache.org/POM/4.0.0\">\n                <groupId xmlns=\"http://maven.apache.org/POM/4.0.0\">org.apache.maven.plugins</groupId>\n                <artifactId xmlns=\"http://maven.apache.org/POM/4.0.0\">maven-surefire-plugin</artifactId>\n                <version xmlns=\"http://maven.apache.org/POM/4.0.0\">3.3.1</version>\n                <configuration>\n                    <skipAfterFailureCount>0</skipAfterFailureCount>\n                    <skipTests>false</skipTests>\n                </configuration>\n            </plugin>");
                    plugins.add(pluginDom.getRootElement());
                    needToWrite = true;
                }
                if (!findSurefireReportFlag) {
                    pluginDom = DocumentHelper.parseText((String)"<plugin xmlns=\"http://maven.apache.org/POM/4.0.0\">\n                <groupId xmlns=\"http://maven.apache.org/POM/4.0.0\">org.apache.maven.plugins</groupId>\n                <artifactId xmlns=\"http://maven.apache.org/POM/4.0.0\">maven-surefire-report-plugin</artifactId>\n                <version xmlns=\"http://maven.apache.org/POM/4.0.0\">3.3.1</version>\n                <configuration>\n                    <aggregate>true</aggregate>\n                </configuration>\n                <executions>\n                    <execution>\n                        <id>report</id>\n                        <phase>test</phase>\n                        <goals>\n                            <goal>report</goal>\n                        </goals>\n                    </execution>\n                </executions>\n            </plugin>");
                    plugins.add(pluginDom.getRootElement());
                    needToWrite = true;
                }
                if (!findJacocoFlag) {
                    pluginDom = DocumentHelper.parseText((String)"<plugin xmlns=\"http://maven.apache.org/POM/4.0.0\">\n                <groupId xmlns=\"http://maven.apache.org/POM/4.0.0\">org.jacoco</groupId>\n                <artifactId xmlns=\"http://maven.apache.org/POM/4.0.0\">jacoco-maven-plugin</artifactId>\n                <version xmlns=\"http://maven.apache.org/POM/4.0.0\">0.8.12</version>\n                <executions>\n                    <execution>\n                        <goals>\n                            <goal>prepare-agent</goal>\n                        </goals>\n                    </execution>\n                    <execution>\n                        <id>report</id>\n                        <phase>test</phase>\n                        <goals>\n                            <goal>report</goal>\n                        </goals>\n                        <configuration>\n                            <outputDirectory>target/site/jacoco</outputDirectory>\n                        </configuration>\n                    </execution>\n                </executions>\n            </plugin>");
                    plugins.add(pluginDom.getRootElement());
                    needToWrite = true;
                }
                if (needToWrite) {
                    OutputFormat format = OutputFormat.createPrettyPrint();
                    format.setIndentSize(4);
                    format.setSuppressDeclaration(true);
                    format.setEncoding("UTF-8");
                    PrintWriter pw = new PrintWriter(rootPomFile);
                    artifactIdDom = null;
                    try {
                        XMLWriter writer = new XMLWriter((Writer)pw, format);
                        writer.write(document);
                        pw.flush();
                    }
                    catch (Throwable writer) {
                        artifactIdDom = writer;
                        throw writer;
                    }
                    finally {
                        if (pw != null) {
                            if (artifactIdDom != null) {
                                try {
                                    pw.close();
                                }
                                catch (Throwable writer) {
                                    ((Throwable)artifactIdDom).addSuppressed(writer);
                                }
                            } else {
                                pw.close();
                            }
                        }
                    }
                }
                File file = startDir = (startDirs = appRepoPath.listFiles((dir, name) -> name.endsWith("-start") && dir.isDirectory())) != null && startDirs.length > 0 ? startDirs[0] : new File(appRepoPath, appRepoPath.getName() + "-start");
                if (startDir.exists()) {
                    File startPomFile = new File(startDir, "pom.xml");
                    try (FileInputStream startInput = new FileInputStream(startPomFile);){
                        Element start_plugins;
                        Document start_dom = DocumentHelper.parseText((String)IOUtils.toString((InputStream)startInput));
                        Element start_buildDom = start_dom.getRootElement().element("build");
                        if (start_buildDom == null) {
                            start_buildDom = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"build", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                            start_dom.getRootElement().add(start_buildDom);
                        }
                        if ((start_plugins = start_buildDom.element("plugins")) == null) {
                            start_plugins = DocumentHelper.createElement((QName)DocumentHelper.createQName((String)"plugins", (Namespace)DocumentHelper.createNamespace((String)"", (String)"http://maven.apache.org/POM/4.0.0")));
                            start_buildDom.add(start_plugins);
                        }
                        List start_pluginList = start_plugins.elements("plugin");
                        boolean start_findJacocoFlag = false;
                        if (!CollectionUtils.isNotEmpty((Collection)start_pluginList)) break block72;
                        for (Element plugin : start_pluginList) {
                            Element artifactIdDom2 = plugin.element("artifactId");
                            if (artifactIdDom2 == null || !StringUtils.equals((CharSequence)"jacoco-maven-plugin", (CharSequence)artifactIdDom2.getText())) continue;
                            start_findJacocoFlag = true;
                            break;
                        }
                        if (start_findJacocoFlag) break block72;
                        Document pluginDom2 = DocumentHelper.parseText((String)"<plugin xmlns=\"http://maven.apache.org/POM/4.0.0\">\n                <groupId xmlns=\"http://maven.apache.org/POM/4.0.0\">org.jacoco</groupId>\n                <artifactId xmlns=\"http://maven.apache.org/POM/4.0.0\">jacoco-maven-plugin</artifactId>\n                <version xmlns=\"http://maven.apache.org/POM/4.0.0\">0.8.12</version>\n                <configuration>\n                    <includes>\n                        <include>**</include>\n                    </includes>\n                </configuration>\n                <executions>\n                    <execution>\n                        <id>report-aggregate</id>\n                        <phase>test</phase>\n                        <goals>\n                            <goal>report-aggregate</goal>\n                        </goals>\n                    </execution>\n                </executions>\n            </plugin>");
                        start_plugins.add(pluginDom2.getRootElement());
                        OutputFormat format = OutputFormat.createPrettyPrint();
                        format.setIndentSize(4);
                        format.setSuppressDeclaration(true);
                        format.setEncoding("UTF-8");
                        try (PrintWriter pw = new PrintWriter(startPomFile);){
                            XMLWriter writer = new XMLWriter((Writer)pw, format);
                            writer.write(start_dom);
                            pw.flush();
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("\u5199\u5165start jacoco\u63d2\u4ef6\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), e);
                        boolean bl2 = false;
                        if (input == null) return bl2;
                        if (throwable == null) {
                            ((InputStream)input).close();
                            return bl2;
                        }
                        try {
                            ((InputStream)input).close();
                            return bl2;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return bl2;
                        }
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u5199\u5165jacoco\u63d2\u4ef6\u4fe1\u606f\u5f02\u5e38 " + e.getMessage(), e);
            return false;
        }
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }
}

