/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.assembly.etl.export.txt;

import com.irdstudio.allinapaas.executor.application.executor.core.assembly.etl.export.Export;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.TLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ExportTxt
extends Export {
    private String tableName = null;
    private String fullFilePath = null;
    private ILogger logger = null;

    public ExportTxt(String tableName, String fullFilePath) {
        this.tableName = tableName;
        this.fullFilePath = fullFilePath;
        this.logger = TLogger.getLogger("Export");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run() {
        BufferedOutputStream fo = null;
        try {
            File newFile = new File(this.fullFilePath);
            if (!newFile.exists() || !newFile.delete() || newFile.createNewFile()) {
                // empty if block
            }
            fo = new BufferedOutputStream(new FileOutputStream(newFile));
        }
        catch (IOException e) {
            this.logger.info("\u5bfc\u51fa\u6570\u636e\u65f6\u521d\u59cb\u5316\u76ee\u6807\u6587\u4ef6\u51fa\u9519!", e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                fo.flush();
                fo.close();
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95ed\u6587\u4ef6\u5bf9\u8c61\u65f6\u51fa\u9519!", e);
            }
        }
        Connection conn = null;
        try {
            conn = TConnPool.getDefaultPool().getConnection();
        }
        catch (SQLException e1) {
            this.logger.error("\u521b\u5efa\u8fde\u63a5\u6c60\u51fa\u9519!", e1);
            boolean bl = false;
            return bl;
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
            try {
                fo.flush();
                fo.close();
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95ed\u6587\u4ef6\u5bf9\u8c61\u65f6\u51fa\u9519!", e);
            }
        }
        try (Statement st = conn.createStatement();){
            st.execute("select * from " + this.tableName);
            try (ResultSet rs = st.getResultSet();){
                int iCount = rs.getMetaData().getColumnCount();
                StringBuffer sb = null;
                while (rs.next()) {
                    sb = new StringBuffer();
                    for (int i = 1; i <= iCount; ++i) {
                        sb.append(rs.getString(i));
                        sb.append("|");
                    }
                    sb.append("\n");
                    try {
                        fo.write(new String(sb.toString().getBytes("ISO-8859-1"), "GBK").getBytes());
                    }
                    catch (IOException e) {
                        this.logger.error(e.getMessage());
                    }
                    sb = null;
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("\u4ece\u6570\u636e\u5e93\u4e2d\u5bfc\u51fa\u6570\u636e\u65f6\u51fa\u9519!", e);
        }
        finally {
            TConnPool.getDefaultPool().releaseConnection(conn);
            try {
                fo.flush();
                fo.close();
            }
            catch (IOException e) {
                this.logger.error("\u5173\u95ed\u6587\u4ef6\u5bf9\u8c61\u65f6\u51fa\u9519!", e);
            }
        }
        return true;
    }
}

