/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowConfStage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class FlowConfStageDao {
    Connection conn = null;

    public FlowConfStageDao(Connection conn) {
        this.conn = conn;
    }

    public FlowConfStage queryWithKeys(String stageId, String batchId) throws SQLException {
        FlowConfStage dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_conf_stage WHERE stage_id=? and batch_id=?");
            ps.setString(1, stageId);
            ps.setString(2, batchId);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new FlowConfStage();
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchId(rs.getString("batch_id"));
                dc.setRemark(rs.getString("remark"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfStageWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<FlowConfStage> queryWithCond(String szCondition, String szOrderBy) throws SQLException {
        ArrayList<FlowConfStage> dcList = new ArrayList<FlowConfStage>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM flow_conf_stage " + szCondition + " " + szOrderBy);
            rs = ps.executeQuery();
            while (rs.next()) {
                FlowConfStage dc = new FlowConfStage();
                dc.setStageId(rs.getString("stage_id"));
                dc.setStageName(rs.getString("stage_name"));
                dc.setBatchId(rs.getString("batch_id"));
                dc.setRemark(rs.getString("remark"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryFlowConfStageWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

