/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.allinapaas.executor.application.executor.core.util.parse.ExpressionUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;

public class PaasAppsParamDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasAppsParamDao.class);
    Connection conn = null;
    private ConcurrentMap<String, Map<String, Object>> cachedMap = new ConcurrentHashMap<String, Map<String, Object>>();

    public PaasAppsParamDao(Connection conn) {
        this.conn = conn;
    }

    public List<PaasAppsParam> queryPaasAppsParamList(final PaasAppsParam paramVO) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsParam> list = new ArrayList<PaasAppsParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsParam bean = (PaasAppsParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsParam.class));
                if (StringUtils.isBlank((CharSequence)bean.getParamSource())) {
                    bean.setParamSource(ParamSource.Const.getCode());
                }
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list;
    }

    public PaasAppsParam queryPaasAppsParamByCode(final String appId, final String paramCode) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_apps_param");
                this.WHERE("app_id = ? ");
                param.add(appId);
                this.WHERE("param_code = ? ");
                param.add(paramCode);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasAppsParam> list = new ArrayList<PaasAppsParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasAppsParam bean = (PaasAppsParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasAppsParam.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list.isEmpty() ? null : (PaasAppsParam)((Object)list.get(0));
    }

    public int deleteByAppId(final String appId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_apps_param");
                this.WHERE("app_id = ?");
                param.add(appId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppId is wrong", e);
        }
    }

    public boolean insert(final PaasAppsParam vo) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.INSERT_INTO("`allinpaas_db`.paas_apps_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)vo));
                for (Object[] val : vals) {
                    this.VALUES(val[0].toString(), "?");
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            if (re == 1) {
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("insert paasAppsParam is wrong", e);
        }
        return false;
    }

    public Map<String, Object> queryAppParamMap(String appId, String envId) throws SQLException {
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = this.queryPaasAppsParamList(param);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                paramMap.put(p.getParamCode(), this.parseParamValue(appId, p.getParamSource(), p.getParamValue(), envId, this.conn));
            }
        }
        return paramMap;
    }

    public Map<String, Object> loadEcsParam(String appId, String envId) {
        HashMap<String, Map> ecsMap = (HashMap<String, Map>)this.cachedMap.get(appId + envId);
        if (ecsMap == null) {
            try {
                ecsMap = new HashMap<String, Map>();
                this.cachedMap.put(appId + envId, ecsMap);
                PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(this.conn);
                PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(this.conn);
                PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(this.conn);
                PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(envId);
                ecsMap.put("env", BeanUtility.bean2Map((Object)((Object)envInfo)));
                PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
                PaasEcsInfo envEcsParam = new PaasEcsInfo();
                envEcsParam.setEnvId(envId);
                List<PaasEcsInfo> notAppEcsList = paasEcsInfoDao.queryPaasEcsInfoNotApp(envEcsParam);
                envEcsParam.setSubsId(appInfo.getSubsId());
                List<PaasEcsInfo> subsEcsList = paasEcsInfoDao.queryPaasEcsInfoNotApp(envEcsParam);
                notAppEcsList.addAll(subsEcsList);
                envEcsParam.setAppId(appId);
                List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(envEcsParam);
                notAppEcsList.addAll(ecsList);
                ecsList = notAppEcsList;
                if (CollectionUtils.isNotEmpty(ecsList)) {
                    for (PaasEcsInfo ecs : ecsList) {
                        Map ecsObjMap = BeanUtility.bean2Map((Object)((Object)ecs));
                        HashMap ecsParamMap = new HashMap();
                        for (Map.Entry entry : ecsObjMap.entrySet()) {
                            String key = TmModelUtil.propertyToField((String)((String)entry.getKey())).toUpperCase();
                            ecsParamMap.put(key, entry.getValue());
                        }
                        ecsMap.put(ecs.getPaasDuId(), ecsParamMap);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf \u52a0\u8f7d\u670d\u52a1\u5668\u4fe1\u606f\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            }
        }
        return ecsMap;
    }

    public String parseParamValue(String appId, String paramSource, String paramValue, String envId, Connection conn) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        Map<String, Object> ecsMap = this.loadEcsParam(appId, envId);
        if (StringUtils.isBlank((CharSequence)paramValue)) {
            return "";
        }
        try {
            String value = ExpressionUtil.parse(paramValue, ecsMap);
            return value;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Deprecated
    public String parseParamValue(String paramSource, String paramValue, String envId, Connection conn) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        String[] values = StringUtils.split((String)paramValue, (String)".");
        if (values == null || values.length < 2) {
            return "";
        }
        String value = "";
        try {
            String paasCatalogId = values[0];
            String fieldCode = values[1];
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEnvId(envId);
            ecsParam.setPaasDuId(paasCatalogId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                String prop;
                PaasEcsInfo ecs = ecsList.get(0);
                Object obj = ReflectionTestUtils.invokeGetterMethod((Object)((Object)ecs), (String)(prop = TmModelUtil.fieldToProperty((String)fieldCode)));
                value = obj != null ? obj.toString() : "";
            } else {
                value = "";
                logger.info("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5bf9\u5e94\u670d\u52a1\u5668\u8bb0\u5f55\u4e3a\u7a7a " + paramValue + " envId:" + envId);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5931\u8d25 " + paramValue, (Throwable)e);
        }
        return value;
    }

    public boolean updateByPk(final PaasAppsParam paramVO) throws Exception {
        int rs;
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.UPDATE("`allinpaas_db`.paas_apps_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    if (val[0].toString().equals("app_id") || val[0].toString().equals("param_code")) continue;
                    this.SET(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
                this.WHERE("app_id = ? ");
                param.add(paramVO.getAppId());
                this.WHERE("param_code = ? ");
                param.add(paramVO.getParamCode());
            }
        }.toString();
        PreparedStatement ps = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException("updateByPk is wrong", e);
        }
        return rs == 1;
    }
}

