/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.dao;

import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateParam;
import com.irdstudio.allinapaas.executor.application.executor.core.util.db.ProxySQL;
import com.irdstudio.sdk.beans.core.util.POJOUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.util.ReflectionTestUtils;

public class PaasTemplateParamDao {
    private static final Logger logger = LoggerFactory.getLogger(PaasTemplateParamDao.class);
    Connection conn = null;

    public PaasTemplateParamDao(Connection conn) {
        this.conn = conn;
    }

    public List<PaasTemplateParam> queryPaasTemplateParam(final PaasTemplateParam paramVO) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_template_param");
                List vals = POJOUtils.getPOJOValues((Object)((Object)paramVO));
                for (Object[] val : vals) {
                    this.WHERE(String.format("%s = ?", val[0].toString()));
                    param.add(val[1]);
                }
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasTemplateParam> list = new ArrayList<PaasTemplateParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasTemplateParam bean = (PaasTemplateParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasTemplateParam.class));
                if (StringUtils.isBlank((CharSequence)bean.getParamSource())) {
                    bean.setParamSource(ParamSource.Const.getCode());
                }
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("queryPaasTemplateParamList is wrong", e);
        }
        return list;
    }

    public int deleteByAppTemplateId(final String appTemplateId) throws SQLException {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.DELETE_FROM("`allinpaas_db`.paas_template_param");
                this.WHERE("app_template_id = ?");
                param.add(appTemplateId);
            }
        }.toString();
        PreparedStatement ps = null;
        Object rs = null;
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            int re = ps.executeUpdate();
            return re;
        }
        catch (Exception e) {
            throw new RuntimeException("deleteByAppTemplateId is wrong", e);
        }
    }

    public PaasTemplateParam queryPaasTemplateParamByCode(final String appTemplateId, final String paramCode) {
        final ArrayList param = new ArrayList();
        String sql = new ProxySQL(){
            {
                this.SELECT("*");
                this.FROM("`allinpaas_db`.paas_template_param");
                this.WHERE("app_template_id = ? ");
                param.add(appTemplateId);
                this.WHERE("param_code = ? ");
                param.add(paramCode);
            }
        }.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<PaasTemplateParam> list = new ArrayList<PaasTemplateParam>();
        try {
            ps = this.conn.prepareStatement(sql);
            for (int i = 0; i < param.size(); ++i) {
                ps.setObject(i + 1, param.get(i));
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                PaasTemplateParam bean = (PaasTemplateParam)((Object)POJOUtils.generatePOJO((ResultSet)rs, PaasTemplateParam.class));
                list.add(bean);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("query queryPaasAppsParamList is wrong", e);
        }
        return list.isEmpty() ? null : (PaasTemplateParam)((Object)list.get(0));
    }

    public Map<String, Object> queryTemplateParamMap(String appTemplateId, String envId) throws SQLException {
        PaasTemplateParam param = new PaasTemplateParam();
        param.setAppTemplateId(appTemplateId);
        List<PaasTemplateParam> paramList = this.queryPaasTemplateParam(param);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasTemplateParam p : paramList) {
                paramMap.put(p.getParamCode(), this.parseParamValue(p.getParamSource(), p.getParamValue(), envId, this.conn));
            }
        }
        return paramMap;
    }

    public String parseParamValue(String paramSource, String paramValue, String envId, Connection conn) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        String[] values = StringUtils.split((String)paramValue, (String)".");
        if (values == null || values.length < 2) {
            return "";
        }
        String value = "";
        try {
            String paasCatalogId = values[0];
            String fieldCode = values[1];
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEnvId(envId);
            ecsParam.setPaasDuId(paasCatalogId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                String prop;
                PaasEcsInfo ecs = ecsList.get(0);
                Object obj = ReflectionTestUtils.invokeGetterMethod((Object)((Object)ecs), (String)(prop = TmModelUtil.fieldToProperty((String)fieldCode)));
                value = obj != null ? obj.toString() : "";
            } else {
                value = "";
                logger.info("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5bf9\u5e94\u670d\u52a1\u5668\u8bb0\u5f55\u4e3a\u7a7a " + paramValue + " envId:" + envId);
            }
        }
        catch (Exception e) {
            logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5931\u8d25 " + paramValue, (Throwable)e);
        }
        return value;
    }
}

