/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.alibaba.fastjson.JSON;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelJoinDetailDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelJoinDetail;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeContext;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelSubpageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.ParamType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.test.util.ReflectionTestUtils;

public abstract class AbstractBuilderPlugin
extends AbstractPlugin {
    Formatter javaFormatter = new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build());
    private String sdTemplate = null;

    public void produceCodeFile(String templateFile, String modelName, String codePath, PaasAppsInfo appInfo, CodeTemplateDataBo ctdb) throws Exception {
        this.produceCodeFile(templateFile, CodeGenerateConstant.TABLE_VAR_NOSPLIT, modelName, codePath, appInfo, ctdb);
    }

    public void produceCodeFile(String templateFile, String replaceStr, String modelName, String codePath, PaasAppsInfo appInfo, CodeTemplateDataBo ctdb) throws Exception {
        String tableModelCode = (String)ctdb.getMapData().get("tableModelCode");
        String modelClassName = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        this.produceCodeFile(templateFile, modelClassName, replaceStr, modelName, codePath, appInfo, ctdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceCodeFile(String templateFile, String replaceTarget, String replaceStr, String modelName, String codePath, PaasAppsInfo appInfo, CodeTemplateDataBo ctdb) throws Exception {
        block7: {
            String fileNameResult;
            block8: {
                String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
                String templatePath = SdEnvUtil.getTemplatePath(appInfo, this.getSdTemplate());
                ctdb.getMapData().put("TEMPLATE_PATH", templatePath);
                String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + String.format("%s-%s", appCode, modelName).replace(".", "-") + File.separator + codePath;
                if (modelName == null) {
                    targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + codePath;
                }
                if (!MyFileUtil.checkFileExist(targetPath = AbstractBuilderPlugin.pathMatchSystem(targetPath)).booleanValue()) {
                    File targetDic = new File(targetPath);
                    targetDic.mkdirs();
                }
                fileNameResult = templateFile.replaceAll(replaceStr, replaceTarget);
                fileNameResult = fileNameResult.replaceAll(CodeGenerateConstant.TABLE_VAR_SPLIT, replaceTarget.replace("_", "-"));
                String outputFileName = targetPath + fileNameResult;
                ctdb.getMapData().put("TmModelUtil", new TmModelUtil());
                FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
                if (!fileNameResult.endsWith(".java")) break block8;
                FileInputStream io = null;
                FileOutputStream out = null;
                try {
                    io = new FileInputStream(new File(outputFileName));
                    String sourceJavaCode = IOUtils.toString((InputStream)io, (String)"utf-8");
                    String formatted = this.javaFormatter.formatSource(sourceJavaCode);
                    out = new FileOutputStream(new File(outputFileName));
                    IOUtils.write((String)formatted, (OutputStream)out, (String)"utf-8");
                }
                catch (Exception e) {
                    try {
                        this.logger.error(fileNameResult + "\u683c\u5f0f\u5316\u5931\u8d25 " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(io);
                        IOUtils.closeQuietly(out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)io);
                    IOUtils.closeQuietly(out);
                    break block7;
                }
                IOUtils.closeQuietly((InputStream)io);
                IOUtils.closeQuietly((OutputStream)out);
                break block7;
            }
            if (fileNameResult.endsWith(".xml")) {
                // empty if block
            }
        }
    }

    public static String pathMatchSystem(String path) {
        String targetSeparetor = File.separator;
        if (targetSeparetor.equals("\\")) {
            if (path.contains("/")) {
                // empty if block
            }
        } else if (targetSeparetor.equals("/") && path.contains("\\")) {
            path = path.replaceAll("\\\\", "/");
        }
        return path;
    }

    public static String formatClassPath(String appCode) {
        return appCode.replace(".", "/").replace("-", "/").replace("_", "/");
    }

    public ModelTableInfoBo generateTableBO(ModelTableInfo table, Connection conn) {
        try {
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            List<ModelTableField> fields = modelTableFieldDao.queryModelTableFieldList(table.getObjectId());
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
            HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
            if (CollectionUtils.isNotEmpty(fields)) {
                for (ModelTableField field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)((Object)field), (Object)fieldBo);
                    if (StringUtils.isBlank((CharSequence)fieldBo.getFieldName())) {
                        fieldBo.setFieldName("");
                    }
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldId(), fieldBo);
                }
            }
            tableBo.setFieldList(fieldBos);
            tableBo.setFieldMap(fieldMap);
            return tableBo;
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), e);
            return null;
        }
    }

    ModelTableInfoBo generateTableBO(ModelTableInfo table, String srvModelCatalog, String srvModelType, Connection conn) {
        try {
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            List<ModelTableField> fields = modelTableFieldDao.queryModelTableFieldList(table.getObjectId(), srvModelCatalog, srvModelType);
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
            HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
            if (CollectionUtils.isNotEmpty(fields)) {
                for (ModelTableField field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)((Object)field), (Object)fieldBo);
                    if (StringUtils.isBlank((CharSequence)fieldBo.getFieldName())) {
                        fieldBo.setFieldName("");
                    }
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBo.setSrvParamFlag(field.getFieldFlag());
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldId(), fieldBo);
                }
            }
            tableBo.setFieldList(fieldBos);
            tableBo.setFieldMap(fieldMap);
            return tableBo;
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), e);
            return null;
        }
    }

    public ModelTableInfoBo generateModelTableJoinDetail(ModelTableInfoBo modelTableBo, Connection conn) {
        try {
            ModelJoinDetailDao modelJoinDetailDao = new ModelJoinDetailDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            ModelJoinDetail joinParam = new ModelJoinDetail();
            joinParam.setJoinDetailId(modelTableBo.getTableId());
            List<ModelJoinDetail> joinList = modelJoinDetailDao.queryModelJoinDetailList(joinParam);
            if (CollectionUtils.isNotEmpty(joinList)) {
                HashMap<String, ModelTableField> fieldSetMap = new HashMap<String, ModelTableField>();
                ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>();
                HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>();
                for (ModelJoinDetail joinDetail : joinList) {
                    List<ModelTableField> joinFieldList = modelTableFieldDao.queryModelTableFieldList(joinDetail.getObjectId());
                    if (!CollectionUtils.isNotEmpty(joinFieldList)) continue;
                    for (ModelTableField field : joinFieldList) {
                        if (fieldSetMap.get(field.getFieldCode()) != null) continue;
                        ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                        BeanUtils.copyProperties((Object)((Object)field), (Object)fieldBo);
                        String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                        fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                        fieldBo.setJavaPropertyName(javaPropertyName);
                        fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                        fieldBo.setTableAndFieldCode(String.format("%s.%s", joinDetail.getObjectCode(), field.getFieldCode()));
                        fieldBos.add(fieldBo);
                        fieldMap.put(field.getFieldId(), fieldBo);
                        fieldMap.put(field.getFieldCode(), fieldBo);
                        fieldSetMap.put(field.getFieldCode().toLowerCase(), field);
                    }
                }
                modelTableBo.setFieldList(fieldBos);
                modelTableBo.setFieldMap(fieldMap);
            }
            return modelTableBo;
        }
        catch (Exception e) {
            this.logger.error("\u52a0\u8f7d\u5173\u8054\u8868 ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), e);
            return null;
        }
    }

    public Map<String, Object> wrapAppsParam(String appId, CodeTemplateDataBo dataBo, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        PaasAppsParam param = new PaasAppsParam();
        param.setAppId(appId);
        List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
        HashMap<String, Object> appsParam = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramList)) {
            for (PaasAppsParam p : paramList) {
                appsParam.put(p.getParamCode(), p.getParamValue());
            }
        }
        PaasEnvParam paasEnvParam = new PaasEnvParam();
        paasEnvParam.setEnvId("paas");
        List<PaasEnvParam> envList = paasEnvParamDao.queryPaasEnvParamList(paasEnvParam);
        HashMap<String, String> envParam = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(envList)) {
            for (PaasEnvParam ep : envList) {
                envParam.put(ep.getParamCode(), ep.getParamValue());
            }
        }
        if (dataBo != null) {
            dataBo.getMapData().put("appsParam", appsParam);
            dataBo.getMapData().put("envParam", envParam);
        }
        return appsParam;
    }

    public void wrapEnvInfoParam(String envId, PaasAppsInfo appInfo, CodeTemplateDataBo dataBo, Connection conn) throws Exception {
        Map appsParam;
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasEnvParam paasEnvParam = new PaasEnvParam();
        paasEnvParam.setEnvId(envId);
        List<PaasEnvParam> envList = paasEnvParamDao.queryPaasEnvParamList(paasEnvParam);
        HashMap<String, String> envParam = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(envList)) {
            for (PaasEnvParam ep : envList) {
                envParam.put(ep.getParamCode(), ep.getParamValue());
            }
        }
        PaasEcsInfo ecsParam = new PaasEcsInfo();
        ecsParam.setEnvId(envId);
        ecsParam.setPaasDuId("A000001");
        List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
        if (CollectionUtils.isNotEmpty(ecsList)) {
            PaasEcsInfo ecs = ecsList.get(0);
            String registerAdd = ecs.getEcsIp();
            String registerPort = StringUtils.isNotBlank((CharSequence)ecs.getEcsPort()) ? ecs.getEcsPort() : "2181";
            envParam.put("registry_address", registerAdd + ":" + registerPort);
            envParam.put("registry_type", "zookeeper");
        }
        if ((appsParam = MapUtils.getMap((Map)dataBo.getMapData(), (Object)"appsParam")) != null) {
            ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(appInfo.getSubsId());
            ecsParam.setAppId(appInfo.getAppId());
            ecsParam.setEnvId(envId);
            ecsParam.setPaasDuId("D000001");
            ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            String server_port = MapUtils.getString((Map)appsParam, (Object)"server_port", (String)"8080");
            if (CollectionUtils.isNotEmpty(ecsList) && StringUtils.isNotBlank((CharSequence)ecsList.get(0).getEcsPort())) {
                server_port = ecsList.get(0).getEcsPort();
            }
            appsParam.put("server_port", server_port);
        }
        dataBo.getMapData().put("envInfoParam", envParam);
        Map<String, Object> ecsInfoParam = paasAppsParamDao.loadEcsParam(appInfo.getAppId(), envId);
        dataBo.getMapData().put("ecsParam", ecsInfoParam);
        this.getDatabaseConfig(envId, appInfo, appsParam, paasEcsInfoDao);
    }

    public void getDatabaseConfig(String envId, PaasAppsInfo appInfo, Map<String, Object> appsParam, PaasEcsInfoDao paasEcsInfoDao) throws Exception {
        PaasEcsInfo ecsParam = new PaasEcsInfo();
        ecsParam.setSubsId(appInfo.getSubsId());
        ecsParam.setAppId(appInfo.getAppId());
        ecsParam.setEnvId(envId);
        ecsParam.setPaasDuId("G000001");
        List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
        String database_name = "";
        String database_username = "root";
        String database_password = "Zaqpwdxsw@2";
        database_name = TdpAgentCommonUtil.getAppDatabaseName(appInfo);
        appsParam.put("database_name", database_name);
        database_username = MapUtils.getString(appsParam, (Object)"database_username", (String)"root");
        appsParam.put("database_username", database_username);
        database_password = MapUtils.getString(appsParam, (Object)"database_password", (String)"Zaqpwdxsw@2");
        appsParam.put("database_password", database_password);
        if (CollectionUtils.isNotEmpty(ecsList)) {
            PaasEcsInfo ecs = ecsList.get(0);
            appsParam.put("database_ip", ecs.getEcsIp());
            appsParam.put("database_port", ecs.getEcsPort());
        } else {
            appsParam.put("database_ip", "47.119.20.139");
            appsParam.put("database_port", "3306");
        }
    }

    public String getPackagePrefix(CodeTemplateDataBo dataBo) {
        Map appsParam = MapUtils.getMap((Map)dataBo.getMapData(), (Object)"appsParam");
        String path = "com/fdb";
        if (appsParam != null) {
            String package_prefix = MapUtils.getString((Map)appsParam, (Object)"package_prefix", (String)"com.fdb");
            path = package_prefix.replaceAll("\\.", "/");
        }
        return path;
    }

    public String getSdTemplate() {
        return "";
    }

    public String parseParamValue(String paramSource, String paramValue, String envId, Connection conn) {
        if (ParamSource.Const.getCode().equals(paramSource)) {
            return paramValue;
        }
        PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
        String[] values = StringUtils.split((String)paramValue, (String)".");
        if (values == null || values.length < 2) {
            return "";
        }
        String value = "";
        try {
            String paasCatalogId = values[0];
            String fieldCode = values[1];
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEnvId(envId);
            ecsParam.setPaasDuId(paasCatalogId);
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                String prop;
                PaasEcsInfo ecs = ecsList.get(0);
                Object obj = ReflectionTestUtils.invokeGetterMethod((Object)((Object)ecs), (String)(prop = TmModelUtil.fieldToProperty((String)fieldCode)));
                value = obj != null ? obj.toString() : "";
            } else {
                value = "";
                this.logger.info("\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5bf9\u5e94\u670d\u52a1\u5668\u8bb0\u5f55\u4e3a\u7a7a " + paramValue + " envId:" + envId);
            }
        }
        catch (Exception e) {
            this.logger.error("\u89e3\u6790\u4ea4\u4ed8\u73af\u5883\u53d8\u91cf\u5931\u8d25 " + paramValue, e);
        }
        return value;
    }

    public void wrapComponentParams(String envId, PaasAppsInfo appInfo, CodeTemplateDataBo dataBo, Connection conn) {
        try {
            List<String> compTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            List<PaasAppsInfo> needImportTApps = paasAppsInfoDao.queryReferenceApp(appInfo.getAppId());
            ArrayList compParamList = new ArrayList();
            if (CollectionUtils.isNotEmpty(needImportTApps)) {
                for (PaasAppsInfo comp : needImportTApps) {
                    if (!compTypes.contains(comp.getAppType())) continue;
                    PaasAppsParam param = new PaasAppsParam();
                    param.setAppId(comp.getAppId());
                    List<PaasAppsParam> paramList = paasAppsParamDao.queryPaasAppsParamList(param);
                    if (!CollectionUtils.isNotEmpty(paramList)) continue;
                    HashMap<String, Object> compParam = new HashMap<String, Object>();
                    compParam.put("appCode", comp.getAppCode());
                    compParam.put("appName", comp.getAppName());
                    ArrayList params = new ArrayList(paramList.size());
                    compParam.put("params", params);
                    compParamList.add(compParam);
                    for (PaasAppsParam p : paramList) {
                        String key = p.getParamCode();
                        String value = this.parseParamValue(p.getParamSource(), p.getParamValue(), envId, conn);
                        HashMap<String, String> pMap = new HashMap<String, String>();
                        pMap.put("prop", String.format("%s = %s", key, value));
                        pMap.put("comment", "## " + p.getParamName());
                        params.add(pMap);
                    }
                }
            }
            dataBo.getMapData().put("compParamList", compParamList);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7ec4\u4ef6\u5e94\u7528\u53c2\u6570\u5931\u8d25", e);
        }
    }

    public String wrapperTableToClassName(String tableModelCode, String objectType, String tableModelId) {
        if (StringUtils.endsWithAny((CharSequence)tableModelCode, (CharSequence[])new CharSequence[]{"DO", "VO"})) {
            return tableModelCode;
        }
        String className = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        ObjectType type = ObjectType.getType((String)objectType);
        if (type == null) {
            return className;
        }
        switch (type) {
            case Table: 
            case Main: 
            case Second: {
                className = className + "DO";
                break;
            }
            case Data: 
            case FreeStyleData: 
            case Inout: 
            case Common: {
                className = className + "VO";
                break;
            }
        }
        return className;
    }

    public String judgeTableToClassName(String tableModelCode, String objectType, String tableModelId) {
        ObjectType type = ObjectType.getType((String)objectType);
        String className = TmModelUtil.tableCodeToClassName((String)tableModelCode);
        switch (type) {
            case Table: 
            case Main: 
            case Second: {
                return OsrvArrangeImport.ImportType.DO.getCode();
            }
            case Data: 
            case FreeStyleData: 
            case Inout: {
                return OsrvArrangeImport.ImportType.VO.getCode();
            }
            case Common: {
                return OsrvArrangeImport.ImportType.SDK.getCode();
            }
        }
        return "";
    }

    public String getDefaultParameterClassName(String srvModelCode, String methodName, IOType ioType) {
        return String.format("%s%s%s", StringUtils.capitalize((String)srvModelCode), StringUtils.capitalize((String)methodName), ioType.getSuffix());
    }

    public String getBigDTOClassName(String srvModelCode, String methodName, IOType ioType) {
        return String.format("%s%s%s", StringUtils.capitalize((String)srvModelCode), StringUtils.capitalize((String)methodName), StringUtils.capitalize((String)ioType.toString()));
    }

    public String getMethodParam(List<SrvModelInout> params, OsrvArrangeContext osrvCtx, String suffix) {
        if (!CollectionUtils.isNotEmpty(params) || params.size() == 1) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty(params)) {
            if (StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelCatalog(), (CharSequence)SrvModelCatalogEnum.BackServer.getCode()) && !StringUtils.equals((CharSequence)osrvCtx.getSrvModelInfo().getSrvModelType(), (CharSequence)SrvModelTypeEnum.CUSTOM_BACK_SERVICE.getType())) {
                String name = "";
                if (suffix.equalsIgnoreCase("input")) {
                    String tableModelCode = osrvCtx.getSrvModelInfo().getTableModelCode() + "_input";
                    String className = this.wrapperTableToClassName(tableModelCode, ObjectType.Inout.getCode(), null);
                    name = String.format("%s<%s>", "ServiceInput", className);
                    OsrvArrangeImport genClassImport = new OsrvArrangeImport();
                    genClassImport.setImportType(this.judgeTableToClassName(tableModelCode, ObjectType.Inout.getCode(), null));
                    genClassImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                    genClassImport.setClassName(className);
                    osrvCtx.addImport(genClassImport);
                    osrvCtx.getMethod().setMainInputClass(className);
                } else {
                    SrvModelInout inout = params.get(0);
                    String className = this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                    name = String.format("%s<%s>", "ServiceOutput", className);
                    OsrvArrangeImport genClassImport = new OsrvArrangeImport();
                    genClassImport.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                    genClassImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                    genClassImport.setClassName(className);
                    osrvCtx.addImport(genClassImport);
                    osrvCtx.getMethod().setMainOutputClass(className);
                }
                OsrvArrangeImport domainImport = new OsrvArrangeImport();
                domainImport.setImportType(OsrvArrangeImport.ImportType.SDK.getCode());
                domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
                domainImport.setClassName(suffix.equalsIgnoreCase("input") ? "ServiceInput" : "ServiceOutput");
                osrvCtx.addImport(domainImport);
                return name;
            }
            String name = osrvCtx.getTableClassName() + StringUtils.capitalize((String)osrvCtx.getMethod().getMethodName()) + suffix;
            OsrvArrangeImport domainImport = new OsrvArrangeImport();
            domainImport.setImportType(OsrvArrangeImport.ImportType.DTO.getCode());
            domainImport.setProjectCode(osrvCtx.getAppInfo().getAppCode());
            domainImport.setClassName(name);
            osrvCtx.addImport(domainImport);
            String serviceClass = "";
            if (suffix.equalsIgnoreCase("input")) {
                String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
                String bigClass = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Input);
                String mainParam_className = this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
                String className = this.wrapperTableToClassName(bigClass, null, null);
                osrvCtx.getMethod().setMainInputClass(mainParam_className);
                osrvCtx.getMethod().setMainBigInputClass(className);
                serviceClass = "ServiceInput";
            } else {
                String mainParam = this.getDefaultParameterClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Output);
                String bigClass = this.getBigDTOClassName(osrvCtx.getSrvModelInfo().getSrvModelCode(), osrvCtx.getMethod().getMethodName(), IOType.Output);
                String mainParam_className = this.wrapperTableToClassName(mainParam, ObjectType.Inout.getCode(), null);
                String className = this.wrapperTableToClassName(bigClass, null, null);
                osrvCtx.getMethod().setMainOutputClass(mainParam_className);
                osrvCtx.getMethod().setMainBigOutputClass(className);
                serviceClass = "ServiceOutput";
            }
            name = String.format("%s<%s>", serviceClass, name);
            return name;
        }
        return null;
    }

    public List<OsrvArrangeDependency> querySubsSDKDependencies(SSubsInfo subsInfo, Connection conn) throws Exception {
        if (StringUtils.isBlank((CharSequence)subsInfo.getArchType())) {
            return Collections.emptyList();
        }
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        List<PaasAppsInfo> sdkList = paasAppsInfoDao.querySDKApp(subsInfo.getArchType());
        if (CollectionUtils.isNotEmpty(sdkList)) {
            ArrayList<OsrvArrangeDependency> dependencies = new ArrayList<OsrvArrangeDependency>(sdkList.size());
            for (PaasAppsInfo sdk : sdkList) {
                if (StringUtils.isBlank((CharSequence)sdk.getAppMavenPom())) continue;
                OsrvArrangeDependency dependency = new OsrvArrangeDependency(sdk.getAppMavenPom());
                dependencies.add(dependency);
            }
            return dependencies;
        }
        return Collections.emptyList();
    }

    public String wrapperPath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public String replaceSuffix(String fileName) {
        if (fileName.lastIndexOf(".") >= 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    public boolean renderOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath, Map<String, Object> root, String targetPath, String packagePath, File targetDir) throws Exception {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = false;
        if (tempFile.exists()) {
            String content = FreemarkerUtil.produceStringByTemplate((String)appTemplatePath, (String)templateFile, root);
            File contentTargetDir = new File(targetPath + File.separator + packagePath);
            if (!contentTargetDir.exists()) {
                contentTargetDir.mkdirs();
            }
            String fileName = this.replaceSuffix(pageModelCode) + suffix;
            File file = new File(targetDir, fileName);
            try (FileOutputStream output = new FileOutputStream(file);){
                IOUtils.write((String)content, (OutputStream)output, (String)"utf-8");
            }
            flag = true;
        }
        return flag;
    }

    public boolean checkOtherTemplate(String pageModelCode, String templateName, String suffix, String appTemplatePath) {
        String templateFile = templateName + suffix + ".vm";
        String tempPath = appTemplatePath + File.separator + templateFile;
        File tempFile = new File(tempPath);
        boolean flag = tempFile.exists();
        return flag;
    }

    public Map<String, Object> prepareParam(PageModelInfoDTO modelInfo, List<PageModelParamDTO> paramList, String appTemplatePath, String basePath) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("BASE_PATH", "../../../");
        Pattern listReg = Pattern.compile("(\\S+)\\[(\\d+)\\]");
        if (CollectionUtils.isNotEmpty(paramList)) {
            HashMap quickMap = new HashMap();
            for (PageModelParamDTO param : paramList) {
                String paramCode = param.getParamCode();
                if (!ParamType.kv.getCode().equals(param.getParamType())) {
                    if (CollectionUtils.isNotEmpty((Collection)param.getFields()) && (ParamType.fields.getCode().equals(param.getParamType()) || ParamType.formFields.getCode().equals(param.getParamType()))) {
                        root.put(paramCode, param.getFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getQueryFields()) && ParamType.conds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getQueryFields());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getButtons()) && ParamType.buttons.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getButtons());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getLinkeds()) && ParamType.linkeds.getCode().equals(param.getParamType())) {
                        root.put(paramCode, param.getLinkeds());
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)param.getSubspages()) && ParamType.subpages.getCode().equals(param.getParamType())) {
                        List subpages = param.getSubspages();
                        ArrayList<Map<String, Object>> subPageMapList = new ArrayList<Map<String, Object>>();
                        if (CollectionUtils.isNotEmpty((Collection)subpages)) {
                            for (PageModelSubpageDTO sub : subpages) {
                                Map<String, Object> subPageParam = this.fetchSubPageParam(modelInfo, sub, sub.getModelInfo(), appTemplatePath, basePath);
                                subPageMapList.add(subPageParam);
                            }
                        }
                        root.put(paramCode, subPageMapList);
                        continue;
                    }
                    try {
                        List list = JSON.parseArray((String)param.getParamValue(), Map.class);
                        root.put(paramCode, list);
                    }
                    catch (Exception e) {
                        this.logger.error("\u89e3\u6790\u53c2\u6570json\u5f02\u5e38" + e.getMessage(), e);
                    }
                    continue;
                }
                String[] paths = StringUtils.split((String)paramCode, (String)".");
                if (paths == null) {
                    root.put(paramCode, this.parseParamValue(param));
                    continue;
                }
                Map<String, Object> var = root;
                for (int i = 0; i < paths.length; ++i) {
                    String key;
                    String path = paths[i];
                    Matcher m = listReg.matcher(path);
                    boolean isList = m.matches();
                    if (isList) {
                        int k;
                        List<Object> list;
                        key = m.group(1);
                        int index = Integer.valueOf(m.group(2));
                        if (paths.length - 1 == i) {
                            list = (ArrayList<Object>)var.get(key);
                            if (list == null) {
                                list = new ArrayList<Object>(index);
                                var.put(key, list);
                            }
                            if (list.size() <= index) {
                                for (k = list.size(); k <= index; ++k) {
                                    list.add(null);
                                }
                            }
                            list.set(index, this.parseParamValue(param));
                            continue;
                        }
                        list = (List)var.get(key);
                        if (list == null) {
                            list = new ArrayList(index);
                            var.put(key, list);
                        }
                        if (list.size() <= index) {
                            for (k = list.size(); k <= index; ++k) {
                                list.add(new HashMap());
                            }
                        }
                        if ((var = (Map)list.get(index)) != null) continue;
                        var = new HashMap();
                        list.set(index, var);
                        continue;
                    }
                    key = path;
                    if (paths.length - 1 == i) {
                        var.put(key, this.parseParamValue(param));
                        continue;
                    }
                    HashMap temp = (HashMap)var.get(key);
                    if (temp == null) {
                        temp = new HashMap();
                        var.put(key, temp);
                    }
                    var = temp;
                }
            }
        }
        return root;
    }

    public String parseParamValue(PageModelParamDTO param) {
        if (param == null) {
            return "";
        }
        return param.getParamValue();
    }

    public Map<String, String> createPackageMap(List<PageModelPackageDTO> packageList) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(packageList)) {
            HashMap<String, PageModelPackageDTO> map = new HashMap<String, PageModelPackageDTO>();
            for (PageModelPackageDTO p : packageList) {
                map.put(p.getPackageId(), p);
            }
            for (PageModelPackageDTO p : packageList) {
                ArrayList<String> paths = new ArrayList<String>();
                paths.add(p.getPackageCode());
                PageModelPackageDTO parent = (PageModelPackageDTO)map.get(p.getPackageAbvId());
                while (parent != null) {
                    paths.add(parent.getPackageCode());
                    parent = (PageModelPackageDTO)map.get(parent.getPackageAbvId());
                }
                Collections.reverse(paths);
                pathMap.put(p.getPackageId(), StringUtils.join(paths, (String)File.separator));
            }
        }
        return pathMap;
    }

    public String getBasePath(String packagePath) {
        String[] pathNum = StringUtils.split((String)packagePath, (String)File.separator);
        int deep = pathNum.length;
        ++deep;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= deep; ++i) {
            list.add("../");
        }
        return StringUtils.join(list, (String)"");
    }

    public Map<String, String> createRoute(String packagePath, File page) {
        Object[] paths = StringUtils.split((String)(packagePath + File.separator + this.replaceSuffix(page.getName())), (String)File.separator);
        String path = StringUtils.join((Object[])paths, (String)"/");
        HashMap<String, String> route = new HashMap<String, String>();
        route.put("path", path);
        route.put("name", StringUtils.join((Object[])paths, (String)"-"));
        route.put("pageName", page.getName());
        return route;
    }

    public Map<String, Object> fetchSubPageParam(PageModelInfoDTO rootModelInfo, PageModelSubpageDTO subPage, PageModelInfoDTO modelInfo, String appTemplatePath, String basePath) {
        if (modelInfo != null) {
            PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
            PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
            PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
            PageModelParamDTO param = new PageModelParamDTO();
            param.setPageModelId(modelInfo.getPageModelId());
            param.setSize(Integer.valueOf(1000));
            param.setQueryRef("query");
            List paramList = pageModelParamService.queryList((Object)param);
            if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                this.logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                return Collections.emptyMap();
            }
            PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
            templateParam.setPageTemplateId(modelInfo.getPageTemplateId());
            PageTemplateInfoDTO template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)templateParam);
            PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
            fileParam.setPageTemplateId(template.getPageTemplateId());
            List fileList = pageTemplateFileService.queryList((Object)fileParam);
            String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateId();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                PageTemplateFileDTO file = (PageTemplateFileDTO)fileList.get(0);
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (tempFile.exists()) {
                    Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                    ArrayList dataCodes = new ArrayList();
                    paramList.forEach(pageModelParamVO -> {
                        List fields = pageModelParamVO.getFields();
                        if (CollectionUtils.isNotEmpty((Collection)fields)) {
                            fields.forEach(f -> {
                                if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                    dataCodes.add(f.getFieldOption());
                                }
                            });
                        }
                    });
                    String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                    root.put("templateName", templateName);
                    root.put("templateFilePrefix", this.replaceSuffix(file.getFileName()));
                    root.put("rootModelInfo", rootModelInfo);
                    root.put("subPage", subPage);
                    root.put("BASE_PATH", basePath);
                    root.put("pageModelInfo", modelInfo);
                    root.put("dataCodeJoin", dataCodeJoin);
                    root.put("localAppTemplatePath", localAppTemplatePath);
                    ArrayList<String> jsList = new ArrayList<String>();
                    File localTemplateFile = new File(localAppTemplatePath);
                    if (localTemplateFile.exists()) {
                        File[] files;
                        for (File f : files = localTemplateFile.listFiles()) {
                            if (!StringUtils.endsWithAny((CharSequence)f.getName(), (CharSequence[])new CharSequence[]{".js.vm"})) continue;
                            jsList.add(f.getName());
                        }
                    }
                    root.put("jsList", jsList);
                    boolean jsFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath);
                    boolean cssFlag = this.checkOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath);
                    root.put("jsFlag", jsFlag);
                    root.put("cssFlag", cssFlag);
                    return root;
                }
            }
        }
        return Collections.emptyMap();
    }
}

