/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class AppStartPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        boolean result = true;
        Connection conn = null;
        try {
            String loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
            String subsId = this.appInfo.getSubsId();
            conn = this.getPluginConnection();
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo e4aParam = new PaasAppsInfo();
            e4aParam.setSubsId(subsId);
            e4aParam.setAppType(AppType.A10.getCode());
            e4aParam.setAppTemplateId("A13SPR");
            List<PaasAppsInfo> e4aList = paasAppsInfoDao.queryPaasAppsInfoList(e4aParam);
            Map e4aMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(e4aList)) {
                PaasAppsInfo e4aApp = e4aList.get(0);
                Map<String, Object> e4aAppParam = this.wrapAppsParam(e4aApp.getAppId(), null, conn);
                String appCode = SdEnvUtil.wrapperAppCode(e4aApp.getAppCode());
                String package_prefix = MapUtils.getString(e4aAppParam, (Object)"package_prefix", (String)"com.irdstudio");
                String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
                String replacePackage = package_prefix + "." + newAppCode;
                e4aMap = BeanUtility.bean2Map((Object)((Object)e4aApp));
                e4aMap.put("filterClass", String.format("%s.facade.filter.E4AFilter", replacePackage));
            }
            CodeTemplateDataBo bo = new CodeTemplateDataBo();
            TmProjectInfoBo tpib = new TmProjectInfoBo();
            tpib.setProjectId(this.appInfo.getAppCode());
            tpib.setProjectCode(this.appInfo.getAppCode());
            tpib.setProjectName(this.appInfo.getAppName());
            bo.setTmProjectInfo(tpib);
            bo.getEnvBo().setAuthor(loginUserId);
            bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
            bo.getEnvBo().setDesc(String.format("%s Application", this.appInfo.getAppName()));
            bo.getMapData().put("e4a", e4aMap);
            this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
            Map appParams = (Map)bo.getMapData().get("appsParam");
            String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
            String package_prefix = MapUtils.getString((Map)appParams, (Object)"package_prefix", (String)"com.irdstudio");
            String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
            String replacePackage = package_prefix + "." + newAppCode;
            SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
            List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo, conn);
            bo.getMapData().put("sdkList", dependencies);
            bo.getMapData().put("tableModelCode", appCode.replaceAll("-", "_"));
            bo.getMapData().put("tableCodeToClassName", TmModelUtil.tableCodeToClassName((String)appCode.replaceAll("-", "_")));
            if (StringUtils.equalsAny((CharSequence)this.appInfo.getAppTemplateId(), (CharSequence[])new CharSequence[]{"dynpage"})) {
                String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + String.format("%s-%s", appCode, "start").replace(".", "-") + File.separator + "src/main/java/" + AppStartPlugin.formatClassPath(package_prefix) + "/" + AppStartPlugin.formatClassPath(appCode) + "/start/";
                File securityConfigFile = new File(targetPath + File.separator + "config", "SecurityConfig.java");
                File fadpaasConsoleApplicationFile = new File(targetPath, "FadpaasConsoleApplication.java");
                File dynpageCode = new File(SdEnvUtil.PROJECT_PATH + appCode + File.separator, "dynpage-code");
                File dynpageScript = new File(SdEnvUtil.PROJECT_PATH + appCode + File.separator, "dynpage-script");
                FileUtils.deleteQuietly((File)securityConfigFile);
                FileUtils.deleteQuietly((File)fadpaasConsoleApplicationFile);
                FileUtils.deleteQuietly((File)dynpageCode);
                FileUtils.deleteQuietly((File)dynpageScript);
                this.produceCodeFile("domain-pom.xml", "", "domain-", "domain", "", this.appInfo, bo);
                this.produceCodeFile("facade-pom.xml", "", "facade-", "facade", "", this.appInfo, bo);
                this.produceCodeFile("web-pom.xml", "", "web-", "web", "", this.appInfo, bo);
                this.produceCodeFile("project-pom.xml", "", "project-", null, "", this.appInfo, bo);
            }
            if (!StringUtils.equalsAny((CharSequence)this.appInfo.getAppTemplateId(), (CharSequence[])new CharSequence[]{"S01MOD", "A13SPR"})) {
                this.produceCodeFile("XXXApplication.java", "start", "src/main/java/" + AppStartPlugin.formatClassPath(package_prefix) + "/" + AppStartPlugin.formatClassPath(appCode) + "/start/", this.appInfo, bo);
                this.produceCodeFile("start-pom.xml", "", "start-", "start", "", this.appInfo, bo);
            }
            if (conn == null) return result;
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
            if (conn == null) return result;
            this.closePluginConnection(conn);
            return result;
        }
        catch (Exception e2) {
            this.logger.error(e2.getMessage(), e2);
            result = false;
            if (conn == null) return result;
            {
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    this.closePluginConnection(conn);
                    throw throwable;
                }
            }
            this.closePluginConnection(conn);
            return result;
        }
        this.closePluginConnection(conn);
        return result;
    }
}

