/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeDependency;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class TdpDomainPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private String srvModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.srvModelId = MapUtils.getString(this.extParam, (Object)"srvModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210domain\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId(), Arrays.asList(ObjectType.Table.getIntCode(), ObjectType.Main.getIntCode(), ObjectType.Second.getIntCode()));
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Domain Entity %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    ObjectType objectTypeEnum = ObjectType.getType((String)table.getObjectType().toString());
                    if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                        this.generateModelTableJoinDetail(tableBo, conn);
                    }
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    bo.getMapData().put("objectType", String.valueOf(table.getObjectType()));
                    int inoutNum = srvModelInoutDao.countByTableModelId(this.appInfo.getAppId(), table.getObjectId());
                    if (ObjectType.Table == objectTypeEnum) {
                        ctdbList.add(bo);
                        continue;
                    }
                    if (inoutNum <= 0) continue;
                    ctdbList.add(bo);
                }
            }
            for (CodeTemplateDataBo ctdb : ctdbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                String package_prefix = this.getPackagePrefix(ctdb);
                this.produceCodeFile("XXXDO.java", "domain", "src/main/java/" + package_prefix + "/" + TdpDomainPlugin.formatClassPath(subsCode) + "/domain/entity/", this.appInfo, ctdb);
            }
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
            List<OsrvArrangeDependency> dependencies = this.querySubsSDKDependencies(sSubsInfo, conn);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            pomBo.getMapData().put("sdkList", dependencies);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            String package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("project-pom.xml", "", "project-", null, "", this.appInfo, pomBo);
            this.produceCodeFile("domain-pom.xml", "", "domain-", "domain", "", this.appInfo, pomBo);
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

