/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpInfraclPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private String srvModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.srvModelId = MapUtils.getString(this.extParam, (Object)"srvModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210infracl\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            String package_prefix;
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId(), Arrays.asList(ObjectType.Table.getIntCode(), ObjectType.Main.getIntCode(), ObjectType.Second.getIntCode()));
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
            ModelTableInfo userTokenInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "UserTokenInfo");
            SrvModelInout userTokenInout = new SrvModelInout();
            userTokenInout.setTableModelCode(this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
            userTokenInout.setTableModelName(userTokenInfo.getObjectName());
            userTokenInout.setTableModelId(userTokenInfo.getObjectId());
            userTokenInout.setObjectType(userTokenInfo.getObjectType());
            userTokenInout.setListFlag(YesOrNO.NO.getCode());
            ModelTableInfo isrvRspInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "IsrvRspInfo");
            ModelTableInfo pageInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "PageInfo");
            SrvModelInout pageInfoInout = new SrvModelInout();
            pageInfoInout.setTableModelCode(this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
            pageInfoInout.setTableModelName(pageInfo.getObjectName());
            pageInfoInout.setTableModelId(pageInfo.getObjectId());
            pageInfoInout.setObjectType(pageInfo.getObjectType());
            pageInfoInout.setListFlag(YesOrNO.NO.getCode());
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                    String bigDTOName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "DTO";
                    String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                    ModelTableInfo inputDO = modelTableInfoDao.queryInoutTableModelInfo(this.appInfo.getAppId(), inputDOName);
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String TablebjectType2 = String.valueOf(table.getObjectType());
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    tpib.setProjectType(TablebjectType2);
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Repository %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                        this.generateModelTableJoinDetail(tableBo, conn);
                    }
                    HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                    modelParam.setTableModelId(table.getObjectId());
                    List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam);
                    ArrayList methods = new ArrayList(modelList.size());
                    HashMap imports = new HashMap();
                    Map dataMap = bo.getMapData();
                    dataMap.put("methods", methods);
                    for (SrvModelInfo modelInfo : modelList) {
                        HashMap<String, Object> method = new HashMap<String, Object>();
                        method.put("modelInfo", (Object)modelInfo);
                        method.put("methodName", modelInfo.getSrvModelCode());
                        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                        if (SrvModelTypeEnum.QUERY_BY_PK == srvModelTypeEnum || SrvModelTypeEnum.QUERY_SINGLE == srvModelTypeEnum) {
                            method.put("singleOutput", true);
                        } else {
                            method.put("singleOutput", false);
                        }
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        inoutParam.setIoType(IOType.Input.getCode());
                        List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        SrvModelInout inputSingle = null;
                        for (SrvModelInout inout : inputParams) {
                            if (StringUtils.equals((CharSequence)inputDOName, (CharSequence)inout.getTableModelCode())) {
                                inputSingle = inout;
                            }
                            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                            inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            OsrvArrangeImport importCls = new OsrvArrangeImport();
                            importCls.setClassName(inout.getTableModelCode());
                            importCls.setProjectCode(tpib.getProjectCode());
                            importCls.setTableModelId(inout.getTableModelId());
                            importCls.setImportType(importType);
                            importMap.put(importCls.getClassName(), importCls);
                        }
                        if (srvModelTypeEnum == SrvModelTypeEnum.QUERY) {
                            method.put("input", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                        } else if (srvModelTypeEnum == SrvModelTypeEnum.QUERY_BATCH || srvModelTypeEnum == SrvModelTypeEnum.QUERY_CUSTOMIZE) {
                            method.put("input", Arrays.asList(inputSingle, userTokenInout));
                        } else {
                            SrvModelInout inputTableDO = new SrvModelInout();
                            inputTableDO.setTableModelId(table.getObjectId());
                            inputTableDO.setTableModelCode(table.getObjectCode());
                            inputTableDO.setTableModelName(table.getObjectName());
                            inputTableDO.setObjectType(table.getObjectType());
                            inputTableDO.setIoType(IOType.Input.getCode());
                            inputTableDO.setListFlag(inputSingle.getListFlag());
                            String importType = this.judgeTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId());
                            inputTableDO.setTableModelCode(this.wrapperTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId()));
                            OsrvArrangeImport importCls = new OsrvArrangeImport();
                            importCls.setClassName(inputTableDO.getTableModelCode());
                            importCls.setProjectCode(tpib.getProjectCode());
                            importCls.setTableModelId(inputTableDO.getTableModelId());
                            importCls.setImportType(importType);
                            importMap.put(importCls.getClassName(), importCls);
                            method.put("input", Arrays.asList(inputTableDO, userTokenInout));
                        }
                        inoutParam.setIoType(IOType.Output.getCode());
                        List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        SrvModelInout outputSingle = outputParams.isEmpty() ? null : outputParams.get(0);
                        for (SrvModelInout inout : outputParams) {
                            String importType = this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId());
                            inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            OsrvArrangeImport importCls = new OsrvArrangeImport();
                            importCls.setClassName(inout.getTableModelCode());
                            importCls.setProjectCode(tpib.getProjectCode());
                            importCls.setTableModelId(inout.getTableModelId());
                            importCls.setImportType(importType);
                            importMap.put(importCls.getClassName(), importCls);
                        }
                        method.put("output", (Object)(outputParams.isEmpty() ? null : outputParams.get(0)));
                        methods.add(method);
                    }
                    dataMap.put("importList", importMap.values());
                    int serverNum = srvModelInfoDao.countByTableModelId(this.appInfo.getAppId(), table.getObjectId());
                    if (ObjectType.Table.getCode().equals(String.valueOf(table.getObjectType()))) {
                        ctdbList.add(bo);
                        continue;
                    }
                    if (serverNum <= 0) continue;
                    ctdbList.add(bo);
                }
            }
            for (CodeTemplateDataBo ctdb : ctdbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                package_prefix = this.getPackagePrefix(ctdb);
                Map mapData = ctdb.getMapData();
                TmProjectInfoBo tpib = (TmProjectInfoBo)mapData.get("TmProject");
                this.produceCodeFile("XXXRepository.java", "infracl", "src/main/java/" + package_prefix + "/" + TdpInfraclPlugin.formatClassPath(subsCode) + "/acl/repository/", this.appInfo, ctdb);
            }
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("infracl-pom.xml", "", "infracl-", "infracl", "", this.appInfo, pomBo);
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

