/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvSqlCondDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.IsrvSqlInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelJoinDetailDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlCond;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.IsrvSqlInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelJoinDetail;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeImport;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.types.CondNotEmptyEnum;
import com.irdstudio.allinrdm.dev.console.types.FieldEvalWay;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.allinrdm.dev.console.types.SrvModelTypeEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import de.dknapps.mybatter.main.MyBatter;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpInfrastructurePlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";
    private String srvModelId = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        this.srvModelId = MapUtils.getString(this.extParam, (Object)"srvModelId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210infrastructure\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
            IsrvSqlInfoDao isrvSqlInfoDao = new IsrvSqlInfoDao(conn);
            IsrvSqlCondDao isrvSqlCondDao = new IsrvSqlCondDao(conn);
            ModelJoinDetailDao modelJoinDetailDao = new ModelJoinDetailDao(conn);
            ModelTableInfo userTokenInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "UserTokenInfo");
            SrvModelInout userTokenInout = new SrvModelInout();
            userTokenInout.setTableModelCode(this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
            userTokenInout.setTableModelName(userTokenInfo.getObjectName());
            userTokenInout.setTableModelId(userTokenInfo.getObjectId());
            userTokenInout.setObjectType(userTokenInfo.getObjectType());
            userTokenInout.setListFlag(YesOrNO.NO.getCode());
            ModelTableInfo isrvRspInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "IsrvRspInfo");
            ModelTableInfo pageInfo = modelTableInfoDao.queryCommonTableModelInfo(this.appInfo.getAppId(), "PageInfo");
            SrvModelInout pageInfoInout = new SrvModelInout();
            pageInfoInout.setTableModelCode(this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
            pageInfoInout.setTableModelName(pageInfo.getObjectName());
            pageInfoInout.setTableModelId(pageInfo.getObjectId());
            pageInfoInout.setObjectType(pageInfo.getObjectType());
            pageInfoInout.setListFlag(YesOrNO.NO.getCode());
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId(), Arrays.asList(ObjectType.Table.getIntCode(), ObjectType.Main.getIntCode(), ObjectType.Second.getIntCode()));
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            modelParam.setSrvModelCatalog(SrvModelCatalogEnum.SrvServer.getCode());
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    ObjectType objectTypeEnum = ObjectType.getType((String)String.valueOf(table.getObjectType()));
                    String inputDOName = TmModelUtil.modelCodeToClassName((String)table.getObjectCode()) + "Input";
                    ModelTableInfo inputDO = modelTableInfoDao.queryInoutTableModelInfo(this.appInfo.getAppId(), inputDOName);
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String tableObjectType = String.valueOf(table.getObjectType());
                    String author = table.getCreateUser();
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    tpib.setProjectType(tableObjectType);
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Dao %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    bo.getMapData().put("table", table);
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    HashMap<String, OsrvArrangeImport> importMap = new HashMap<String, OsrvArrangeImport>();
                    ArrayList<ModelTableInfoBo> refTableList = new ArrayList<ModelTableInfoBo>();
                    if (objectTypeEnum == ObjectType.Data || objectTypeEnum == ObjectType.Main || objectTypeEnum == ObjectType.Second) {
                        this.generateModelTableJoinDetail(tableBo, conn);
                        ModelJoinDetail joinParam = new ModelJoinDetail();
                        joinParam.setJoinDetailId(tableBo.getTableId());
                        List<ModelJoinDetail> joinList = modelJoinDetailDao.queryModelJoinDetailList(joinParam);
                        if (CollectionUtils.isNotEmpty(joinList)) {
                            for (ModelJoinDetail joinDetail : joinList) {
                                ModelTableInfo joinTable = modelTableInfoDao.queryModelTableInfo(joinDetail.getObjectId());
                                ModelTableInfoBo joinTableBo = this.generateTableBO(joinTable, conn);
                                OsrvArrangeImport importInfo = new OsrvArrangeImport();
                                importInfo.setClassName(this.wrapperTableToClassName(joinTable.getObjectCode(), joinTable.getObjectType().toString(), joinTable.getObjectId()));
                                importInfo.setProjectCode(tpib.getProjectCode());
                                importInfo.setImportType(OsrvArrangeImport.ImportType.Mapper.getCode());
                                importMap.put(importInfo.getClassName(), importInfo);
                                refTableList.add(joinTableBo);
                            }
                        }
                        bo.getMapData().put("joinList", joinList);
                        ModelJoinDetail[] reverserJoinList = joinList.toArray(new ModelJoinDetail[0]);
                        CollectionUtils.reverseArray((Object[])reverserJoinList);
                        bo.getMapData().put("reverserJoinList", Arrays.asList(reverserJoinList));
                    } else {
                        bo.getMapData().put("joinList", Collections.EMPTY_LIST);
                    }
                    bo.getMapData().put("refTableList", refTableList);
                    modelParam.setTableModelId(table.getObjectId());
                    List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam);
                    ArrayList methods = new ArrayList(modelList.size());
                    Map dataMap = bo.getMapData();
                    dataMap.put("methods", methods);
                    for (SrvModelInfo modelInfo : modelList) {
                        SrvModelInout outputSingle;
                        OsrvArrangeImport importCls;
                        HashMap<String, Object> method = new HashMap<String, Object>();
                        method.put("modelInfo", (Object)modelInfo);
                        method.put("methodName", modelInfo.getSrvModelCode());
                        SrvModelTypeEnum srvModelTypeEnum = SrvModelTypeEnum.getModelByType((String)modelInfo.getSrvModelType());
                        if (SrvModelTypeEnum.QUERY_BY_PK == srvModelTypeEnum || SrvModelTypeEnum.QUERY_SINGLE == srvModelTypeEnum) {
                            method.put("singleOutput", true);
                        } else {
                            method.put("singleOutput", false);
                        }
                        String mapperOutput_mainTableClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "PO";
                        SrvModelInout mapperInput = new SrvModelInout();
                        mapperInput.setSrvModelId(modelInfo.getSrvModelId());
                        mapperInput.setListFlag(YesOrNO.NO.getCode());
                        mapperInput.setObjectType(table.getObjectType());
                        mapperInput.setTableModelId(table.getObjectId());
                        mapperInput.setTableModelCode(mapperOutput_mainTableClassName);
                        mapperInput.setTableModelName(table.getObjectName());
                        method.put("mapperInput", (Object)mapperInput);
                        OsrvArrangeImport mapperInput_importCls = new OsrvArrangeImport();
                        mapperInput_importCls.setClassName(mapperOutput_mainTableClassName);
                        mapperInput_importCls.setProjectCode(tpib.getProjectCode());
                        mapperInput_importCls.setImportType(OsrvArrangeImport.ImportType.PO.getCode());
                        importMap.put(mapperInput_importCls.getClassName(), mapperInput_importCls);
                        SrvModelInout inoutParam = new SrvModelInout();
                        inoutParam.setSrvModelId(modelInfo.getSrvModelId());
                        inoutParam.setIoType(IOType.Input.getCode());
                        List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        SrvModelInout inputSingle = null;
                        for (SrvModelInout inout : inputParams) {
                            if (StringUtils.equals((CharSequence)inputDOName, (CharSequence)inout.getTableModelCode())) {
                                inputSingle = inout;
                                mapperInput.setListFlag(inout.getListFlag());
                            }
                            inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            importCls = new OsrvArrangeImport();
                            importCls.setClassName(inout.getTableModelCode());
                            importCls.setProjectCode(tpib.getProjectCode());
                            importCls.setTableModelId(inout.getTableModelId());
                            importCls.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            importMap.put(importCls.getClassName(), importCls);
                        }
                        if (srvModelTypeEnum == SrvModelTypeEnum.QUERY) {
                            method.put("input", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                            method.put("mapperInputList", Arrays.asList(inputSingle, userTokenInout, pageInfoInout));
                            mapperInput = inputSingle;
                        } else if (srvModelTypeEnum == SrvModelTypeEnum.QUERY_BATCH || srvModelTypeEnum == SrvModelTypeEnum.QUERY_CUSTOMIZE) {
                            method.put("input", Arrays.asList(inputSingle, userTokenInout));
                            method.put("mapperInputList", Arrays.asList(inputSingle, userTokenInout));
                            mapperInput = inputSingle;
                        } else {
                            SrvModelInout inputTableDO = new SrvModelInout();
                            inputTableDO.setTableModelId(table.getObjectId());
                            inputTableDO.setTableModelCode(table.getObjectCode());
                            inputTableDO.setTableModelName(table.getObjectName());
                            inputTableDO.setObjectType(table.getObjectType());
                            inputTableDO.setIoType(IOType.Input.getCode());
                            inputTableDO.setListFlag(inputSingle.getListFlag());
                            String importType = this.judgeTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId());
                            inputTableDO.setTableModelCode(this.wrapperTableToClassName(inputTableDO.getTableModelCode(), inputTableDO.getObjectType().toString(), inputTableDO.getTableModelId()));
                            inputSingle = inputTableDO;
                            importCls = new OsrvArrangeImport();
                            importCls.setClassName(inputTableDO.getTableModelCode());
                            importCls.setProjectCode(tpib.getProjectCode());
                            importCls.setTableModelId(inputTableDO.getTableModelId());
                            importCls.setImportType(importType);
                            importMap.put(importCls.getClassName(), importCls);
                            method.put("input", Arrays.asList(inputTableDO, userTokenInout));
                            method.put("mapperInputList", Arrays.asList(mapperInput, userTokenInout));
                        }
                        method.put("inputSingle", (Object)inputSingle);
                        method.put("UserTokenInfo", this.wrapperTableToClassName(userTokenInfo.getObjectCode(), userTokenInfo.getObjectType().toString(), userTokenInfo.getObjectId()));
                        method.put("PageInfo", this.wrapperTableToClassName(pageInfo.getObjectCode(), pageInfo.getObjectType().toString(), pageInfo.getObjectId()));
                        inoutParam.setIoType(IOType.Output.getCode());
                        List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                        SrvModelInout srvModelInout = outputSingle = outputParams.isEmpty() ? null : outputParams.get(0);
                        if (CollectionUtils.isNotEmpty(outputParams)) {
                            String mainTableClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode()) + "PO";
                            SrvModelInout output = outputParams.get(0);
                            SrvModelInout mapperOutput = new SrvModelInout();
                            mapperOutput.setSrvModelId(modelInfo.getSrvModelId());
                            mapperOutput.setIoType(output.getIoType());
                            mapperOutput.setListFlag(output.getListFlag());
                            mapperOutput.setObjectType(table.getObjectType());
                            mapperOutput.setTableModelId(table.getObjectId());
                            mapperOutput.setTableModelCode(mainTableClassName);
                            mapperOutput.setTableModelName(table.getObjectName());
                            method.put("mapperOutput", (Object)mapperOutput);
                            OsrvArrangeImport importCls2 = new OsrvArrangeImport();
                            importCls2.setClassName(mainTableClassName);
                            importCls2.setProjectCode(tpib.getProjectCode());
                            importCls2.setImportType(OsrvArrangeImport.ImportType.PO.getCode());
                            importMap.put(importCls2.getClassName(), importCls2);
                        }
                        for (SrvModelInout inout : outputParams) {
                            inout.setTableModelCode(this.wrapperTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            OsrvArrangeImport importCls3 = new OsrvArrangeImport();
                            importCls3.setClassName(inout.getTableModelCode());
                            importCls3.setProjectCode(tpib.getProjectCode());
                            importCls3.setTableModelId(inout.getTableModelId());
                            importCls3.setImportType(this.judgeTableToClassName(inout.getTableModelCode(), inout.getObjectType().toString(), inout.getTableModelId()));
                            importMap.put(importCls3.getClassName(), importCls3);
                        }
                        method.put("output", (Object)(outputParams.isEmpty() ? null : outputParams.get(0)));
                        if (SrvModelTypeEnum.UPDATE_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.DELETE_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.QUERY_CUSTOMIZE == srvModelTypeEnum || SrvModelTypeEnum.ASSOCIATED_QUERY_CUSTOMIZE == srvModelTypeEnum) {
                            IsrvSqlInfo isrvSqlInfo = new IsrvSqlInfo();
                            isrvSqlInfo.setSrvModelId(modelInfo.getSrvModelId());
                            List<IsrvSqlInfo> isrvSqlInfos = isrvSqlInfoDao.queryIsrvSqlInfoList(isrvSqlInfo);
                            method.put("isrvSqlInfos", isrvSqlInfos);
                        }
                        IsrvSqlCond isrvSqlCond = new IsrvSqlCond();
                        isrvSqlCond.setSrvModelId(modelInfo.getSrvModelId());
                        List<IsrvSqlCond> condList = isrvSqlCondDao.queryIsrvSqlCondList(isrvSqlCond);
                        if (CollectionUtils.isNotEmpty(condList)) {
                            ArrayList<Map> condMapList = new ArrayList<Map>();
                            for (IsrvSqlCond cond : condList) {
                                if (StringUtils.isBlank((CharSequence)cond.getTableFieldId())) continue;
                                ModelTableField evalField = modelTableFieldDao.queryByPk(cond.getDomainFieldId());
                                Map condMap = MapBeanUtil.beanToMap((Object)((Object)cond));
                                String javaPropName = TmModelUtil.fieldToProperty((String)cond.getEvalContent());
                                if (evalField != null) {
                                    if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)inputDO.getObjectId())) {
                                        javaPropName = SrvModelTypeEnum.DELETE_BATCH == srvModelTypeEnum || SrvModelTypeEnum.UPDATE_BATCH == srvModelTypeEnum || SrvModelTypeEnum.QUERY_BATCH == srvModelTypeEnum ? "item." + javaPropName : StringUtils.uncapitalize((String)mapperInput.getTableModelCode()) + "." + javaPropName;
                                    } else if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)userTokenInfo.getObjectId())) {
                                        javaPropName = StringUtils.uncapitalize((String)userTokenInout.getTableModelCode()) + "." + javaPropName;
                                    } else if (StringUtils.equals((CharSequence)evalField.getObjectId(), (CharSequence)pageInfo.getObjectId())) {
                                        javaPropName = StringUtils.uncapitalize((String)pageInfoInout.getTableModelCode()) + "." + javaPropName;
                                    }
                                }
                                condMap.put("javaPropertyName", javaPropName);
                                condMap.put("fieldCode", cond.getTableFieldCode());
                                if (FieldEvalWay.CONST.getCode().equals(cond.getFieldEvalWay())) {
                                    condMap.put("const", true);
                                } else {
                                    condMap.put("const", false);
                                }
                                if (CondNotEmptyEnum.Y.getCode().equals(cond.getCondNotEmpty())) {
                                    condMap.put("condNotEmpty", Boolean.TRUE);
                                } else {
                                    condMap.put("condNotEmpty", Boolean.FALSE);
                                }
                                condMapList.add(condMap);
                            }
                            method.put("condList", condMapList);
                        } else {
                            method.put("condList", new ArrayList());
                        }
                        methods.add(method);
                    }
                    dataMap.put("importList", importMap.values());
                    ctdbList.add(bo);
                }
            }
            for (CodeTemplateDataBo ctdb : ctdbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                String package_prefix = this.getPackagePrefix(ctdb);
                Map mapData = ctdb.getMapData();
                TmProjectInfoBo tpib = (TmProjectInfoBo)mapData.get("TmProject");
                ctdb.getMapData().put("extendBaseInfoFlag", false);
                this.produceCodeFile("XXXPO.java", "infrastructure", "src/main/java/" + package_prefix + "/" + TdpInfrastructurePlugin.formatClassPath(subsCode) + "/infra/persistence/po/", this.appInfo, ctdb);
                this.produceCodeFile("XXXMapper.java", "infrastructure", "src/main/java/" + package_prefix + "/" + TdpInfrastructurePlugin.formatClassPath(subsCode) + "/infra/persistence/mapper/", this.appInfo, ctdb);
                this.produceCodeFile("XXXRepositoryImpl.java", "infrastructure", "src/main/java/" + package_prefix + "/" + TdpInfrastructurePlugin.formatClassPath(subsCode) + "/infra/repository/impl/", this.appInfo, ctdb);
                this.produceCodeFile("XXXMapperImpl.xml", "infrastructure", "src/main/resources/mybatis/mapper/", this.appInfo, ctdb);
            }
            String mapperXmlTargetPath = SdEnvUtil.PROJECT_PATH + this.appInfo.getAppCode() + File.separator + String.format("%s-%s", this.appInfo.getAppCode(), "infrastructure").replace(".", "-") + File.separator + "src/main/resources/mybatis/mapper/";
            MyBatter.formatFileOrDirectory((String)mapperXmlTargetPath, (String)"*.xml", (String)"utf-8", (boolean)false, (boolean)true);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            String package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("infrastructure-pom.xml", "", "infrastructure-", "infrastructure", "", this.appInfo, pomBo);
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

