/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInoutDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInout;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.types.IOType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.MapBeanUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpRuleDomainPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210\u89c4\u5219\u7ec4\u4ef6\u53c2\u6570\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            SrvModelInoutDao srvModelInoutDao = new SrvModelInoutDao(conn);
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
            ArrayList<CodeTemplateDataBo> ctdbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Domain Entity %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    bo.getMapData().put("objectType", String.valueOf(table.getObjectType()));
                    ctdbList.add(bo);
                }
            }
            for (CodeTemplateDataBo ctdb : ctdbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                Map appsParam = MapUtils.getMap((Map)ctdb.getMapData(), (Object)"appsParam");
                appsParam.put("package_prefix", "com.irdstudio");
                String package_prefix = this.getPackagePrefix(ctdb);
                String objectType = MapUtils.getString((Map)ctdb.getMapData(), (Object)"objectType", (String)"");
                this.produceCodeFile("XXXDTO.java", "XXXDTO", null, "src/main/java/" + package_prefix + "/" + TdpRuleDomainPlugin.formatClassPath(this.appInfo.getAppCode()) + "/dto/", this.appInfo, ctdb);
            }
            SrvModelInfo srvParam = new SrvModelInfo();
            srvParam.setAppId(this.appInfo.getAppId());
            List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam, Arrays.asList(SrvModelCatalogEnum.SdkServer.getCode()));
            ArrayList<CodeTemplateDataBo> srvParamCbList = new ArrayList<CodeTemplateDataBo>(tableList.size());
            if (CollectionUtils.isNotEmpty(srvModelList)) {
                for (SrvModelInfo model : srvModelList) {
                    ModelTableInfo tableInfo;
                    String className;
                    Map prop;
                    ArrayList<Map> properties;
                    HashMap otherFacadeImport;
                    String paramClassName;
                    SrvModelInout inoutParam = new SrvModelInout();
                    inoutParam.setSrvModelId(model.getSrvModelId());
                    inoutParam.setIoType(IOType.Input.getCode());
                    List<SrvModelInout> inputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                    inoutParam.setIoType(IOType.Output.getCode());
                    List<SrvModelInout> outputParams = srvModelInoutDao.querySrvModelInoutList(inoutParam);
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                    String tableModelCode = TmModelUtil.propertyToField((String)StringUtils.uncapitalize((String)tableClassName));
                    HashMap<String, String> method = new HashMap<String, String>();
                    if (StringUtils.isNotBlank((CharSequence)model.getSrvModelMethod())) {
                        method.put("methodName", model.getSrvModelMethod());
                    } else {
                        method.put("methodName", "handle");
                    }
                    if (CollectionUtils.isNotEmpty(inputParams) && inputParams.size() > 1) {
                        paramClassName = tableClassName + "Input";
                        method.put("input", paramClassName);
                        method.put("inputListFlag", YesOrNO.NO.getCode());
                        otherFacadeImport = new HashMap();
                        CodeTemplateDataBo inputBo = new CodeTemplateDataBo();
                        inputBo.setTmProjectInfo(tpib);
                        inputBo.getEnvBo().setAuthor(this.loginUserId);
                        inputBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                        inputBo.getEnvBo().setDesc(String.format("%s Facade DTO %s", this.appInfo.getAppName(), model.getSrvModelName()));
                        inputBo.getMapData().put("tableModelCode", paramClassName);
                        inputBo.getMapData().put("tableClassName", paramClassName);
                        properties = new ArrayList<Map>();
                        inputBo.getMapData().put("properties", properties);
                        for (SrvModelInout inout : inputParams) {
                            prop = MapBeanUtil.beanToMap((Object)((Object)inout));
                            className = TmModelUtil.tableCodeToClassName((String)inout.getTableModelCode());
                            prop.put("className", className);
                            prop.put("propName", StringUtils.uncapitalize((String)className));
                            tableInfo = modelTableInfoDao.queryModelTableInfo(inout.getTableModelId());
                            prop.put("import", "Y");
                            properties.add(prop);
                        }
                        srvParamCbList.add(inputBo);
                    }
                    if (!CollectionUtils.isNotEmpty(outputParams) || outputParams.size() <= 1) continue;
                    paramClassName = tableClassName + "Output";
                    method.put("output", paramClassName);
                    method.put("outputListFlag", YesOrNO.NO.getCode());
                    otherFacadeImport = new HashMap();
                    CodeTemplateDataBo outputBo = new CodeTemplateDataBo();
                    outputBo.setTmProjectInfo(tpib);
                    outputBo.getEnvBo().setAuthor(this.loginUserId);
                    outputBo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    outputBo.getEnvBo().setDesc(String.format("%s Facade DTO %s", this.appInfo.getAppName(), model.getSrvModelName()));
                    outputBo.getMapData().put("tableModelCode", paramClassName);
                    outputBo.getMapData().put("tableClassName", paramClassName);
                    properties = new ArrayList();
                    outputBo.getMapData().put("properties", properties);
                    for (SrvModelInout inout : outputParams) {
                        prop = MapBeanUtil.beanToMap((Object)((Object)inout));
                        className = TmModelUtil.tableCodeToClassName((String)inout.getTableModelCode());
                        prop.put("className", className);
                        prop.put("propName", StringUtils.uncapitalize((String)className));
                        tableInfo = modelTableInfoDao.queryModelTableInfo(inout.getTableModelId());
                        prop.put("import", "Y");
                        properties.add(prop);
                    }
                    srvParamCbList.add(outputBo);
                }
            }
            for (CodeTemplateDataBo ctdb : srvParamCbList) {
                this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                String package_prefix = this.getPackagePrefix(ctdb);
                String objectType = MapUtils.getString((Map)ctdb.getMapData(), (Object)"objectType", (String)"");
                this.produceCodeFile("XXXServiceDTO.java", "XXXServiceDTO", null, "src/main/java/" + package_prefix + "/" + TdpRuleDomainPlugin.formatClassPath(this.appInfo.getAppCode()) + "/dto/", this.appInfo, ctdb);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

