/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionEnumDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.DictOptionInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvErrorMappingDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionEnum;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.DictOptionInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvErrorMapping;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class TdpTypesPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u751f\u6210types\u5b50\u5de5\u7a0b\u4ee3\u7801");
        boolean result = true;
        Connection conn = null;
        try {
            List<SrvErrorMapping> dictErrorInfoList;
            String package_prefix;
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            DictOptionInfoDao dictOptionInfoDao = new DictOptionInfoDao(conn);
            DictOptionEnumDao dictOptionEnumDao = new DictOptionEnumDao(conn);
            SrvErrorMappingDao srvErrorMappingDao = new SrvErrorMappingDao(conn);
            List<ModelTableField> optionsList = modelTableFieldDao.queryModelTableFieldAllOptions(this.appInfo.getAppId());
            if (CollectionUtils.isNotEmpty(optionsList)) {
                ArrayList<CodeTemplateDataBo> codeBoList = new ArrayList<CodeTemplateDataBo>(optionsList.size());
                for (ModelTableField option : optionsList) {
                    if (StringUtils.isBlank((CharSequence)option.getDictId())) continue;
                    List<DictOptionEnum> dicts = dictOptionEnumDao.queryDictOptionEnumListByDictId(option.getDictId());
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    DictOptionInfo optionInfo = dictOptionInfoDao.queryByPk(option.getDictId());
                    if (optionInfo == null) continue;
                    if (CollectionUtils.isNotEmpty(dicts)) {
                        for (DictOptionEnum dict : dicts) {
                            if (!StringUtils.isBlank((CharSequence)dict.getOptionEnum())) continue;
                            String optionEnum = String.format("%s_%s", optionInfo.getDictCode(), dict.getOptionCode());
                            dict.setOptionEnum(optionEnum);
                        }
                    }
                    TmProjectInfoBo tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Types Enum %s %s", this.appInfo.getAppName(), optionInfo.getDictCode(), optionInfo.getDictName()));
                    option.setFieldCode(TmModelUtil.tableCodeToClassName((String)option.getFieldOption()));
                    bo.getMapData().put("fieldOption", option);
                    bo.getMapData().put("dicts", dicts);
                    bo.getMapData().put("tableModelCode", option.getFieldOption());
                    codeBoList.add(bo);
                }
                for (CodeTemplateDataBo ctdb : codeBoList) {
                    this.wrapAppsParam(this.appInfo.getAppId(), ctdb, conn);
                    package_prefix = this.getPackagePrefix(ctdb);
                    this.produceCodeFile("XXXEnum.java", "types", "src/main/java/" + package_prefix + "/" + TdpTypesPlugin.formatClassPath(subsCode) + "/types/", this.appInfo, ctdb);
                }
            }
            if (CollectionUtils.isNotEmpty(dictErrorInfoList = srvErrorMappingDao.queryDictErrorInfoList(this.appInfo.getAppId()))) {
                CodeTemplateDataBo errorCode = new CodeTemplateDataBo();
                TmProjectInfoBo tpib = new TmProjectInfoBo();
                tpib.setProjectId(this.appInfo.getAppCode());
                tpib.setProjectCode(this.appInfo.getAppCode());
                tpib.setProjectName(this.appInfo.getAppName());
                errorCode.setTmProjectInfo(tpib);
                errorCode.getEnvBo().setAuthor(this.loginUserId);
                errorCode.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                errorCode.getEnvBo().setDesc(String.format("%s Types Error Enum", this.appInfo.getAppName()));
                errorCode.getMapData().put("tableModelCode", this.appInfo.getAppCode());
                errorCode.getMapData().put("errorClassName", TmModelUtil.tableCodeToClassName((String)this.appInfo.getAppCode()));
                errorCode.getMapData().put("dicts", dictErrorInfoList);
                this.wrapAppsParam(this.appInfo.getAppId(), errorCode, conn);
                package_prefix = this.getPackagePrefix(errorCode);
                this.produceCodeFile("XXXErrorEnum.java", "types", "src/main/java/" + package_prefix + "/" + TdpTypesPlugin.formatClassPath(subsCode) + "/types/", this.appInfo, errorCode);
            }
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            package_prefix = this.getPackagePrefix(pomBo);
            this.produceCodeFile("types-pom.xml", "", "types-", "types", "", this.appInfo, pomBo);
        }
        catch (SQLException e) {
            this.logger.error(" \u6267\u884c sql \u5f02\u5e38 " + e.getMessage(), e);
            result = false;
        }
        catch (Exception e) {
            this.logger.error("\u751f\u6210 types \u5b50\u5de5\u7a0b\u4ee3\u7801\u9519\u8bef", e);
            result = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return result;
    }
}

