/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.AbstractFadpaasPageRender;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.RdmModuleInfoService;
import com.irdstudio.allintcp.sdk.bi.facade.operation.dto.RdmModuleInfoDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class FadpaasPageRenderW01
extends AbstractFadpaasPageRender {
    private PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
    private PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
    private PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
    private PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
    private PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
    private ModelTableInfoService modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
    private ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
    private RdmModuleInfoService rdmModuleInfoService = (RdmModuleInfoService)SpringContextUtils.getBean(RdmModuleInfoService.class);
    private PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
    private String modelCode = "fadpaas";

    public String getModelCode() {
        return this.modelCode;
    }

    @Override
    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    @Override
    public File render(PageModelInfoDTO modelInfo, String appTemplatePath, String targetPath, Map<String, String> modelPathMap, List<Map<String, String>> routes) {
        PageModelParamDTO param = new PageModelParamDTO();
        param.setPageModelId(modelInfo.getPageModelId());
        param.setQueryRef("query");
        List paramList = this.pageModelParamService.queryList((Object)param);
        if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
            logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
            return null;
        }
        PageTemplateInfoDTO templateParam = new PageTemplateInfoDTO();
        templateParam.setPageTemplateId(modelInfo.getPageTemplateId());
        PageTemplateInfoDTO template = (PageTemplateInfoDTO)this.pageTemplateInfoService.queryByPk((Object)templateParam);
        PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
        fileParam.setPageTemplateId(template.getPageTemplateId());
        List fileList = this.pageTemplateFileService.queryList((Object)fileParam);
        String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateCode();
        if (CollectionUtils.isNotEmpty((Collection)fileList)) {
            String packagePath = "";
            ModelTableInfoDTO table = new ModelTableInfoDTO();
            if (StringUtils.isNotBlank((CharSequence)modelInfo.getTableModelId())) {
                table.setObjectId(modelInfo.getTableModelId());
                table = (ModelTableInfoDTO)this.modelTableInfoService.queryByPk((Object)table);
                RdmModuleInfoDTO moduleInfo = new RdmModuleInfoDTO();
                moduleInfo.setModuleId(modelInfo.getModuleId());
                moduleInfo = this.rdmModuleInfoService.queryByPk(moduleInfo);
                if (moduleInfo != null && StringUtils.isNotBlank((CharSequence)moduleInfo.getFeatureCode())) {
                    packagePath = moduleInfo.getFeatureCode().replaceAll("_|\\.|-", File.separator);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)modelPathMap.get(modelInfo.getPackageId()))) {
                packagePath = packagePath + File.separator + modelPathMap.get(modelInfo.getPackageId());
            }
            if (StringUtils.isBlank((CharSequence)packagePath)) {
                packagePath = "";
            }
            String basePath = this.getBasePath(packagePath);
            Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
            ArrayList dataCodes = new ArrayList();
            paramList.forEach(pageModelParamVO -> {
                List fields = pageModelParamVO.getFields();
                if (CollectionUtils.isNotEmpty((Collection)fields)) {
                    fields.forEach(f -> {
                        if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                            dataCodes.add(f.getFieldOption());
                        }
                    });
                }
            });
            String dataCodeJoin = String.join((CharSequence)",", dataCodes);
            root.put("BASE_PATH", basePath);
            root.put("pageModelInfo", modelInfo);
            root.put("dataCodeJoin", dataCodeJoin);
            root.put("localAppTemplatePath", localAppTemplatePath);
            String pageSuffix = template.getPageTemplateSuffix();
            if (StringUtils.isBlank((CharSequence)pageSuffix)) {
                pageSuffix = ".html";
            }
            for (PageTemplateFileDTO file : fileList) {
                String templateName = file.getFileName() + ".vm";
                String tempPath = localAppTemplatePath + File.separator + templateName;
                File tempFile = new File(tempPath);
                if (tempFile.exists()) {
                    try {
                        String oriFileName;
                        String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                        File targetDir = new File(targetPath + File.separator + packagePath);
                        if (!targetDir.exists()) {
                            targetDir.mkdirs();
                        }
                        if (!StringUtils.endsWith((CharSequence)(oriFileName = modelInfo.getPageModelCode()), (CharSequence)pageSuffix)) {
                            oriFileName = oriFileName + pageSuffix;
                        }
                        File targetFile = new File(targetDir, oriFileName);
                        try (FileOutputStream output = new FileOutputStream(targetFile);){
                            IOUtils.write((String)html, (OutputStream)output, (String)"utf-8");
                        }
                        return targetFile;
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), (Throwable)e);
                        continue;
                    }
                }
                logger.error("\u6a21\u677f\u4e0d\u5b58\u5728 " + tempFile.getAbsolutePath());
            }
        }
        return null;
    }
}

