/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.check;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.AppsCheckLogDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableFieldDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.AppsCheckLog;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableField;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.util.pub.UUIDUtil;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public abstract class AbstractCheckPlugin
extends AbstractPlugin {
    FlowInstMaster batInst = null;
    Map<String, Object> extParam = null;
    PaasAppsInfo appInfo = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        String szSubsCode = this.context.getSzSubsCode();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batInst.getAppId());
        return true;
    }

    ModelTableInfoBo generateTableBO(ModelTableInfo table, Connection conn) {
        try {
            ModelTableFieldDao modelTableFieldDao = new ModelTableFieldDao(conn);
            List<ModelTableField> fields = modelTableFieldDao.queryModelTableFieldList(table.getObjectId());
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            if (CollectionUtils.isNotEmpty(fields)) {
                ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
                HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
                for (ModelTableField field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)((Object)field), (Object)fieldBo);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldId(), fieldBo);
                }
                tableBo.setFieldList(fieldBos);
                tableBo.setFieldMap(fieldMap);
            }
            return tableBo;
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), e);
            return null;
        }
    }

    ModelTableFieldBo generateTableFieldBO(ModelTableField field) {
        ModelTableFieldBo fieldBo = new ModelTableFieldBo();
        BeanUtils.copyProperties((Object)((Object)field), (Object)fieldBo);
        String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
        fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
        fieldBo.setJavaPropertyName(javaPropertyName);
        fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
        return fieldBo;
    }

    public boolean saveAppsCheckLog(AppsCheckLog log, Connection conn) {
        AppsCheckLogDao appsCheckLogDao = new AppsCheckLogDao(conn);
        log.setBatchSerialNo(this.batInst.getBatchSerialNo());
        log.setRecordKeyId(UUIDUtil.getUUID());
        log.setOperUserid(MapUtils.getString(this.extParam, (Object)"loginUserId"));
        log.setOperTime(CurrentDateUtil.getTodayDateEx2());
        log.setAppId(this.appInfo.getAppId());
        log.setAppCode(this.appInfo.getAppCode());
        log.setAppName(this.appInfo.getAppName());
        log.setAppType(this.appInfo.getAppType());
        log.setSysCode(this.appInfo.getSubsId());
        log.setSysName(this.appInfo.getSubsName());
        log.setProjectId(this.appInfo.getAppId());
        boolean flag = true;
        try {
            flag = appsCheckLogDao.insert(log);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return flag;
    }
}

