/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataexport;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.PluginConfSysupdDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.dataexport.PluginExportConf;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginExportConfDao {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfSysupdDao.class);
    Connection conn = null;

    public PluginExportConfDao(Connection conn) {
        this.conn = conn;
    }

    public PluginExportConf queryWithKeys(String pluginConfId, int confSort) throws SQLException {
        PluginExportConf dc = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_export_conf WHERE plugin_conf_id=?,conf_sort=?");
            ps.setString(1, pluginConfId);
            ps.setInt(2, confSort);
            rs = ps.executeQuery();
            if (rs.next()) {
                dc = new PluginExportConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setExportMode(rs.getString("export_mode"));
                dc.setExportTarget(rs.getString("export_target"));
                dc.setExportToFile(rs.getString("export_to_file"));
                dc.setFileCharset(rs.getString("file_charset"));
                dc.setFieldSeparator(rs.getString("field_separator"));
                dc.setIsOkFile(rs.getString("is_ok_file"));
                dc.setOkFileFullName(rs.getString("ok_file_full_name"));
                dc.setOkFileContent(rs.getString("ok_file_content"));
                dc.setIsDealEmptyStr(rs.getString("is_deal_empty_str"));
                dc.setDealEmptyStr(rs.getString("deal_empty_str"));
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginExportConfWithKeys is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dc;
    }

    public List<PluginExportConf> queryWithPluginConfId(String plugin_conf_id) throws SQLException {
        ArrayList<PluginExportConf> dcList = new ArrayList<PluginExportConf>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.conn.prepareStatement("SELECT * FROM plugin_export_conf WHERE plugin_conf_id=? order by conf_sort");
            ps.setString(1, plugin_conf_id);
            rs = ps.executeQuery();
            while (rs.next()) {
                PluginExportConf dc = new PluginExportConf();
                dc.setPluginConfId(rs.getString("plugin_conf_id"));
                dc.setConfSort(rs.getInt("conf_sort"));
                dc.setExportMode(rs.getString("export_mode"));
                dc.setExportTarget(rs.getString("export_target"));
                dc.setExportToFile(rs.getString("export_to_file"));
                dc.setFileCharset(rs.getString("file_charset"));
                dc.setFieldSeparator(rs.getString("field_separator"));
                dc.setIsOkFile(rs.getString("is_ok_file"));
                dc.setOkFileFullName(rs.getString("ok_file_full_name"));
                dc.setOkFileContent(rs.getString("ok_file_content"));
                dc.setIsDealEmptyStr(rs.getString("is_deal_empty_str"));
                dc.setDealEmptyStr(rs.getString("deal_empty_str"));
                dcList.add(dc);
            }
            this.close(rs, null, ps);
        }
        catch (SQLException e) {
            try {
                throw new SQLException("queryPluginExportConfWithCond is Wrong!" + e.getMessage());
            }
            catch (Throwable throwable) {
                this.close(rs, null, ps);
                throw throwable;
            }
        }
        return dcList;
    }

    protected void close(ResultSet theRs, Statement theStmt, PreparedStatement thePs) {
        try {
            if (theRs != null) {
                theRs.close();
            }
            if (theStmt != null) {
                theStmt.close();
            }
            if (thePs != null) {
                thePs.close();
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage());
        }
    }
}

