/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowConfMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class FastdfsInstallPlugin
extends AbstractPlugin {
    private FlowInstMaster opsLog;
    private String id = "fastdfs5.0.12";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (FastdfsInstallPlugin.this.logger != null) {
                FastdfsInstallPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (FastdfsInstallPlugin.this.logger != null) {
                FastdfsInstallPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        FlowConfMasterDao flowConfMasterDao = new FlowConfMasterDao(conn);
        this.opsLog = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        FlowConfMaster batchInfo = flowConfMasterDao.queryWithKeys(this.opsLog.getBatchId());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        try {
            File dir;
            String opsPath;
            conn = this.getPluginConnection();
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
            FlowInstMaster flowInstMaster = flowInstMasterDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = flowInstMaster.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasEcsInfo ecsInfo = paasEcsInfoDao.queryByPk(this.opsLog.getEcsId());
            if (ecsInfo == null) {
                PaasEcsInfo ecsParam = new PaasEcsInfo();
                ecsParam.setAppId(this.opsLog.getAppId());
                ecsParam.setSubsId(this.opsLog.getSubsId());
                ecsParam.setEnvId(this.opsLog.getEnvId());
                List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
                if (CollectionUtils.isNotEmpty(ecsList)) {
                    ecsInfo = ecsList.get(0);
                }
            }
            if (StringUtils.isBlank((String)(opsPath = SdEnvUtil.TEMPLATE_PATH + this.id + "-medium"))) {
                this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
            }
            String installPath = opsPath + File.separator;
            if (!new File(installPath).exists()) {
                this.logger.error("fastdfs\u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
                throw new RuntimeException("fastdfs\u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
            }
            this.logger.info("\u8fdc\u7a0b\u64cd\u4f5cLinux\u670d\u52a1\u5668 " + ecsInfo.getEcsIp());
            RemoteSSHClient rsc = new RemoteSSHClient(ecsInfo.getEcsIp(), ecsInfo.getEcsLoginUser(), ecsInfo.getEcsLoginPwd());
            boolean loginFlag = rsc.connect();
            if (!loginFlag) {
                this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                throw new RuntimeException("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
            }
            if (!rsc.fileExists(deployRootDir + "/fastdfs")) {
                rsc.executeCommand("mkdir -p " + deployRootDir + "/fastdfs", this.sshPrinter);
            }
            if ((dir = new File(installPath)).exists()) {
                File[] files;
                for (File file : files = dir.listFiles()) {
                    if (!file.isFile()) continue;
                    rsc.upload(file.getAbsolutePath(), deployRootDir + "/fastdfs");
                }
                rsc.executeCommand(String.format("chmod 777 %s/fastdfs/installFastdfs.sh", deployRootDir), this.sshPrinter);
                this.logger.info(String.format("\u6267\u884c\u811a\u672c %s/fastdfs/installFastdfs.sh %s/fastdfs", deployRootDir, deployRootDir));
                rsc.executeCommand(String.format("bash %s/fastdfs/installFastdfs.sh %s/fastdfs", deployRootDir, deployRootDir), this.sshPrinter);
            } else {
                this.logger.error("fastdfs \u5b89\u88c5\u5305\u4e0d\u5b58\u5728");
                flag = false;
            }
        }
        catch (Exception e) {
            this.logger.error("\u5b89\u88c5fastdfs\u5230\u670d\u52a1\u5668\u5931\u8d25" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }
}

