/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deliver;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowConfMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MiddleAppConfigFileGenerate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;

public class MiddleAppConfigFileGenPlugin
extends AbstractPlugin {
    private FlowInstMaster opsLog;
    private PaasAppsInfo appInfo = null;
    private Map<String, Object> extParam;
    private String actionId;
    private String actionShell;
    private String envId;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        FlowConfMasterDao flowConfMasterDao = new FlowConfMasterDao(conn);
        this.opsLog = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        FlowConfMaster batchInfo = flowConfMasterDao.queryWithKeys(this.opsLog.getBatchId());
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.opsLog.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.opsLog);
        this.actionId = MapUtils.getString(this.extParam, (Object)"actionId");
        this.actionShell = MapUtils.getString(this.extParam, (Object)"actionShell");
        this.envId = this.opsLog.getEnvId();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag;
        block8: {
            FileOutputStream out;
            block7: {
                flag = true;
                Connection conn = null;
                out = null;
                try {
                    MiddleAppConfigFileGenerate fileGenTool = new MiddleAppConfigFileGenerate();
                    String[] configs = fileGenTool.obtainDeployConfigFile(this.appInfo.getAppId(), this.envId, this.context.getConnPool());
                    String content = configs[1];
                    String fileName = configs[0];
                    fileName = fileName.replace("-" + this.envId, "");
                    File appDir = new File(SdEnvUtil.PROJECT_PATH + File.separator + this.appInfo.getAppCode());
                    if (!appDir.exists()) {
                        appDir.mkdirs();
                    }
                    String filePath = appDir.getAbsolutePath() + File.separator + fileName;
                    out = new FileOutputStream(new File(filePath));
                    IOUtils.write((String)content, (OutputStream)out, (String)"UTF-8");
                    out.flush();
                    if (conn == null) break block7;
                }
                catch (Exception e) {
                    this.logger.error("\u751f\u6210\u4e2d\u95f4\u4ef6\u5e94\u7528\u914d\u7f6e\u6587\u4ef6" + e.getMessage(), e);
                    flag = false;
                    break block8;
                }
                finally {
                    if (conn != null) {
                        this.closePluginConnection(conn);
                    }
                    IOUtils.closeQuietly(out);
                }
                this.closePluginConnection(conn);
            }
            IOUtils.closeQuietly((OutputStream)out);
        }
        return flag;
    }
}

