/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PaasEcsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsSqlService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsSqlDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.portal.console.types.ExecuteStage;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class AllinPaasSyncPlugin
extends AbstractPlugin {
    protected FlowInstMaster batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    protected String paasDuId = "D000001";
    protected String ecsId = "";

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PaasAppsSqlService service = (PaasAppsSqlService)SpringContextUtils.getBean(PaasAppsSqlService.class);
        PaasAppsSqlDTO param = new PaasAppsSqlDTO();
        param.setPluginConfId(taskId);
        List sqlList = service.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)sqlList)) {
            return true;
        }
        for (PaasAppsSqlDTO sql : sqlList) {
            List re = sql.validate();
            if (!CollectionUtils.isNotEmpty((Collection)re)) continue;
            message.getMessage().addAll(re);
            break;
        }
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        PaasAppsSqlService service = (PaasAppsSqlService)SpringContextUtils.getBean(PaasAppsSqlService.class);
        PaasAppsSqlDTO param = new PaasAppsSqlDTO();
        param.setPluginConfId(taskId);
        param.setExecuteStage(ExecuteStage.Saas.getCode());
        List sqlList = service.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)sqlList)) {
            return true;
        }
        for (PaasAppsSqlDTO sql : sqlList) {
            sql.setPluginConfId(newTaskId);
            sql.setRecordKeyid(UUIDUtil.getUUID());
        }
        int re = service.batchInsert(sqlList);
        return re == 1;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        String currEnvId = this.batchInst.getEnvId();
        this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
        return true;
    }

    @Override
    public boolean execute() {
        return true;
    }

    public String requestOpenApi(String url, Object param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost postMethod = new HttpPost(url);
        HttpResponse response = null;
        try {
            String reqJson = JSON.toJSONString((Object)param);
            StringEntity entity = new StringEntity(reqJson, ContentType.APPLICATION_JSON);
            postMethod.setEntity((HttpEntity)entity);
            response = httpClient.execute((HttpUriRequest)postMethod);
            String json = EntityUtils.toString((HttpEntity)response.getEntity());
            return json;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    private String getAppAccessUrl(PaasAppsInfo appInfo, PaasEcsInfoDTO ecs) {
        String url = "";
        String server_port = "";
        url = String.format("/allinsaas/apps/index.html?appId=%s", appInfo.getAppId());
        return url;
    }
}

