/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDeployInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allintcp.sdk.sequence.facade.operation.SeqInstInfoService;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AppServerAllotPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        boolean flag = true;
        Connection conn = null;
        this.logger.info("\u8c03\u7528\u5e94\u7528\u90e8\u7f72\u670d\u52a1\u5668\u5206\u914d\u63d2\u4ef6...");
        try {
            conn = this.getPluginConnection();
            FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
            FlowInstMaster flowInstMaster = flowInstMasterDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = flowInstMaster.getEnvId();
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            Integer port = null;
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setSubsId(this.appInfo.getSubsId());
            ecsParam.setAppId(this.appInfo.getAppId());
            ecsParam.setEnvId(currEnvId);
            ecsParam.setPaasDuId("D000001");
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                SeqInstInfoService seqService = (SeqInstInfoService)SpringContextUtils.getBean(SeqInstInfoService.class);
                paasDeployInfoDao.deleteByAppId(this.appInfo.getAppId());
                String logingPath = this.getLoggingPath(currEnvId, paasEnvParamDao);
                logingPath = logingPath + this.appInfo.getAppCode().replaceAll("_|-", "-");
                for (PaasEcsInfo ecs : ecsList) {
                    if (StringUtils.isBlank((CharSequence)ecs.getEcsPort())) {
                        PaasDeployInfo param = new PaasDeployInfo();
                        param.setEcsIp(ecs.getEcsIp());
                        port = paasDeployInfoDao.queryMaxAppPort(param);
                        if (port <= 100) {
                            port = 8080;
                        }
                        Integer n = port;
                        Integer n2 = port = Integer.valueOf(port + 1);
                        ecs.setEcsPort(String.valueOf(port));
                        paasEcsInfoDao.updateByPk(ecs);
                    }
                    PaasDeployInfo adiv = new PaasDeployInfo();
                    adiv.setAppDeployId(seqService.nextSequence("PAAS-INST-ID", this.appInfo.getSubsId()));
                    adiv.setSubsId(this.appInfo.getSubsId());
                    adiv.setAppId(this.appInfo.getAppId());
                    adiv.setAppName(this.appInfo.getAppCode());
                    adiv.setAppCnname(this.appInfo.getAppName());
                    adiv.setAppVersion("0.0.1");
                    adiv.setAppType(this.appInfo.getAppType());
                    adiv.setAppLogPath(logingPath);
                    adiv.setEnvId(currEnvId);
                    adiv.setAppOrder(0);
                    adiv.setEcsId(ecs.getEcsId());
                    adiv.setEcsIp(ecs.getEcsIp());
                    adiv.setEcsName(ecs.getEcsName());
                    adiv.setEcsRegion(ecs.getEcsRegionId());
                    adiv.setAppPort(ecs.getEcsPort());
                    adiv.setAppState("3");
                    adiv.setOperUserid("admin");
                    adiv.setOperTime(CurrentDateUtil.getTodayDateEx2());
                    paasDeployInfoDao.insertPaasDeployInfo(adiv);
                }
            } else {
                this.logger.error("\u8be5\u5e94\u7528\u672a\u5206\u914d\u5e94\u7528\u670d\u52a1\u5668 " + this.appInfo.getAppCode() + "-" + this.appInfo.getAppName());
                flag = false;
            }
        }
        catch (Exception e) {
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private Integer checkAndDelPaasDeployInfo(String appId, PaasDeployInfoDao paasDeployInfoDao) throws SQLException {
        this.logger.info("\u6839\u636e\u5e94\u7528\u6807\u8bc6: " + appId + "\uff0c\u67e5\u8be2\u5e94\u7528\u90e8\u7f72\u4fe1\u606f\u5f00\u59cb...");
        PaasDeployInfo paasDeployInfoVO = new PaasDeployInfo();
        paasDeployInfoVO.setAppId(appId);
        List<PaasDeployInfo> result = paasDeployInfoDao.queryAllByCondition(paasDeployInfoVO);
        if (Objects.nonNull(result) && !result.isEmpty()) {
            List<String> appIdList = result.stream().map(PaasDeployInfo::getAppId).collect(Collectors.toList());
            int num = paasDeployInfoDao.batchDeleteByAppIds(appIdList);
            this.logger.info("\u5220\u9664\u7684\u5e94\u7528\u90e8\u7f72\u4fe1\u606f\u4e3a\uff1a" + num);
            return Integer.valueOf(result.get(0).getAppPort());
        }
        this.logger.info("\u6839\u636e\u5e94\u7528\u6807\u8bc6: " + appId + "\uff0c\u67e5\u8be2\u5e94\u7528\u90e8\u7f72\u4fe1\u606f\u7ed3\u675f\uff0c\u7ed3\u679c\u4e3a\u7a7a.");
        return -1;
    }

    private String getLoggingPath(String envId, PaasEnvParamDao paasEnvParamDao) {
        PaasEnvParam paasEnvParam = new PaasEnvParam();
        paasEnvParam.setEnvId(envId);
        paasEnvParam.setParamCode("logging_path");
        List<PaasEnvParam> envList = paasEnvParamDao.queryPaasEnvParamList(paasEnvParam);
        if (CollectionUtils.isNotEmpty(envList)) {
            String loggingPath = envList.get(0).getParamValue();
            return loggingPath;
        }
        return "";
    }
}

