/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.sdk.beans.core.spring.SpringPropertyUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FadpaasPagePreviewPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private String ngPath = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.ngPath = SpringPropertyUtils.getProperty((String)"fadpaas.preview.nginx.root");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u9884\u89c8\u524d\u7aef\u5e94\u7528\uff0c\u90e8\u7f72\u5230NG:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            String deployRootDir = this.ngPath;
            boolean bl = this.deployFontWeb(deployRootDir, conn);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private boolean cleanBuildDir() {
        String rootPath = SdEnvUtil.BUILD_PATH;
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        return FileUtils.deleteQuietly((File)targetDir);
    }

    private boolean deployFontWeb(String deployRootDir, Connection conn) throws Exception {
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam deploy_src = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "deploy_src");
        String deployPath = deployRootDir;
        String rootPath = SdEnvUtil.PROJECT_PATH;
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        deployPath = deployPath + "/" + this.appInfo.getAppId();
        File rootDir = new File(rootPath + File.separator + appCode + File.separator);
        if (deploy_src != null && StringUtils.isNotBlank((String)deploy_src.getParamValue())) {
            rootDir = new File(rootDir, deploy_src.getParamValue());
        }
        this.uploadDir(rootDir, deployPath);
        return true;
    }

    private void uploadDir(File root, String targetPath) throws Exception {
        if (root.isDirectory()) {
            File[] subFiles;
            for (File subFile : subFiles = root.listFiles()) {
                if (subFile.getName().equals(".git")) continue;
                if (subFile.isDirectory()) {
                    this.uploadDir(subFile, targetPath + "/" + subFile.getName());
                    continue;
                }
                File dir = new File(targetPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileUtils.copyToDirectory((File)subFile, (File)dir);
            }
        } else {
            File dir = new File(targetPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileUtils.copyToDirectory((File)root, (File)dir);
        }
    }
}

