/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;

public class GradlePlugin
extends AbstractPlugin {
    private String pluginName = null;
    private PaasAppsInfo appInfo = null;
    private String taskName = null;
    private String javaHome = null;
    private String gradleCommand = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        this.pluginName = this.context.getSzPluginName();
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam paasAppsParam = new PaasAppsParam();
        paasAppsParam.setAppId(this.appInfo.getAppId());
        paasAppsParam.setParamCode("gradle_command");
        List<PaasAppsParam> paasAppsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
        this.gradleCommand = CollectionUtils.isNotEmpty(paasAppsParamList) ? paasAppsParamList.get(0).getParamValue() : "clean build war";
        this.javaHome = SdEnvUtil.JAVA_HOME_OPENJDK_11;
        if (!new File(this.javaHome).exists()) {
            this.logger.error("\u8bf7\u914d\u7f6eopenjdk.11.java.home");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u7f16\u8bd1\u5e94\u7528: " + this.taskName);
        String projectPath = SdEnvUtil.BUILD_PATH + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode()) + File.separator;
        this.logger.info("gradle \u547d\u4ee4\uff1a" + this.gradleCommand);
        boolean flag = true;
        if (TerminalExecUtil.isWindows()) {
            FileOutputStream out = null;
            String batFileName = "paasBuild.bat";
            try {
                out = new FileOutputStream(new File(projectPath + batFileName));
                String batContent = String.format("set JAVA_HOME=%s\n.\\gradlew.bat %s", this.javaHome, this.gradleCommand);
                IOUtils.write((String)batContent, (OutputStream)out, (String)"UTF-8");
                IOUtils.closeQuietly((OutputStream)out);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            finally {
                IOUtils.closeQuietly(out);
            }
            TerminalExecUtil.localTerminalExec(new File(projectPath), this.logger::info, "paasBuild.bat");
        } else {
            TerminalExecUtil.localTerminalExec(new File(projectPath), this.logger::info, String.format("chmod 755 gradlew ; JAVA_HOME=\"%s\" ; ./gradlew %s", this.javaHome, this.gradleCommand));
        }
        return flag;
    }
}

