/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy;

import com.irdstudio.allinapaas.deliver.console.facade.PluginConfShellService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginConfShellDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ShellExecutePlugin
extends AbstractPlugin {
    protected FlowInstMaster batchInst = null;
    protected PaasAppsInfo appInfo = null;
    protected SSubsInfo sSubsInfo = null;
    protected PaasEnvInfo envInfo = null;
    protected Map<String, Object> extParam;
    protected String actionId;
    protected String actionShell;
    protected String paasDuId = "D000001";
    protected String ecsId = "";
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (ShellExecutePlugin.this.logger != null) {
                ShellExecutePlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (ShellExecutePlugin.this.logger != null) {
                ShellExecutePlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u811a\u672c\u6267\u884c\u63d2\u4ef6\uff0c\u6267\u884c\u5e94\u7528:" + this.appInfo.getAppCode());
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            String currEnvId = this.batchInst.getEnvId();
            this.envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
            PaasAppsParam moduleParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "module");
            PaasAppsParam targetFileParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "targetFile");
            String antTargetFile = targetFileParam != null ? targetFileParam.getParamValue() : null;
            PaasAppsParam jvmOpsParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "jvm");
            String jvmOps = "-Xms128M -Xmx1024M -XX:PermSize=2048m -XX:MaxPermSize=2048m";
            if (jvmOpsParam != null && StringUtils.isNotBlank((String)jvmOpsParam.getParamValue())) {
                jvmOps = jvmOpsParam.getParamValue();
            }
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasAppsParam deployParam = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "deploy_type");
            String deployType = deployParam.getParamValue();
            PluginConfShellService pluginConfShellService = (PluginConfShellService)SpringContextUtils.getBean(PluginConfShellService.class);
            PluginConfShellDTO shellParam = new PluginConfShellDTO();
            shellParam.setPluginId(Integer.valueOf(this.context.getnPluginId()));
            shellParam.setTaskId(this.context.getSzTaskId());
            PluginConfShellDTO shellContentObj = (PluginConfShellDTO)pluginConfShellService.queryByPk((Object)shellParam);
            if (shellContentObj == null) {
                this.logger.error(String.format("\u63d2\u4ef6\u672a\u914d\u7f6e\u811a\u672c\u53c2\u6570\uff0c\u6267\u884c\u5931\u8d25", new Object[0]));
                boolean bl = false;
                return bl;
            }
            String shellContent = shellContentObj.getShellContent();
            if (StringUtils.isBlank((String)shellContent)) {
                this.logger.error(String.format("\u63d2\u4ef6\u672a\u914d\u7f6e\u811a\u672c\u53c2\u6570\uff0c\u6267\u884c\u5931\u8d25", new Object[0]));
                boolean bl = false;
                return bl;
            }
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            if (StringUtils.isNotBlank((String)this.ecsId)) {
                ecsParam.setEcsId(this.ecsId);
            } else {
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setAppId(this.appInfo.getAppId());
                ecsParam.setEnvId(currEnvId);
            }
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                this.logger.info(String.format("\u5f00\u59cb\u5728\u670d\u52a1\u5668%s\u6267\u884c\u811a\u672c \n %s", paasEcsInfo.getEcsIp(), shellContent));
                boolean flag = true;
                RemoteSSHClient rsc = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
                boolean loginFlag = rsc.connect();
                if (!loginFlag) {
                    this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                    boolean bl = loginFlag;
                    return bl;
                }
                rsc.executeCommand(shellContent, this.sshPrinter);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }
}

