/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.nodejs;

import com.irdstudio.allinapaas.deliver.console.facade.PluginConfNodejsService;
import com.irdstudio.allinapaas.deliver.console.facade.dto.PluginConfNodejsDTO;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsParamService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsParamDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.io.FileFilter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NodeJSBuildPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    String npmCommand = "";
    String nodejsVersion = "";
    String frontModule = "";
    static String npm = NodeJSBuildPlugin.isWindows() ? "npm.cmd" : "npm";

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        PluginConfNodejsService service = (PluginConfNodejsService)SpringContextUtils.getBean(PluginConfNodejsService.class);
        PluginConfNodejsDTO param = new PluginConfNodejsDTO();
        param.setPluginConfId(taskId);
        param = (PluginConfNodejsDTO)service.queryByPk((Object)param);
        if (param == null) {
            return false;
        }
        if (message == null) {
            message = new ValidateRtnDTO();
        }
        message.getMessage().addAll(param.validate());
        return CollectionUtils.isEmpty((Collection)message.getMessage());
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return super.copyConfig(batchId, taskId, newTaskId);
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        PluginConfNodejsService service = (PluginConfNodejsService)SpringContextUtils.getBean(PluginConfNodejsService.class);
        PluginConfNodejsDTO param = new PluginConfNodejsDTO();
        param.setPluginConfId(this.context.getSzTaskId());
        param = (PluginConfNodejsDTO)service.queryByPk((Object)param);
        if (param != null) {
            this.npmCommand = param.getNpmCompiler();
            this.nodejsVersion = param.getNodejsVersion();
            this.frontModule = param.getModule();
        } else {
            PaasAppsParamService paasAppsParamService = (PaasAppsParamService)SpringContextUtils.getBean(PaasAppsParamService.class);
            PaasAppsParamDTO paasAppsParam = new PaasAppsParamDTO();
            paasAppsParam.setAppId(this.appInfo.getAppId());
            paasAppsParam.setParamCode("npm_compiler");
            List paasAppsParamList = paasAppsParamService.queryListByPage((Object)paasAppsParam);
            this.npmCommand = CollectionUtils.isNotEmpty((Collection)paasAppsParamList) ? ((PaasAppsParamDTO)paasAppsParamList.get(0)).getParamValue() : "npm run build";
            paasAppsParam.setParamCode("nodejs_version");
            paasAppsParamList = paasAppsParamService.queryListByPage((Object)paasAppsParam);
            this.nodejsVersion = CollectionUtils.isNotEmpty((Collection)paasAppsParamList) ? ((PaasAppsParamDTO)paasAppsParamList.get(0)).getParamValue() : "v16.15.1";
            paasAppsParam.setParamCode("font_module");
            paasAppsParamList = paasAppsParamService.queryListByPage((Object)paasAppsParam);
            this.frontModule = CollectionUtils.isNotEmpty((Collection)paasAppsParamList) ? ((PaasAppsParamDTO)paasAppsParamList.get(0)).getParamValue() : "";
        }
        return true;
    }

    @Override
    public boolean execute() {
        String projectPath = this.context.getFlowConfSource().getRepoLocalPath();
        try {
            String packageJsonName = "package.json";
            String fontModulePath = null;
            if (StringUtils.isNotBlank((CharSequence)this.frontModule)) {
                fontModulePath = new File(projectPath, this.frontModule).getAbsolutePath();
                File packageJsonFile = new File(new File(projectPath, this.frontModule), "package.json");
                if (!packageJsonFile.exists()) {
                    this.logger.error("\u672a\u627e\u5230package.json!");
                    return false;
                }
            } else {
                File[] childFiles;
                File rootDir = new File(projectPath);
                if (!rootDir.exists() || rootDir.isFile()) {
                    this.logger.error("\u5e94\u7528\u5de5\u7a0b\u76ee\u5f55\u4e3a\u7a7a!");
                    return false;
                }
                for (File file : childFiles = rootDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile();
                    }
                })) {
                    if (!file.isFile() || !StringUtils.equals((CharSequence)"package.json", (CharSequence)file.getName())) continue;
                    fontModulePath = rootDir.getAbsolutePath();
                    break;
                }
                if (fontModulePath == null) {
                    File[] childDirs;
                    for (File dir : childDirs = rootDir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory();
                        }
                    })) {
                        File[] childes;
                        for (File f : childes = dir.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                return pathname.isFile();
                            }
                        })) {
                            if (!f.isFile() || !StringUtils.equals((CharSequence)"package.json", (CharSequence)f.getName())) continue;
                            fontModulePath = rootDir.getAbsolutePath();
                            break;
                        }
                        if (fontModulePath != null) break;
                    }
                }
            }
            if (fontModulePath == null) {
                this.logger.error("\u672a\u627e\u5230package.json!");
                return false;
            }
            this.logger.info("\u6267\u884c\u7f16\u8bd1\u547d\u4ee4 " + String.format("source /root/.bashrc && cd %s && nvm install %s && nvm use %s && %s", fontModulePath, this.nodejsVersion, this.nodejsVersion, this.npmCommand));
            TerminalExecUtil.localTerminalExec(new File(fontModulePath), this.logger::info, String.format("source /root/.bashrc && cd %s && nvm install %s && nvm use %s && %s", fontModulePath, this.nodejsVersion, this.nodejsVersion, this.npmCommand));
            return true;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return false;
        }
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }
}

