/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.nodejs;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowConfMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowConfMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ZJGNodeJSBuildPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    String npmCommand = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        FlowConfMasterDao flowConfMasterDao = new FlowConfMasterDao(conn);
        FlowConfMaster batchInfo = flowConfMasterDao.queryWithKeys(this.batchInst.getBatchId());
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsParam paasAppsParam = new PaasAppsParam();
        paasAppsParam.setAppId(this.appInfo.getAppId());
        paasAppsParam.setParamCode("npm_compiler");
        List<PaasAppsParam> paasAppsParamList = paasAppsParamDao.queryPaasAppsParamList(paasAppsParam);
        this.npmCommand = CollectionUtils.isNotEmpty(paasAppsParamList) ? paasAppsParamList.get(0).getParamValue() : "npm run build";
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String projectPath = SdEnvUtil.BUILD_PATH + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        Connection conn = null;
        try {
            String localAgentPath;
            conn = this.getPluginConnection();
            String appTemplateId = this.appInfo.getAppTemplateId();
            String opsPath = localAgentPath = appTemplateId + "-template" + File.separator + appTemplateId + "-project";
            String nodeModulesZipDir = opsPath + File.separator;
            File nodeModulesFile = new File(nodeModulesZipDir + File.separator + "node_modules.zip");
            if (TerminalExecUtil.isWindows()) {
                TerminalExecUtil.localTerminalExec(new File(nodeModulesZipDir), this.logger::info, "type node_modules.zipa* > node_modules.zip");
            } else {
                TerminalExecUtil.localTerminalExec(new File(nodeModulesZipDir), this.logger::info, "cat node_modules.zipa* > node_modules.zip");
            }
            if (!nodeModulesFile.exists()) {
                this.logger.error(String.format("%s \u672a\u627e\u5230", nodeModulesFile.getAbsolutePath()));
                boolean bl = false;
                return bl;
            }
            try (FileInputStream fileIn = new FileInputStream(nodeModulesFile);
                 ZipInputStream zis = new ZipInputStream(fileIn);){
                byte[] buffer = new byte[1024];
                ZipEntry zipEntry = zis.getNextEntry();
                File destDir = new File(projectPath);
                while (zipEntry != null) {
                    File newFile = ZJGNodeJSBuildPlugin.newFile(destDir, zipEntry);
                    if (zipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + newFile);
                        }
                    } else {
                        int len;
                        File parent = newFile.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Failed to create directory " + parent);
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
            }
            catch (Exception zipE) {
                this.logger.error("\u89e3\u538b\u5931\u8d25 " + zipE.getMessage(), zipE);
                boolean bl = false;
                if (conn != null) {
                    this.closePluginConnection(conn);
                }
                return bl;
            }
            this.logger.info("node_modules\u89e3\u538b\u6210\u529f");
            File homeDir = new File(projectPath);
            TerminalExecUtil.localTerminalExec(homeDir, this.logger::info, "chmod -R 755 node_modules/.bin");
            TerminalExecUtil.localTerminalExec(homeDir, this.logger::info, String.format("sed -i 's/REPLACE_APP_PATH/%s/g' .env.production", SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode())));
            TerminalExecUtil.localTerminalExec(homeDir, this.logger::info, StringUtils.split((String)this.npmCommand, (String)" "));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    public static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

