/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.OsrvArrangeTable;
import com.irdstudio.allinrdm.dev.console.types.RowRspType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class DrawOsrvArrangeTable {
    private static final Color nodeBackgroundColor = new Color(246, 247, 255);
    private static final Color nodeBorderColor = new Color(3, 104, 154);
    private static final Color lineColor = new Color(128, 128, 128);
    private static final Color fontColor = new Color(0, 0, 0);

    public File generateImage(String srvModelId, List<OsrvArrangeTable> tables, File dir) {
        if (tables == null || tables.size() == 0) {
            return null;
        }
        int tableSize = tables.size();
        File imageFile = new File(dir.getAbsolutePath() + File.separator + srvModelId + ".png");
        int imageWidth = 986;
        int startNodeWidth = 96;
        BufferedImage image = new BufferedImage(imageWidth, tableSize * 83 + 83 + 30, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.setBackground(Color.white);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        int[] start = new int[]{15, 15};
        this.drawNode(15, 15, startNodeWidth, 34, "\u5f00\u59cb", "center", graphics);
        int startNodeLineX = startNodeWidth / 2 + 15;
        int startNodeLineEndY = 49 + (tableSize - 1) * 83 + 34 + 34 - 2;
        this.drawLine(startNodeLineX, 49, startNodeLineX, startNodeLineEndY, graphics);
        int tableRowsLen = tables.size();
        int rowCondEffect = 0;
        int effectCount = 0;
        int startCondNo = 0;
        for (int i = 0; i < tableRowsLen; ++i) {
            int currentX = startNodeLineX + startNodeWidth / 2;
            int currentY = start[1] + (i + 1) * 83 + 17;
            OsrvArrangeTable tb = tables.get(i);
            if (tb.getRowCondEffect() != null && tb.getRowCondEffect().compareTo(1) > 0) {
                effectCount = rowCondEffect = tb.getRowCondEffect().intValue();
                startCondNo = i;
            }
            if (i >= startCondNo && i < startCondNo + effectCount) {
                if (i == startCondNo) {
                    this.drawLine(startNodeLineX, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                    String rowCondName = StringUtils.isNotBlank((CharSequence)tb.getRowCondName()) ? tb.getRowCondName() : String.format("\u884c%s\u6267\u884c\u6761\u4ef6", startCondNo);
                    this.drawArrow(currentX + 15, currentY - 7, graphics);
                    this.drawNode(currentX + 22, currentY - 17, 148, 34, rowCondName, "center", graphics);
                } else {
                    this.drawLine(currentX + 22 + 74, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                    int fixedY = i == startCondNo + 1 ? 17 : 0;
                    this.drawLine(currentX + 22 + 74, currentY - 83 + fixedY, currentX + 22 + 74, currentY, graphics);
                }
            } else {
                this.drawLine(startNodeLineX, currentY, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY, graphics);
                if (StringUtils.isNotBlank((CharSequence)tb.getRowCondName())) {
                    this.drawArrow(currentX + 15, currentY - 7, graphics);
                    this.drawNode(currentX + 22, currentY - 17, 148, 34, tb.getRowCondName(), "center", graphics);
                }
            }
            String rowTargetName = tb.getRowOpTargetName();
            if (StringUtils.isBlank((CharSequence)rowTargetName)) {
                rowTargetName = "";
            }
            this.drawArrow(currentX + 192 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 22, currentY - 17, 380, 34, rowTargetName, "left", graphics);
            String rowSuccess = RowRspType.trans2Name((String)(StringUtils.isNotBlank((CharSequence)tb.getRowSuccess()) ? tb.getRowSuccess() : RowRspType.GoOn.getCode()));
            String rowFailed = RowRspType.trans2Name((String)(StringUtils.isNotBlank((CharSequence)tb.getRowFailed()) ? tb.getRowFailed() : RowRspType.Finish.getCode()));
            this.drawArrow(currentX + 192 + 380 + 100 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 22, currentY - 17, 70, 34, "\u6210\u529f", "center", graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 70 + 26 + 15, currentY - 7, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 70 + 26 + 22, currentY - 17, 70, 34, rowSuccess, "center", graphics);
            this.drawLine(currentX + 192 + 380 + 50 + 22, currentY, currentX + 192 + 380 + 50 + 22, currentY + 34 + 5, graphics);
            this.drawLine(currentX + 192 + 380 + 50 + 22, currentY + 34 + 5, startNodeLineX + (imageWidth - startNodeLineX - 30 - 20), currentY + 34 + 5, graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 15, currentY - 7 + 34 + 5, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 22, currentY - 17 + 34 + 5, 70, 34, "\u5931\u8d25", "center", graphics);
            this.drawArrow(currentX + 192 + 380 + 100 + 70 + 26 + 15, currentY - 7 + 34 + 5, graphics);
            this.drawNode(currentX + 192 + 380 + 100 + 70 + 26 + 22, currentY - 17 + 34 + 5, 70, 34, rowFailed, "center", graphics);
        }
        try {
            ImageIO.write((RenderedImage)image, "png", imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            imageFile = null;
        }
        return imageFile;
    }

    private void drawNode(int x, int y, int width, int height, String text, String align, Graphics2D graphics) {
        Rectangle rect = new Rectangle(x, y, width, height);
        graphics.draw(rect);
        graphics.setColor(nodeBackgroundColor);
        graphics.fill(rect);
        float thickness = 2.0f;
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setColor(nodeBorderColor);
        graphics.drawRect(x, y, width, height);
        graphics.setFont(new Font("Default", 0, 14));
        graphics.setColor(fontColor);
        if (align.equals("center")) {
            int len = text.length() * 14;
            float _x = (width - 5 - len) / 2;
            _x = (float)(x + 5) + _x;
            graphics.drawString(text, _x, (float)(y + 20));
        } else if (align.equals("left")) {
            graphics.drawString(text, x + 5, y + 20);
        } else {
            int len = text.length() * 14;
            float _x = width - 5 - len;
            _x = (float)x + _x;
            graphics.drawString(text, _x, (float)(y + 20));
        }
    }

    private void drawLine(int x1, int y1, int x2, int y2, Graphics2D graphics) {
        float thickness = 2.0f;
        graphics.setStroke(new BasicStroke(thickness));
        graphics.setColor(lineColor);
        graphics.drawLine(x1, y1, x2, y2);
    }

    private void drawArrow(int x, int y, Graphics2D graphics) {
        int[] xPoints = new int[]{x, x, x + 7};
        int[] yPoints = new int[]{y, y + 14, y + 7};
        graphics.setColor(lineColor);
        graphics.fillPolygon(xPoints, yPoints, 3);
    }
}

