/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.sam.console.facade.ComBaseInfoService;
import com.irdstudio.allinrdm.sam.console.facade.dto.ComBaseInfoDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GenComBaseInfoExcel
implements DocGenerate {
    private final int loadPageSize = 500;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            SSubsInfoDTO subsInfo = new SSubsInfoDTO();
            subsInfo.setSubsId(subsId);
            subsInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)subsInfo);
            if (subsInfo == null) {
                subsInfo = new SSubsInfoDTO();
            }
            String userId = template.getLoginUserId();
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)subsInfo);
            subsInfoMap.put("today", today);
            subsInfoMap.put("todayTime", todayTime);
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet fieldSheet = EasyExcel.writerSheet((Integer)0, null).build();
            this.fillSheetData(excelWriter, fieldSheet, subsId);
            excelWriter.finish();
            WikiSubsPage excelPage = new WikiSubsPage();
            excelPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
            excelPage.setSubsId(subsId);
            excelPage.setDocType("xlsx");
            excelPage.setDocVersion(today);
            excelPage.setDocTag(String.format("[\"\u7ec4\u4ef6\u4fe1\u606f\"]", new Object[0]));
            excelPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(subsId, template, targetFile, excelPage, conn);
            List<File> list = Arrays.asList(targetFile);
            connTool.releaseConnection(conn);
            return list;
        }
        catch (Exception e) {
            try {
                logger.error("\u7ec4\u4ef6\u4fe1\u606f\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
                throw new RuntimeException("\u7ec4\u4ef6\u4fe1\u606f\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                connTool.releaseConnection(conn);
                throw throwable;
            }
        }
    }

    public void fillSheetData(ExcelWriter excelWriter, WriteSheet sheet, String subsId) {
        ComBaseInfoService comBaseInfoService = (ComBaseInfoService)SpringContextUtils.getBean(ComBaseInfoService.class);
        ComBaseInfoDTO param = new ComBaseInfoDTO();
        param.setSubsId(subsId);
        param.setSize(Integer.valueOf(500));
        List list = comBaseInfoService.queryListByPage((Object)param);
        int total = 0;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            total = ((ComBaseInfoDTO)list.get(0)).getTotal();
        }
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = comBaseInfoService.queryListByPage((Object)param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        return null;
    }
}

