/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SSubsIndexDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SSubsIndex;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.WikiSubsPage;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.gendoc.DocGenerate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue.DocTemplateRepoPullQueueExecutor;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.base.IConnPool;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableInfoService;
import com.irdstudio.allinrdm.dam.console.facade.dto.AnalysisIndexExcelDataDTO;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableInfoDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class GenDictMatchAnalysisExcel
implements DocGenerate {
    private final int loadPageSize = 500;
    private ModelTableInfoService modelTableInfoService;

    @Override
    public List<File> generateDoc(PaasDocTemplate template, String subsId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "ddspaas";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(conn);
            SSubsInfo subsInfo = sSubsInfoDao.querySSubsInfoWithKeys(subsId);
            String subsCode = subsInfo.getSubsCode();
            String subsName = subsInfo.getSubsName();
            String userId = template.getLoginUserId();
            this.modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            SSubsIndexDao sSubsIndexDao = new SSubsIndexDao(conn);
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)subsInfo));
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet indexSheet = EasyExcel.writerSheet((Integer)0, (String)"\u5bf9\u6807\u5206\u6790").build();
            AnalysisIndexExcelDataDTO indexData = this.querySysAnalysisIndexData(subsId, null);
            indexData.setSubsName(subsName);
            indexData.setToday(today);
            excelWriter.fill((Object)indexData, indexSheet);
            SSubsIndex fieldCNRate = new SSubsIndex();
            fieldCNRate.setModuleCode(moduleCode);
            fieldCNRate.setSubsId(subsId);
            fieldCNRate.setSubsCode(subsCode);
            fieldCNRate.setSubsName(subsName);
            fieldCNRate.setIndexCode("fieldCNRate");
            fieldCNRate.setIndexName("\u4e2d\u6587\u5145\u8db3\u7387");
            fieldCNRate.setIndexVal(indexData.getFieldCNRate());
            fieldCNRate.setCalcTime(todayTime);
            fieldCNRate.setCreateTime(todayTime);
            fieldCNRate.setCreateUser(userId);
            sSubsIndexDao.saveIndex(fieldCNRate);
            SSubsIndex fieldStdFlagRate = new SSubsIndex();
            fieldStdFlagRate.setModuleCode(moduleCode);
            fieldStdFlagRate.setSubsId(subsId);
            fieldStdFlagRate.setSubsCode(subsCode);
            fieldStdFlagRate.setSubsName(subsName);
            fieldStdFlagRate.setIndexCode("fieldStdFlagRate");
            fieldStdFlagRate.setIndexName("\u6807\u51c6\u8986\u76d6\u7387");
            fieldStdFlagRate.setIndexVal(indexData.getFieldStdFlagRate());
            fieldStdFlagRate.setCalcTime(todayTime);
            fieldStdFlagRate.setCreateTime(todayTime);
            fieldStdFlagRate.setCreateUser(userId);
            sSubsIndexDao.saveIndex(fieldStdFlagRate);
            SSubsIndex fieldMarkFlagRate = new SSubsIndex();
            fieldMarkFlagRate.setModuleCode(moduleCode);
            fieldMarkFlagRate.setSubsId(subsId);
            fieldMarkFlagRate.setSubsCode(subsCode);
            fieldMarkFlagRate.setSubsName(subsName);
            fieldMarkFlagRate.setIndexCode("fieldMarkFlagRate");
            fieldMarkFlagRate.setIndexName("\u6807\u51c6\u6838\u51c6\u7387");
            fieldMarkFlagRate.setIndexVal(indexData.getFieldMarkFlagRate());
            fieldMarkFlagRate.setCalcTime(todayTime);
            fieldMarkFlagRate.setCreateTime(todayTime);
            fieldMarkFlagRate.setCreateUser(userId);
            sSubsIndexDao.saveIndex(fieldMarkFlagRate);
            WriteSheet fieldSheet = EasyExcel.writerSheet((Integer)1, (String)"\u5b57\u6bb5\u6807\u51c6\u7a3d\u6838").build();
            this.analysisFieldData(excelWriter, fieldSheet, subsId, null);
            WriteSheet tableSheet = EasyExcel.writerSheet((Integer)2, (String)"\u5dee\u5f02\u8868\u4fe1\u606f").build();
            this.analysisTableData(excelWriter, tableSheet, subsId, null);
            WriteSheet fieldMissNameSheet = EasyExcel.writerSheet((Integer)5, (String)"\u5b57\u6bb5\u4e2d\u6587\u540d\u7f3a\u5931").build();
            this.analysisFieldMissNameData(excelWriter, fieldMissNameSheet, subsId, null);
            WriteSheet fieldDifferentNameSheet = EasyExcel.writerSheet((Integer)6, (String)"\u8868\u95f4\u5b57\u6bb5\u4e2d\u6587\u540d\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffNameData(excelWriter, fieldDifferentNameSheet, subsId, null);
            WriteSheet fieldDifferentENSheet = EasyExcel.writerSheet((Integer)7, (String)"\u8868\u95f4\u5b57\u6bb5\u82f1\u6587\u540d\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffENData(excelWriter, fieldDifferentENSheet, subsId, null);
            WriteSheet fieldDifferentLenSheet = EasyExcel.writerSheet((Integer)8, (String)"\u8868\u95f4\u5b57\u6bb5\u7c7b\u578b\u957f\u5ea6\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffLenData(excelWriter, fieldDifferentLenSheet, subsId, null);
            WriteSheet fieldMessyNameSheet = EasyExcel.writerSheet((Integer)9, (String)"\u5b57\u6bb5\u4e2d\u6587\u540d\u4e71\u7801").build();
            this.analysisFieldMessyNameData(excelWriter, fieldMessyNameSheet, subsId, null);
            excelWriter.finish();
            WikiSubsPage excelPage = new WikiSubsPage();
            excelPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
            excelPage.setSubsId(subsId);
            excelPage.setDocType("xlsx");
            excelPage.setDocVersion(today);
            excelPage.setDocTag(String.format("[\"\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\"]", new Object[0]));
            excelPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(subsId, template, targetFile, excelPage, conn);
            List<File> list = Arrays.asList(targetFile);
            return list;
        }
        catch (Exception e) {
            logger.error("\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\u62a5\u544a\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\u62a5\u544a\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }

    public AnalysisIndexExcelDataDTO querySysAnalysisIndexData(String subsId, String appId) {
        AnalysisIndexExcelDataDTO data = this.modelTableInfoService.querySysAnalysisIndexData(subsId, appId);
        return data;
    }

    private int calcLoop(int size) {
        int loop = size / 500;
        if (size % 500 > 0) {
            return loop + 1;
        }
        return loop;
    }

    public void analysisFieldData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisTableData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysTableCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysTableCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisFieldMissNameData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldMissNameCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldMissNameCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisFieldDiffNameData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldDiffNameCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldDiffNameCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisFieldDiffENData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldDiffENCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldDiffENCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisFieldDiffLenData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldDiffLenCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldDiffLenCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    public void analysisFieldMessyNameData(ExcelWriter excelWriter, WriteSheet sheet, String subsId, String appId) {
        ModelTableInfoDTO param = new ModelTableInfoDTO();
        param.setSubsId(subsId);
        param.setAppId(appId);
        param.setSize(Integer.valueOf(500));
        List list = this.modelTableInfoService.querySysFieldMessyNameCheckByPage(param);
        int total = param.getTotal();
        if (total < 500) {
            excelWriter.fill((Object)list, sheet);
        } else {
            excelWriter.fill((Object)list, sheet);
            int loop = this.calcLoop(total);
            int i = 2;
            while (i <= loop) {
                int page = i++;
                param.setPage(Integer.valueOf(page));
                list = this.modelTableInfoService.querySysFieldMessyNameCheckByPage(param);
                excelWriter.fill((Object)list, sheet);
            }
        }
    }

    @Override
    public File generateAppDoc(PaasDocTemplate template, String appId, File baseDir, IConnPool connTool, Map<String, Object> extParams) {
        Connection conn = null;
        try {
            String moduleCode = "ddspaas";
            conn = connTool.getConnection();
            File currentFile = this.getDocDirPath(template, baseDir, conn);
            if (!currentFile.exists()) {
                currentFile.mkdirs();
            }
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            PaasAppsInfo appInfo = paasAppsInfoDao.queryByAppId(appId);
            String subsId = appInfo.getSubsId();
            String userId = template.getLoginUserId();
            this.modelTableInfoService = (ModelTableInfoService)SpringContextUtils.getBean(ModelTableInfoService.class);
            SSubsIndexDao sSubsIndexDao = new SSubsIndexDao(conn);
            String today = CurrentDateUtil.getTodayDate();
            String todayTime = CurrentDateUtil.getTodayDateEx2();
            Map subsInfoMap = BeanUtility.bean2Map((Object)((Object)appInfo));
            subsInfoMap.put("subsName", appInfo.getAppName());
            String fileName = template.getDocName();
            if (StringUtils.isNotBlank((CharSequence)template.getDocNameTemplate())) {
                fileName = this.renderDocName(template.getDocNameTemplate(), subsInfoMap);
            }
            DocTemplateRepoPullQueueExecutor.syncRun();
            String excelTemplatePath = DocTemplateRepoPullQueueExecutor.getDocTemplatePath();
            File templateFile = new File(excelTemplatePath, template.getDocFile());
            File targetFile = new File(currentFile, fileName);
            ExcelWriter excelWriter = EasyExcel.write((File)targetFile).withTemplate(templateFile).build();
            WriteSheet indexSheet = EasyExcel.writerSheet((Integer)0, (String)"\u5bf9\u6807\u5206\u6790").build();
            AnalysisIndexExcelDataDTO indexData = this.querySysAnalysisIndexData(subsId, appId);
            indexData.setSubsName(appInfo.getAppName());
            indexData.setSubsCode(appInfo.getAppCode());
            indexData.setToday(today);
            excelWriter.fill((Object)indexData, indexSheet);
            WriteSheet fieldSheet = EasyExcel.writerSheet((Integer)1, (String)"\u5b57\u6bb5\u6807\u51c6\u7a3d\u6838").build();
            this.analysisFieldData(excelWriter, fieldSheet, subsId, appId);
            WriteSheet tableSheet = EasyExcel.writerSheet((Integer)2, (String)"\u5dee\u5f02\u8868\u4fe1\u606f").build();
            this.analysisTableData(excelWriter, tableSheet, subsId, appId);
            WriteSheet fieldMissNameSheet = EasyExcel.writerSheet((Integer)5, (String)"\u5b57\u6bb5\u4e2d\u6587\u540d\u7f3a\u5931").build();
            this.analysisFieldMissNameData(excelWriter, fieldMissNameSheet, subsId, appId);
            WriteSheet fieldDifferentNameSheet = EasyExcel.writerSheet((Integer)6, (String)"\u8868\u95f4\u5b57\u6bb5\u4e2d\u6587\u540d\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffNameData(excelWriter, fieldDifferentNameSheet, subsId, appId);
            WriteSheet fieldDifferentENSheet = EasyExcel.writerSheet((Integer)7, (String)"\u8868\u95f4\u5b57\u6bb5\u82f1\u6587\u540d\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffENData(excelWriter, fieldDifferentENSheet, subsId, appId);
            WriteSheet fieldDifferentLenSheet = EasyExcel.writerSheet((Integer)8, (String)"\u8868\u95f4\u5b57\u6bb5\u7c7b\u578b\u957f\u5ea6\u4e0d\u4e00\u81f4").build();
            this.analysisFieldDiffLenData(excelWriter, fieldDifferentLenSheet, subsId, appId);
            WriteSheet fieldMessyNameSheet = EasyExcel.writerSheet((Integer)9, (String)"\u5b57\u6bb5\u4e2d\u6587\u540d\u4e71\u7801").build();
            this.analysisFieldMessyNameData(excelWriter, fieldMessyNameSheet, subsId, appId);
            excelWriter.finish();
            WikiSubsPage excelPage = new WikiSubsPage();
            excelPage.setDocTitle(fileName.replaceAll(".xlsx", ""));
            excelPage.setSubsId(appInfo.getAppId());
            excelPage.setDocType("xlsx");
            excelPage.setDocVersion(today);
            excelPage.setDocTag(String.format("[\"\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\"]", new Object[0]));
            excelPage.setLoginUserId(template.getLoginUserId());
            this.saveToWikiConsole(appInfo.getAppId(), template, targetFile, excelPage, conn);
            File file = targetFile;
            return file;
        }
        catch (Exception e) {
            logger.error("\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\u62a5\u544a\u751f\u6210\u5f02\u5e38 " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8868\u6a21\u578b\u843d\u6807\u5206\u6790\u62a5\u544a\u751f\u6210\u5f02\u5e38 " + e.getMessage(), e);
        }
        finally {
            connTool.releaseConnection(conn);
        }
    }
}

