/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.docs.git.queue;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDocDirectoryDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocDirectory;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasDocTemplate;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginConfGit;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.jdbc.dbcp.TConnPool;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocTemplateRepoPullQueueExecutor {
    private static Logger logger = LoggerFactory.getLogger(DocTemplateRepoPullQueueExecutor.class);
    private static AtomicBoolean isRunning = new AtomicBoolean(false);
    private static String docTemplatePath = null;
    private static Thread thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            isRunning.set(true);
            Connection conn = null;
            try {
                conn = TConnPool.getDefaultPool().getConnection();
                PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                PluginConfGit pluginParam = new PluginConfGit();
                pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.doc.template.username"));
                pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.doc.template.password"));
                pluginParam.setGitRemotePath(paasEnvParamDao.queryByCodeReturnValue("git.doc.template.remote.path"));
                pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.doc.template.branch.name"));
                int firstIndex = pluginParam.getGitRemotePath().lastIndexOf("/");
                int lastIndex = pluginParam.getGitRemotePath().lastIndexOf(".");
                String gitLocalPathFileName = pluginParam.getGitRemotePath().substring(firstIndex, lastIndex);
                String gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
                if (pluginParam == null || gitLocalPath == null) {
                    return;
                }
                boolean flag = false;
                if (gitLocalPath != null) {
                    flag = DocTemplateRepoPullQueueExecutor.repositoryCreate(gitLocalPath + gitLocalPathFileName, pluginParam.getGitRemotePath(), pluginParam.getGitUserName(), pluginParam.getGitPassword(), pluginParam.getGitBranchName());
                    if (flag) {
                        docTemplatePath = new File(gitLocalPath + gitLocalPathFileName).getAbsolutePath();
                        logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
                    } else {
                        logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + pluginParam.getGitRemotePath());
                    }
                    return;
                }
                return;
            }
            catch (Exception e) {
                logger.error("\u6587\u6863\u6a21\u677f\u4ed3\u5e93\u62c9\u53d6\u4efb\u52a1\u5931\u8d25 " + e.getMessage(), (Throwable)e);
            }
            finally {
                TConnPool.getDefaultPool().releaseConnection(conn);
            }
            isRunning.set(false);
        }
    };

    public static void run() {
        if (isRunning.get()) {
            return;
        }
        DocTemplateRepoPullQueueExecutor.start();
    }

    public static synchronized void start() {
        if (isRunning.get()) {
            return;
        }
        thread.start();
    }

    public static void syncRun() {
        if (docTemplatePath != null) {
            return;
        }
        thread.run();
    }

    private static boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, arg_0 -> ((Logger)logger).info(arg_0));
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public static String getDocTemplatePath() {
        return docTemplatePath;
    }

    public static String getDocDirPath(PaasDocTemplate template, Connection conn) {
        String result = null;
        try {
            PaasDocDirectoryDao paasDocDirectoryDao = new PaasDocDirectoryDao(conn);
            ArrayList<String> paths = new ArrayList<String>();
            PaasDocDirectory dir = paasDocDirectoryDao.queryByPk(template.getDirId());
            paths.add(dir.getDirName());
            while (dir != null) {
                if ((dir = paasDocDirectoryDao.queryByPk(dir.getDirAbvId())) == null) continue;
                paths.add(dir.getDirName());
            }
            Object[] pathA = paths.toArray(new String[0]);
            CollectionUtils.reverseArray((Object[])pathA);
            String path = StringUtils.join((Object[])pathA, (String)File.separator);
            return path;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return result;
        }
    }
}

