/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.ProjectGenerateUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class AppProjectCopyPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private List<PaasAppsParam> appsParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        FlowInstMaster batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(batchInst.getAppId());
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("\u8c03\u7528\u521d\u59cb\u5316\u5e94\u7528\u539f\u578b\u5de5\u7a0b\u63d2\u4ef6,\u590d\u5236\u5e76\u66ff\u6362\u5e94\u7528\u6a21\u677f\uff0c\u751f\u6210{}\u5de5\u7a0b" + this.appInfo.getAppCode());
        String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
        String outFilePath = SdEnvUtil.PROJECT_PATH + appCode;
        if (MyFileUtil.checkFileExist(outFilePath).booleanValue()) {
            try {
                FileUtils.forceDelete((File)new File(outFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        String appTemplateId = this.appInfo.getAppTemplateId();
        String srcStr = appTemplateId + "-template";
        String srcFilePath = SdEnvUtil.TEMPLATE_PATH + File.separator + appTemplateId + "-template" + File.separator + appTemplateId + "-project";
        String replaceStr = appCode;
        ProjectGenerateUtil.copyAndRenameProject(srcFilePath, outFilePath, srcStr, replaceStr);
        try {
            FileUtils.deleteDirectory((File)new File(outFilePath + File.separator + ".git"));
        }
        catch (IOException e) {
            this.logger.error("\u590d\u5236\u76ee\u5f55\u5f02\u5e38 " + outFilePath, e);
            return false;
        }
        return true;
    }
}

