/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinrdm.sam.console.facade.SdkComFileService;
import com.irdstudio.allinrdm.sam.console.facade.dto.SdkComFileDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SDKComCopyPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private Map<String, Object> extParam = null;
    private PaasAppsInfo sdkInfo = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        FlowInstMaster batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(batchInst);
        String sdkId = MapUtils.getString(this.extParam, (Object)"sdkId");
        this.sdkInfo = paasAppsInfoDao.queryByAppId(sdkId);
        if (this.sdkInfo == null) {
            this.logger.error("\u5bfc\u5165\u7684\u7ec4\u4ef6\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean flag = true;
        try {
            SdkComFileService sdkComSourceService = (SdkComFileService)SpringContextUtils.getBean(SdkComFileService.class);
            String comId = MapUtils.getString(this.extParam, (Object)"comId");
            SdkComFileDTO sourceParam = new SdkComFileDTO();
            sourceParam.setComId(comId);
            sourceParam.setAscOrder("sourcePath");
            List sourceList = sdkComSourceService.queryList((Object)sourceParam);
            if (CollectionUtils.isNotEmpty((Collection)sourceList)) {
                String appRootPath = new File(SdEnvUtil.getAppBuildOutputPath(this.appInfo)).getAbsolutePath();
                String sdkRootPath = new File(SdEnvUtil.TEMPLATE_PATH + File.separator + this.sdkInfo.getAppCode()).getAbsolutePath();
                String sdkReplaceStartsWith = "/" + SdEnvUtil.wrapperAppCode(this.sdkInfo.getAppCode());
                String appReplaceString = "/" + SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
                for (SdkComFileDTO sdkSource : sourceList) {
                    File targetPosition;
                    File parentDir;
                    String sourcePath = sdkSource.getSourcePath();
                    File file = new File(sdkRootPath, sourcePath);
                    if (!file.exists() || !file.isFile()) continue;
                    String targetPath = "";
                    if (StringUtils.startsWith((CharSequence)sourcePath, (CharSequence)sdkReplaceStartsWith)) {
                        targetPath = StringUtils.replaceOnce((String)sourcePath, (String)sdkReplaceStartsWith, (String)appReplaceString);
                    }
                    if (!(parentDir = (targetPosition = new File(appRootPath, targetPath)).getParentFile()).exists()) {
                        parentDir.mkdirs();
                    }
                    FileUtils.copyFile((File)file, (File)targetPosition);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u590d\u5236\u7ec4\u4ef6\u5230\u6a21\u5757\u5e94\u7528\u9519\u8bef " + e.getMessage(), e);
            flag = false;
        }
        return flag;
    }
}

