/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUser;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.common.SSubsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginConfGit;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class GitPushSrvAppPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private PluginConfGit pluginParam = null;
    private String gitLocalPathFileName;
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam = null;
    private String userEmail = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection connection, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(connection);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(connection);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(connection);
        SUserProfileDao sUserProfileDao = new SUserProfileDao(connection);
        SUserDao sUserDao = new SUserDao(connection);
        String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
        if (userProfile == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            return false;
        }
        SUser user = new SUser();
        user.setActorno(currentUserId);
        user = sUserDao.queryByPk(user);
        this.userEmail = user != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)user.getUsermail()) ? user.getUsermail() : String.format("%s@%s.com", currentUserId, "irdstudio");
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginConfGit();
        this.pluginParam.setGitUserName(userProfile.getGitUsername());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
        } else {
            this.pluginParam.setGitPassword(userProfile.getGitPassword());
        }
        this.pluginParam.setGitBranchName(paasEnvParamDao.queryByCodeReturnValue("git.push.branch.name"));
        SSubsInfoDao sSubsInfoDao = new SSubsInfoDao(connection);
        SSubsInfo sSubsInfo = sSubsInfoDao.querySSubsInfoWithKeys(this.appInfo.getSubsId());
        String pushUrl = sSubsInfo.getSubsGitGroup();
        if (StringUtils.isBlank((String)pushUrl)) {
            pushUrl = paasEnvParamDao.queryByCodeReturnValue("git.push.remote.path");
        }
        if (pushUrl.endsWith("/")) {
            pushUrl = pushUrl.substring(0, pushUrl.length() - 1);
        }
        String group = pushUrl.substring(pushUrl.lastIndexOf("/") + 1);
        if (!pushUrl.endsWith("/")) {
            pushUrl = pushUrl + "/";
        }
        this.pluginParam.setGitRemotePath(String.format("%s%s.git", pushUrl, SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode())));
        if (this.pluginParam == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info(String.format("\u51c6\u5907\u5c06\u751f\u6210\u7684\u5de5\u7a0b %s \u63a8\u9001\u81f3\u8fdc\u7a0b\u4ed3\u5e93", this.appInfo.getAppCode()));
        boolean flag = true;
        String suffix = "-remote";
        String gitLocalPath = SdEnvUtil.getAppBuildOutputPath(this.appInfo);
        String remoteRepoPath = gitLocalPath + suffix;
        try {
            File localProjectDir;
            flag = this.repositoryCreate(remoteRepoPath, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (!flag) {
                this.logger.info("\u8fdc\u7a0b\u4ed3\u5e93\u4e0d\u5b58\u5728\uff0c \u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
                return flag;
            }
            File remoteRepoDir = new File(remoteRepoPath);
            if (remoteRepoDir.exists() && remoteRepoDir.isDirectory()) {
                File[] remoteSubDir;
                for (File sub : remoteSubDir = remoteRepoDir.listFiles()) {
                    if (sub.isDirectory()) {
                        if (sub.getName().equals(".git")) continue;
                        FileUtils.deleteDirectory((File)sub);
                        continue;
                    }
                    FileUtils.deleteQuietly((File)sub);
                }
            }
            if ((localProjectDir = new File(gitLocalPath)).exists() && localProjectDir.isDirectory()) {
                File[] localSubDir;
                for (File sub : localSubDir = localProjectDir.listFiles()) {
                    File target = new File(remoteRepoDir, sub.getName());
                    if (sub.isDirectory()) {
                        if (sub.getName().equals(".git")) continue;
                        FileUtils.copyDirectory((File)sub, (File)target);
                        continue;
                    }
                    FileUtils.copyFile((File)sub, (File)target);
                }
            }
            if (flag = this.repositoryPush(new File(remoteRepoPath).getAbsolutePath(), this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName())) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
                this.appInfo.setAppGitUrl(this.pluginParam.getGitRemotePath());
                Connection conn = null;
                try {
                    conn = this.getPluginConnection();
                    PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
                    paasAppsInfoDao.updateByPk(this.appInfo);
                }
                catch (Exception e) {
                    this.logger.info("\u66f4\u65b0\u5e94\u7528\u4ed3\u5e93\u5730\u5740\u5931\u8d25" + e.getMessage());
                }
                finally {
                    if (conn != null) {
                        this.closePluginConnection(conn);
                    }
                }
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            return flag;
        }
        catch (Exception e) {
            flag = false;
            return flag;
        }
    }

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    public boolean repositoryPush(String localPath, String remotePath, String username, String password, String branchName) {
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.addAll();
            jGitUtil.commit(username, this.userEmail, "auto code generate commit on batchSerialNo#" + this.context.getSzBatchSn());
            jGitUtil.push(remotePath, false);
        }
        catch (Exception e) {
            this.logger.error("\u63d0\u4ea4\u4ee3\u7801\u5f02\u5e38 " + e.getMessage(), e);
            return false;
        }
        jGitUtil.close();
        return true;
    }
}

