/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.git;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SUserProfileDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SUserProfile;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.JGitUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.PluginConfGit;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.git.TerminalExecUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class SDKComGitPullPlugin
extends AbstractPlugin {
    private PaasAppsInfo appInfo = null;
    private Map<String, Object> extParam = null;
    private String pluginName = null;
    private PluginConfGit pluginParam = null;
    private String gitLocalPath = null;
    private String gitLocalPathFileName;
    private String gitlabName;
    private String gitlabPwd;

    public boolean repositoryCreate(String localPath, String remotePath, String username, String password, String branchName) {
        if (TerminalExecUtil.isWindows()) {
            JGitUtil.shallowClone(localPath, remotePath, username, password, branchName, this.logger::info);
            return true;
        }
        JGitUtil jGitUtil = new JGitUtil(localPath, remotePath, username, password);
        try {
            jGitUtil.pull(branchName);
        }
        catch (Exception e) {
            try {
                jGitUtil.cloneBranch(branchName);
            }
            catch (Exception e1) {
                jGitUtil.close();
                File localRepoFile = new File(localPath);
                if (localRepoFile.exists()) {
                    FileUtils.deleteQuietly((File)localRepoFile);
                }
                try {
                    jGitUtil = new JGitUtil(localPath, remotePath, username, password);
                    jGitUtil.cloneBranch(branchName);
                }
                catch (Exception e2) {
                    this.logger.error("git \u62c9\u53d6\u4ed3\u5e93\u5931\u8d25" + e2.getMessage(), e2);
                    e2.printStackTrace();
                    return false;
                }
            }
        }
        jGitUtil.close();
        return true;
    }

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String s) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        FlowInstMaster batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.appInfo = paasAppsInfoDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(batchInst);
        this.pluginName = this.context.getSzPluginName();
        this.pluginParam = new PluginConfGit();
        this.pluginParam.setGitUserName(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.username"));
        this.pluginParam.setGitPassword(paasEnvParamDao.queryByCodeReturnValue("git.dev.template.store.password"));
        this.gitlabName = paasEnvParamDao.queryByCodeReturnValue("git.username");
        this.gitlabPwd = paasEnvParamDao.queryByCodeReturnValue("git.password");
        SUserProfileDao sUserProfileDao = new SUserProfileDao(conn);
        String currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        SUserProfile userProfile = sUserProfileDao.queryByPk(currentUserId);
        if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            return false;
        }
        this.pluginParam.setGitUserName(userProfile.getGitUsername());
        if (StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
            this.pluginParam.setGitPassword(userProfile.getGitAccessToken());
        } else {
            this.pluginParam.setGitPassword(userProfile.getGitPassword());
        }
        String comId = MapUtils.getString(this.extParam, (Object)"comId");
        String sdkId = MapUtils.getString(this.extParam, (Object)"sdkId");
        PaasAppsInfo sdkInfo = paasAppsInfoDao.queryByAppId(sdkId);
        if (sdkInfo == null) {
            this.logger.error("\u5bfc\u5165\u7684\u7ec4\u4ef6\u5e94\u7528\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        this.pluginParam.setGitRemotePath(sdkInfo.getAppGitUrl());
        this.pluginParam.setGitBranchName("master");
        this.gitLocalPathFileName = sdkInfo.getAppCode();
        this.gitLocalPath = SdEnvUtil.TEMPLATE_PATH;
        if (this.pluginParam == null || this.gitLocalPath == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + s + "\u7684\u6570\u636eGit\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        this.logger.info("........................................................................");
        boolean flag = true;
        if (this.gitLocalPath != null) {
            flag = this.repositoryCreate(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.pluginParam.getGitUserName(), this.pluginParam.getGitPassword(), this.pluginParam.getGitBranchName());
            if (!flag) {
                flag = this.repositoryCreate(this.gitLocalPath + this.gitLocalPathFileName, this.pluginParam.getGitRemotePath(), this.gitlabName, this.gitlabPwd, this.pluginParam.getGitBranchName());
            }
            if (flag) {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u6210\u529f\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            } else {
                this.logger.info("\u4ee3\u7801\u66f4\u65b0\u5931\u8d25\uff0c\u672c\u5730\u66f4\u65b0\u8def\u5f84:" + this.gitLocalPath + "\n\u8fdc\u7a0b\u8def\u5f84\u4e3a\uff1a" + this.pluginParam.getGitRemotePath());
            }
            return flag;
        }
        return false;
    }
}

