/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.market;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.MarketSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasMarketAppinfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvTestCaseDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasMarketAppinfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvTestCase;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.market.AbstractMarketTask;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class CPSqliteTestCaseTask
extends AbstractMarketTask {
    private PaasMarketAppinfo appInfo = null;
    private Map<String, Object> extParam = null;

    @Override
    public boolean initTask(Map<String, Object> extParam, Connection conn) throws SQLException {
        this.extParam = extParam;
        PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryPaasMarketAppinfo(MapUtils.getString(extParam, (Object)"marketAppId"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute() {
        boolean sysApps3;
        Connection sqliteConn;
        Connection conn;
        block24: {
            block25: {
                boolean bl;
                block22: {
                    block23: {
                        boolean flag = true;
                        conn = null;
                        sqliteConn = null;
                        try {
                            conn = this.getConnection();
                            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
                            String subsFlag = MapUtils.getString(this.extParam, (Object)"subsFlag");
                            String marketSource = MapUtils.getString(this.extParam, (Object)"marketSource");
                            String subsId = MapUtils.getString(this.extParam, (Object)"marketSubsId");
                            ArrayList<PaasMarketAppinfo> appInfoList = new ArrayList<PaasMarketAppinfo>();
                            if (StringUtils.equals((CharSequence)marketSource, (CharSequence)MarketSource.Inside.getCode())) {
                                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                                    PaasMarketAppinfoDao paasAppsInfoDao = new PaasMarketAppinfoDao(conn);
                                    PaasMarketAppinfo appParam = new PaasMarketAppinfo();
                                    appParam.setSubsId(subsId);
                                    List<PaasMarketAppinfo> sysApps2 = paasAppsInfoDao.queryPaasMarketAppinfoList(appParam);
                                    appInfoList.addAll(sysApps2);
                                } else {
                                    appInfoList.add(this.appInfo);
                                }
                            } else {
                                String respJson;
                                PaasMarketAppinfo param;
                                String apiUrl = paasEnvParamDao.queryByCodeReturnValue("allinpaas.open.api.http.url");
                                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                                    param = new PaasMarketAppinfo();
                                    param.setSubsId(subsId);
                                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo/index", (Object)param);
                                    if (StringUtils.isBlank((CharSequence)respJson)) {
                                        bl = flag = false;
                                        if (conn == null) break block22;
                                        break block23;
                                    }
                                    List sysApps3 = JSON.parseArray((String)respJson, PaasMarketAppinfo.class);
                                    appInfoList.addAll(sysApps3);
                                } else {
                                    param = new PaasMarketAppinfo();
                                    param.setMarketAppId(MapUtils.getString(this.extParam, (Object)"marketAppId"));
                                    respJson = this.requestOpenApi(apiUrl + "/om/paas/market/appinfo", (Object)param);
                                    if (StringUtils.isBlank((CharSequence)respJson)) {
                                        sysApps3 = flag = false;
                                        if (conn == null) break block24;
                                        break block25;
                                    }
                                    PaasMarketAppinfo marketApp = (PaasMarketAppinfo)((Object)JSON.parseObject((String)respJson, PaasMarketAppinfo.class));
                                    appInfoList.add(marketApp);
                                }
                            }
                            Iterator iterator = appInfoList.iterator();
                            while (iterator.hasNext()) {
                                PaasMarketAppinfo srcApp = (PaasMarketAppinfo)((Object)iterator.next());
                                File sqliteFile = null;
                                if (StringUtils.equals((CharSequence)subsFlag, (CharSequence)YesOrNO.YES.getCode())) {
                                    String marketUrl = paasEnvParamDao.queryByCodeReturnValue("git.market.remote.path");
                                    sqliteFile = this.getIMPSysSqliteFile(this.extParam, marketUrl, null);
                                } else {
                                    sqliteFile = this.getSqliteFile(srcApp);
                                }
                                sqliteConn = this.getSqliteConnection(sqliteFile);
                                PaasMarketAppinfoDao keyMapDao = new PaasMarketAppinfoDao(sqliteConn);
                                String appId = keyMapDao.queryKeyMap(srcApp.getAppId());
                                SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(sqliteConn);
                                SrvTestCaseDao srvTestCaseDao = new SrvTestCaseDao(sqliteConn);
                                SrvModelInfo srvParam = new SrvModelInfo();
                                srvParam.setAppId(appId);
                                List<SrvModelInfo> srvModelList = srvModelInfoDao.querySrvModelInfoList(srvParam, Arrays.asList(SrvModelCatalogEnum.ComponentServer.getCode(), SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode(), SrvModelCatalogEnum.SrvServer.getCode(), SrvModelCatalogEnum.SdkServer.getCode()));
                                for (SrvModelInfo modelInfo : srvModelList) {
                                    SrvTestCase caseParam = new SrvTestCase();
                                    caseParam.setSrvModelId(modelInfo.getSrvModelId());
                                    List<SrvTestCase> testCaseList = srvTestCaseDao.querySrvTestCaseList(caseParam);
                                    this.batchInsertPage("`allinrdm_db`.srv_test_case", testCaseList, conn);
                                }
                                this.closeSqliteConnection(sqliteConn);
                            }
                            return flag;
                        }
                        catch (Exception e) {
                            this.logger.error("\u4ecesqlite\u590d\u5236\u6d4b\u8bd5\u6848\u4f8b\u5230\u5e73\u53f0", (Throwable)e);
                            flag = false;
                            return flag;
                        }
                    }
                    this.closeConnection(conn);
                }
                if (sqliteConn == null) return bl;
                this.closeSqliteConnection(sqliteConn);
                return bl;
            }
            this.closeConnection(conn);
        }
        if (sqliteConn == null) return sysApps3;
        this.closeSqliteConnection(sqliteConn);
        return sysApps3;
        finally {
            if (conn != null) {
                this.closeConnection(conn);
            }
            if (sqliteConn != null) {
                this.closeSqliteConnection(sqliteConn);
            }
        }
    }
}

