/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.sdk.beans.ssh.io.SSHOutputPrinter;
import com.irdstudio.sdk.beans.ssh.utils.RemoteSSHClient;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MonitorA95JarDeployPlugin
extends AbstractBuilderPlugin {
    private FlowInstMaster batInst = null;
    private Map<String, Object> extParam = null;
    protected SSHOutputPrinter sshPrinter = new SSHOutputPrinter(){

        public void print(String line) {
            if (MonitorA95JarDeployPlugin.this.logger != null) {
                MonitorA95JarDeployPlugin.this.logger.info(line);
            } else {
                System.out.println(line);
            }
        }

        public void printError(String line) {
            if (MonitorA95JarDeployPlugin.this.logger != null) {
                MonitorA95JarDeployPlugin.this.logger.error(line);
            } else {
                System.err.println(line);
            }
        }
    };

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        String gitUrl = paasEnvParamDao.queryByCodeReturnValue("git.worker.remote.path");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info("\u90e8\u7f72JAR\u5e94\u7528\u670d\u52a1\u5668\uff0c\u90e8\u7f72\u5e94\u7528:" + this.batInst.getAppName());
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
            FlowInstMaster flowInstMaster = flowInstMasterDao.queryByBatchSerialNo(this.context.getSzBatchSn());
            String currEnvId = flowInstMaster.getEnvId();
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
            PaasTemplateParam moduleParam = paasTemplateParamDao.queryPaasTemplateParamByCode(this.batInst.getAppId(), "module");
            String module = moduleParam.getParamValue();
            PaasEnvParam deployRoot = paasEnvParamDao.queryByCode("deploy_root", currEnvId);
            String deployRootDir = deployRoot.getParamValue();
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEcsId(this.batInst.getEcsId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            for (PaasEcsInfo paasEcsInfo : ecsList) {
                int status;
                this.logger.info(String.format("\u5f00\u59cb\u90e8\u7f72\u5e94\u7528%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", paasEcsInfo.getAppName(), paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsPort()));
                RemoteSSHClient rsc = new RemoteSSHClient(paasEcsInfo.getEcsIp(), paasEcsInfo.getEcsLoginUser(), paasEcsInfo.getEcsLoginPwd());
                boolean loginFlag = rsc.connect();
                if (!loginFlag) {
                    this.logger.error("\u767b\u9646\u670d\u52a1\u5668\u5931\u8d25");
                    boolean bl = loginFlag;
                    return bl;
                }
                String opsPath = null;
                if (StringUtils.isBlank(opsPath)) {
                    this.logger.error("\u65e0\u6cd5\u83b7\u53d6\u8fd0\u7ef4\u6a21\u677f\u6240\u5728\u76ee\u5f55\uff0c\u8bf7\u68c0\u67e5\u8fd0\u7ef4\u6a21\u677f\u4ed3\u5e93\u914d\u7f6e");
                    boolean bl = false;
                    return bl;
                }
                String localAgentPath = opsPath + File.separator;
                if (!rsc.fileExists(deployRootDir)) {
                    rsc.executeCommand("mkdir -p " + deployRootDir, this.sshPrinter);
                    rsc.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                    rsc.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
                }
                if (!rsc.fileExists(deployRootDir + "/startJarApp.sh")) {
                    rsc.upload(localAgentPath + "startJarApp.sh", deployRootDir);
                    rsc.executeCommand("chmod 777 " + deployRootDir + "/startJarApp.sh", this.sshPrinter);
                }
                String rootPath = SdEnvUtil.BUILD_PATH;
                String appCode = this.batInst.getAppCode();
                PaasAppsParam appParam = new PaasAppsParam();
                appParam.setParamCode("module");
                appParam.setParamValue(module);
                File jarFile = this.searchTargetJarFile(rootPath, appCode, appParam);
                if (jarFile == null || !jarFile.exists()) {
                    this.logger.error("\u83b7\u53d6\u4e0d\u5230jar " + rootPath + File.separator + appCode);
                    boolean bl = false;
                    return bl;
                }
                String startModelName = jarFile.getName().substring(0, jarFile.getName().length() - 4);
                this.logger.info("\u672c\u5730jar\u5305: " + jarFile.getAbsolutePath());
                rsc.upload(jarFile.getAbsolutePath(), deployRootDir);
                String jvmOps = "-Xms128M -Xmx1024M -XX:PermSize=2048m -XX:MaxPermSize=2048m";
                this.logger.info("\u6267\u884c\u547d\u4ee4 " + deployRootDir + "/startJarApp.sh " + startModelName + " " + currEnvId);
                String command = String.format("cd " + deployRootDir + " && bash ./startJarApp.sh %s '%s' %s %s", startModelName, jvmOps, currEnvId, paasEcsInfo.getEcsPort());
                if (StringUtils.equals((String)module, (String)"apmpaas-agent-server")) {
                    command = String.format("cd " + deployRootDir + " && bash ./startJarApp.sh %s '%s' %s", startModelName, jvmOps, currEnvId);
                }
                if ((status = rsc.executeCommand(command, this.sshPrinter)) == 0) continue;
                this.logger.info("\u6267\u884c\u53d1\u5e03\u547d\u4ee4 " + deployRootDir + "/startJarApp.sh \u72b6\u6001 " + status);
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return true;
    }

    private File searchTargetJarFile(String rootPath, String appCode, PaasAppsParam moduleParam) {
        String targetModule;
        File targetFile;
        File targetDir = new File(rootPath + File.separator + appCode + File.separator);
        if (moduleParam != null && StringUtils.isNotBlank((String)moduleParam.getParamValue()) && (targetFile = new File(targetDir, (targetModule = moduleParam.getParamValue()) + File.separator + "target" + File.separator + targetModule + ".jar")).exists() && targetFile.isFile()) {
            return targetFile;
        }
        File jarFile = null;
        if (targetDir.exists() && targetDir.isDirectory()) {
            File[] moduleFiles;
            for (File f : moduleFiles = targetDir.listFiles()) {
                File[] jarFiles;
                File buildTargetF;
                String name;
                if (!f.isDirectory() || !(name = f.getName()).startsWith(appCode) || !(buildTargetF = new File(f, "target")).exists()) continue;
                for (File jarF : jarFiles = buildTargetF.listFiles()) {
                    if (!jarF.isFile() || !jarF.getName().endsWith(".jar.original")) continue;
                    jarFile = new File(jarF.getParentFile(), jarF.getName().substring(0, jarF.getName().length() - 9));
                    return jarFile;
                }
            }
        } else {
            this.logger.error("\u5e94\u7528\u7f16\u8bd1\u76ee\u5f55\u4e0d\u5b58\u5728 " + targetDir.getAbsolutePath());
            return null;
        }
        return null;
    }
}

