/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.devops.maven.MavenConf;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.RSAUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamLogger;

public class MonitorA95MavenPlugin
extends AbstractPlugin {
    private String pluginName = null;
    private MavenConf mavenConf = null;
    private String taskName = null;
    private FlowInstMaster batInst = null;
    private Map<String, Object> extParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        this.pluginName = this.context.getSzPluginName();
        String batchSerialNo = this.context.getSzBatchSn();
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        this.mavenConf = new MavenConf();
        this.mavenConf.setMavenParam("mvn clean package -DskipTests=true");
        this.mavenConf.setMavenSettings(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        this.mavenConf.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        String gitUrl = paasEnvParamDao.queryByCodeReturnValue("git.worker.remote.path");
        int firstIndex = gitUrl.lastIndexOf("/");
        int lastIndex = gitUrl.lastIndexOf(".");
        String moduleName = this.batInst.getAppCode();
        this.mavenConf.setLocalPath(SdEnvUtil.BUILD_PATH + moduleName);
        if (this.mavenConf.getMavenHome() == null || this.mavenConf.getLocalPath() == null || this.mavenConf.getMavenSettings() == null) {
            this.context.setSzLastErrorMsg("\u672a\u8bfb\u53d6\u5230\u914d\u7f6e\u6807\u8bc6\u4e3a\uff1a" + szConfIdentify + "\u7684\u6570\u636eMySQL\u914d\u7f6e!");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        String[] commands;
        this.logger.info("\u5e94\u7528\u53c2\u6570\u5904\u7406");
        Connection conn = null;
        try {
            conn = this.getPluginConnection();
            this.dealWithApplicationProperties(conn);
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u53c2\u6570\u5904\u7406\u5931\u8d25 " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        this.logger.info("\u8c03\u7528Maven\u7f16\u8bd1\u63d2\u4ef6\uff0c\u7f16\u8bd1\u5e94\u7528: " + this.taskName);
        String projectPomPath = this.mavenConf.getLocalPath() + File.separator + "pom.xml";
        this.logger.info("pom\u6587\u4ef6\uff1a" + projectPomPath);
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        if (StringUtils.isNotBlank((CharSequence)this.mavenConf.getMavenSettings())) {
            request.setUserSettingsFile(new File(this.mavenConf.getMavenSettings()));
        }
        request.setPomFile(new File(projectPomPath));
        ArrayList<String> goals = new ArrayList<String>();
        ArrayList profiles = new ArrayList();
        Properties buildProps = new Properties();
        if (StringUtils.isBlank((CharSequence)this.mavenConf.getMavenParam())) {
            goals.add("clean");
            goals.add("install");
        }
        for (String command : commands = StringUtils.split((String)this.mavenConf.getMavenParam(), (String)" ")) {
            if ("mvn".equals(command)) continue;
            if (StringUtils.startsWith((CharSequence)command, (CharSequence)"-D")) {
                String _command = command.replace("-D", "");
                String[] bps = StringUtils.split((String)_command, (String)"=");
                String key = bps[0];
                String val = bps.length > 1 ? bps[1] : "";
                buildProps.put(key, val);
                continue;
            }
            if (StringUtils.equals((CharSequence)"-U", (CharSequence)command) || StringUtils.equals((CharSequence)"--update-snapshots", (CharSequence)command)) {
                request.setUpdateSnapshots(true);
                continue;
            }
            goals.add(command);
        }
        request.setGoals(goals);
        request.setProperties(buildProps);
        request.setProfiles(profiles);
        DefaultInvoker invoker = new DefaultInvoker();
        invoker.setMavenHome(new File(this.mavenConf.getMavenHome()));
        invoker.setLogger((InvokerLogger)new PrintStreamLogger(System.err, 2){});
        invoker.setOutputHandler(new InvocationOutputHandler(){

            public void consumeLine(String s) throws IOException {
                System.out.println(s);
                MonitorA95MavenPlugin.this.logger.info(s);
            }
        });
        boolean flag = true;
        InvocationResult result = null;
        try {
            result = invoker.execute((InvocationRequest)request);
            flag = true;
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            this.logger.error((Object)e);
            this.context.setSzLastErrorMsg(e.getMessage());
            flag = false;
        }
        if (flag) {
            if (result.getExitCode() == 0) {
                this.logger.info("maven plugin build success");
                flag = true;
            } else {
                this.logger.info("maven plugin build error");
                this.context.setSzLastErrorMsg("Maven\u7f16\u8bd1\u5931\u8d25");
                flag = false;
            }
        }
        invoker = null;
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealWithApplicationProperties(Connection conn) throws Exception {
        block12: {
            File[] propertiesFiles;
            File localBuildFile = new File(this.mavenConf.getLocalPath());
            if (!localBuildFile.exists()) break block12;
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasTemplateParam moduleParam = paasTemplateParamDao.queryPaasTemplateParamByCode(this.batInst.getAppId(), "module");
            File moduleFile = new File(localBuildFile, moduleParam.getParamValue());
            if (!moduleFile.exists()) break block12;
            String publicKey = PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.publicKey");
            PaasEcsInfo ecsInfo = paasEcsInfoDao.queryByPk(this.batInst.getEcsId());
            String serverPort = ecsInfo.getEcsPort();
            Map<String, Object> paramMap = paasTemplateParamDao.queryTemplateParamMap(this.batInst.getAppId(), null);
            String database_ip = paasTemplateParamDao.parseParamValue(ParamSource.Env.getCode(), "DCDB.ECS_IP", null, conn);
            paramMap.put("database_ip", database_ip);
            String database_name = (String)paramMap.get("database_name");
            String database_username = (String)paramMap.get("database_username");
            String database_password = (String)paramMap.get("database_password");
            File propertiesDirFile = new File(moduleFile, "src" + File.separator + "main" + File.separator + "resources");
            for (File file : propertiesFiles = propertiesDirFile.listFiles()) {
                if (file.isDirectory()) continue;
                File applicationFile = null;
                if (!file.getName().startsWith("application") || !(applicationFile = file).exists()) continue;
                FileInputStream configInputStream = null;
                List configs = null;
                try {
                    configInputStream = new FileInputStream(applicationFile);
                    configs = IOUtils.readLines((InputStream)configInputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(configInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)configInputStream);
                if (configs == null) {
                    this.logger.error("\u8bfb\u53d6application.properties\u5931\u8d25");
                    return;
                }
                int count = 0;
                for (int i = 0; i < configs.size(); ++i) {
                    String line = (String)configs.get(i);
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"dataSource.url=")) {
                        line = String.format("dataSource.url=jdbc:mysql://%s:3306/%s?characterEncoding=UTF8&zeroDateTimeBehavior=convertToNull&transformedBitIsBoolean=true&allowMultiQueries=true", database_ip, database_name);
                        configs.set(i, line);
                        ++count;
                        continue;
                    }
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"dataSource.username=")) {
                        line = "dataSource.username=" + RSAUtility.encryptByBase64((String)database_username, (String)publicKey);
                        configs.set(i, line);
                        ++count;
                        continue;
                    }
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"dataSource.password=")) {
                        line = "dataSource.password=" + RSAUtility.encryptByBase64((String)database_password, (String)publicKey);
                        configs.set(i, line);
                        ++count;
                        continue;
                    }
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"server.port=")) {
                        line = "server.port=" + serverPort;
                        configs.set(i, line);
                        ++count;
                        continue;
                    }
                    if (StringUtils.startsWith((CharSequence)line, (CharSequence)"dubbo.registry.address=")) {
                        line = "dubbo.registry.address=" + MapUtils.getString(paramMap, (Object)"registry_address");
                        configs.set(i, line);
                        ++count;
                        continue;
                    }
                    if (!StringUtils.startsWith((CharSequence)line, (CharSequence)"com.alipay.sofa.rpc.registry.address=")) continue;
                    line = "com.alipay.sofa.rpc.registry.address=" + MapUtils.getString(paramMap, (Object)"registry_address");
                    configs.set(i, line);
                    ++count;
                }
                FileOutputStream configOutStream = null;
                try {
                    FileUtils.forceDelete((File)applicationFile);
                    configOutStream = new FileOutputStream(applicationFile);
                    IOUtils.writeLines((Collection)configs, (String)System.lineSeparator(), (OutputStream)configOutStream, (String)"UTF-8");
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(configOutStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)configOutStream);
            }
        }
    }
}

