/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.design.console.types.ParamSource;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateSqlDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateSql;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.sdk.beans.db.util.MyJdbcUtil;
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.ScriptRunner;

public class MonitorA95MysqlDeployPlugin
extends AbstractPlugin {
    private FlowInstMaster batInst = null;
    private Map<String, Object> extParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        this.logger.info(String.format("\u8c03\u7528\u521d\u59cb\u5316mysql\u6570\u636e\u5e93\u63d2\u4ef6,%s\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5e93...", this.batInst.getAppId()));
        Connection conn = null;
        boolean flag = true;
        String database_name = "";
        String database_username = "root";
        String database_password = "Zaqpwdxsw@2";
        try {
            conn = this.getPluginConnection();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasTemplateSqlDao paasTemplateSqlDao = new PaasTemplateSqlDao(conn);
            String currEnvId = this.batInst.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            String database_ip = paasTemplateParamDao.parseParamValue(ParamSource.Env.getCode(), "DCDB.ECS_IP", null, conn);
            Map<String, Object> appsParam = paasTemplateParamDao.queryTemplateParamMap(this.batInst.getAppId(), null);
            appsParam.put("database_ip", database_ip);
            database_name = MapUtils.getString(appsParam, (Object)"database_name");
            database_username = MapUtils.getString(appsParam, (Object)"database_username", (String)"root");
            appsParam.put("database_username", database_username);
            database_password = MapUtils.getString(appsParam, (Object)"database_password", (String)"Zaqpwdxsw@2");
            appsParam.put("database_password", database_password);
            this.logger.info(String.format("\u5f00\u59cb\u521b\u5efa\u6570\u636e\u5e93%s\u5230\u670d\u52a1\u5668%s,\u7aef\u53e3%s", this.batInst.getAppName(), database_ip, "3306"));
            Connection createConn = null;
            try {
                createConn = TdpAgentCommonUtil.getNativeConnection(null, appsParam, true);
                Statement st = MyJdbcUtil.createStatement((Connection)createConn);
                String createDB = "CREATE DATABASE `" + database_name + "`";
                MyJdbcUtil.executeSql((Statement)st, (String)createDB);
                createConn.close();
                createConn = TdpAgentCommonUtil.getNativeConnection(null, appsParam, false);
                flag = this.runScript(createConn, paasTemplateSqlDao);
                this.addEnvInfoToProdDb(envInfo, createConn);
            }
            catch (Exception ie) {
                this.logger.error(ie.getMessage());
            }
            finally {
                if (createConn != null) {
                    MyJdbcUtil.close((Connection)createConn);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u5e94\u7528\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38 " + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }

    private boolean runScript(Connection conn, PaasTemplateSqlDao paasTemplateSqlDao) throws Exception {
        boolean flag = true;
        PaasTemplateSql sqlParam = new PaasTemplateSql();
        sqlParam.setAppTemplateId(this.batInst.getAppId());
        List<PaasTemplateSql> sqlList = null;
        try {
            sqlList = paasTemplateSqlDao.queryPaasTemplateSqlList(sqlParam);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u521d\u59cb\u5316\u811a\u672c\u5f02\u5e38", e);
            flag = false;
        }
        if (CollectionUtils.isNotEmpty(sqlList)) {
            for (PaasTemplateSql sql : sqlList) {
                ScriptRunner sr = new ScriptRunner(conn);
                BufferedReader reader = new BufferedReader(new StringReader(sql.getSqlContent()));
                sr.runScript((Reader)reader);
            }
        }
        return flag;
    }

    private void addEnvInfoToProdDb(PaasEnvInfo envInfo, Connection conn) {
        if (StringUtils.equals((CharSequence)this.batInst.getBatchId(), (CharSequence)"INSTALL-APPS-CONSOLE")) {
            ScriptRunner sr = new ScriptRunner(conn);
            BufferedReader reader = new BufferedReader(new StringReader(String.format("DROP TABLE IF EXISTS s_env_info;\nCREATE TABLE s_env_info(\n    env_id varchar(32) not null comment '\u73af\u5883\u6807\u8bc6',\n    env_name varchar(80) not null comment '\u73af\u5883\u540d\u79f0',\n    primary key(env_id)\n);\nINSERT INTO s_env_info(env_id, env_name)\nVALUES ('%s', '%s');\n", envInfo.getEnvId(), envInfo.getEnvName())));
            sr.runScript((Reader)reader);
        }
    }
}

