/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.monitor;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasTemplateParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasTemplateParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class MonitorA95UpdateEnvPlugin
extends AbstractPlugin {
    private FlowInstMaster batInst = null;
    private Map<String, Object> extParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        PaasTemplateInfoDao paasTemplateInfoDao = new PaasTemplateInfoDao(conn);
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Connection conn = null;
        boolean flag = true;
        try {
            conn = this.getPluginConnection();
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            PaasTemplateParamDao paasTemplateParamDao = new PaasTemplateParamDao(conn);
            PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
            String currEnvId = this.batInst.getEnvId();
            PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
            PaasTemplateParam moduleParam = paasTemplateParamDao.queryPaasTemplateParamByCode(this.batInst.getAppId(), "module");
            String module = moduleParam.getParamValue();
            PaasEcsInfo ecsParam = new PaasEcsInfo();
            ecsParam.setEcsId(this.batInst.getEcsId());
            List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
            if (CollectionUtils.isNotEmpty(ecsList)) {
                PaasEcsInfo paasEcsInfo = ecsList.get(0);
                String ip = paasEcsInfo.getEcsIp();
                String port = paasEcsInfo.getEcsPort();
                String address = String.format("http://%s:%s/%s", ip, port, module);
                envInfo.setEnvAppsPortal(address);
                paasEnvInfoDao.updateByPk(envInfo);
            }
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u4ea4\u4ed8\u73af\u5883\u95e8\u6237\u5730\u5740\u5931\u8d25" + e.getMessage(), e);
            flag = false;
        }
        finally {
            if (conn != null) {
                this.closePluginConnection(conn);
            }
        }
        return flag;
    }
}

