/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginInstFindbugsModuleDTO;
import com.irdstudio.allinapaas.quality.console.facade.dto.PluginInstFindbugsRptDTO;
import com.irdstudio.allinapaas.quality.console.types.PluginReportStat;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FindBugsReportParser {
    public static PluginInstFindbugsRptDTO parse(String reportId, String appId, File rootDir, ILogger logger) {
        PluginInstFindbugsRptDTO reportInfo;
        block34: {
            reportInfo = null;
            try {
                if (!rootDir.exists()) {
                    reportInfo.setErrInf("\u672a\u627e\u5230Findbugs\u62a5\u544a");
                    reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                    return reportInfo;
                }
                reportInfo = new PluginInstFindbugsRptDTO();
                reportInfo.setChkCls(Integer.valueOf(0));
                reportInfo.setChkBugs(Integer.valueOf(0));
                reportInfo.setChkErrors(Integer.valueOf(0));
                reportInfo.setChkMissCls(Integer.valueOf(0));
                reportInfo.setReqSts(PluginReportStat.DONE.getCode());
                reportInfo.setModuleList(new ArrayList());
                File[] moduleFiles = rootDir.listFiles();
                if (moduleFiles == null || moduleFiles.length <= 0) break block34;
                for (File moduleFile : moduleFiles) {
                    File targetSiteDir;
                    File findBugsHtmlFile;
                    if (moduleFile.isFile() || !(findBugsHtmlFile = new File(targetSiteDir = new File(moduleFile, "target/site"), "findbugs.html")).exists()) continue;
                    PluginInstFindbugsModuleDTO reportModule = new PluginInstFindbugsModuleDTO();
                    reportModule.setReportId(reportId);
                    reportModule.setMdlName(moduleFile.getName());
                    reportModule.setNowFileRte("findbugs.html");
                    Document doc = Jsoup.parse((File)findBugsHtmlFile.getAbsoluteFile(), (String)"UTF-8", (String)"");
                    Elements elements = ((Element)doc.getElementsByClass("b").get(0)).getElementsByTag("td");
                    for (int i = 0; i < elements.size(); ++i) {
                        if (i == 0) {
                            logger.info(reportModule.getMdlName() + " findbugs \u68c0\u6d4b\u7c7b\u6570\u91cf\u7edf\u8ba1\u6267\u884c\u7ed3\u679c: " + ((Element)elements.get(i)).text());
                            reportModule.setChkCls(Integer.valueOf(((Element)elements.get(i)).text()));
                            reportInfo.setChkCls(Integer.valueOf(reportInfo.getChkCls() + reportModule.getChkCls()));
                            continue;
                        }
                        if (i == 1) {
                            logger.info(reportModule.getMdlName() + " findbugs bugs\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c: " + ((Element)elements.get(i)).text());
                            reportModule.setChkBugs(Integer.valueOf(((Element)elements.get(i)).text()));
                            reportInfo.setChkBugs(Integer.valueOf(reportInfo.getChkBugs() + reportModule.getChkBugs()));
                            continue;
                        }
                        if (i == 2) {
                            logger.info(reportModule.getMdlName() + " findbugs \u9519\u8bef\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c: " + ((Element)elements.get(i)).text());
                            reportModule.setChkErrors(Integer.valueOf(((Element)elements.get(i)).text()));
                            reportInfo.setChkErrors(Integer.valueOf(reportInfo.getChkErrors() + reportModule.getChkErrors()));
                            continue;
                        }
                        if (i != 3) continue;
                        logger.info(reportModule.getMdlName() + " findbugs \u68c0\u6d4b\u5ffd\u7565\u6570\u7edf\u8ba1\u6267\u884c\u7ed3\u679c: " + ((Element)elements.get(i)).text());
                        reportModule.setChkMissCls(Integer.valueOf(((Element)elements.get(i)).text()));
                        reportInfo.setChkMissCls(Integer.valueOf(reportInfo.getChkMissCls() + reportModule.getChkMissCls()));
                    }
                    try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                         ZipOutputStream zos = new ZipOutputStream(baos);){
                        PluginInstFindbugsRptDTO finalReportInfo = reportInfo;
                        Path directory = targetSiteDir.toPath();
                        Files.walk(directory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> {
                            if (StringUtils.equals((CharSequence)p.toFile().getName(), (CharSequence)"findbugs.html")) {
                                return true;
                            }
                            return StringUtils.contains((CharSequence)p.toFile().getAbsolutePath(), (CharSequence)"css") || StringUtils.contains((CharSequence)p.toFile().getAbsolutePath(), (CharSequence)"images");
                        }).forEach(file -> {
                            try {
                                String entryName = directory.relativize((Path)file).toString();
                                zos.putNextEntry(new ZipEntry(entryName));
                                Files.copy(file, zos);
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + finalReportInfo.getReportId(), e);
                                finalReportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                                finalReportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                            }
                        });
                        zos.finish();
                        byte[] zipData = baos.toByteArray();
                        String base64String = Base64.getEncoder().encodeToString(zipData);
                        reportModule.setRptData(base64String);
                        reportInfo.getModuleList().add(reportModule);
                    }
                    catch (Exception e) {
                        logger.error("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                        reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u6570\u636e\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                        reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + reportInfo.getReportId(), e);
                reportInfo.setErrInf("\u89e3\u6790\u62a5\u544a\u53d1\u751f\u5f02\u5e38:" + e.getMessage());
                reportInfo.setReqSts(PluginReportStat.FAIL.getCode());
            }
        }
        return reportInfo;
    }
}

