/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsArtifactService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsMeasureService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsArtifactDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsMeasureDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.batch.AppRepoPullTask;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.deploy.MavenRunner;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.ILogger;
import com.irdstudio.allinapaas.executor.application.executor.core.tinycore.log.LoggerFactory;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.allinapaas.executor.types.ExecutorInstInfo;
import com.irdstudio.allinapaas.portal.console.facade.PaasArtifactResultService;
import com.irdstudio.allinapaas.portal.console.facade.SummaryService;
import com.irdstudio.allinapaas.portal.console.facade.dto.PaasArtifactResultDTO;
import com.irdstudio.allinapaas.portal.console.types.YesOrNO;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceInfoService;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceLicenseService;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceVersionService;
import com.irdstudio.allinrdm.sam.console.facade.TclOpensourceVulService;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceInfoDTO;
import com.irdstudio.allinrdm.sam.console.facade.dto.TclOpensourceVersionDTO;
import com.irdstudio.allintcp.admin.facade.AllinCloudPortalClient;
import com.irdstudio.allintcp.admin.facade.dto.SUserProfileDTO;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OpenCompScanPlugin
extends AbstractPlugin {
    protected FlowInstMaster batchInst = null;
    protected Map<String, Object> extParam;
    PaasAppsArtifactService paasAppsArtifactService;
    PaasArtifactResultService paasArtifactResultService;
    TclOpensourceInfoService tclOpensourceInfoService;
    TclOpensourceVersionService tclOpensourceVersionService;
    TclOpensourceVulService tclOpensourceVulService;
    TclOpensourceLicenseService tclOpensourceLicenseService;
    PaasAppsMeasureService paasAppsMeasureService;
    SummaryService summaryService;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        return true;
    }

    @Override
    public boolean execute() {
        this.paasAppsArtifactService = (PaasAppsArtifactService)SpringContextUtils.getBean(PaasAppsArtifactService.class);
        this.paasArtifactResultService = (PaasArtifactResultService)SpringContextUtils.getBean(PaasArtifactResultService.class);
        this.tclOpensourceInfoService = (TclOpensourceInfoService)SpringContextUtils.getBean(TclOpensourceInfoService.class);
        this.tclOpensourceVersionService = (TclOpensourceVersionService)SpringContextUtils.getBean(TclOpensourceVersionService.class);
        this.tclOpensourceVulService = (TclOpensourceVulService)SpringContextUtils.getBean(TclOpensourceVulService.class);
        this.tclOpensourceLicenseService = (TclOpensourceLicenseService)SpringContextUtils.getBean(TclOpensourceLicenseService.class);
        this.paasAppsMeasureService = (PaasAppsMeasureService)SpringContextUtils.getBean(PaasAppsMeasureService.class);
        this.summaryService = (SummaryService)SpringContextUtils.getBean(SummaryService.class);
        String reportId = MapUtils.getString(this.extParam, (Object)"reportId");
        String userId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String now = CurrentDateUtil.getTodayDateEx2();
        String appId = this.batchInst.getAppId();
        ILogger pluginOutputLogger = this.logger;
        String appRepoPath = "";
        if (this.context.getFlowConfSource() == null) {
            String currentUserId;
            AllinCloudPortalClient portalClient = (AllinCloudPortalClient)SpringContextUtils.getBean(AllinCloudPortalClient.class);
            SUserProfileDTO userProfile = portalClient.querySUserProfileByPk(currentUserId = MapUtils.getString(this.extParam, (Object)"createUserId"));
            if (userProfile == null || StringUtils.isBlank((CharSequence)userProfile.getGitUsername()) || !StringUtils.isNotBlank((CharSequence)userProfile.getGitPassword()) && !StringUtils.isNotBlank((CharSequence)userProfile.getGitAccessToken())) {
                this.logger.error("************************************\u8bf7\u5728\u4e2a\u4eba\u8bbe\u7f6e\u5173\u8054git\u8d26\u53f7\u4fe1\u606f\uff01************************************");
            }
            String user = userProfile.getGitUsername();
            String password = userProfile.getGitAccessToken();
            if (StringUtils.isBlank((CharSequence)password)) {
                password = userProfile.getGitPassword();
            }
            AppRepoPullTask appRepoPullTask = new AppRepoPullTask(appId, null, user, password);
            appRepoPullTask.syncRun();
            appRepoPath = appRepoPullTask.getAppPath();
            String fullLogFileName = ExecutorInstInfo.BATCH_LOG_PATH + File.separator + reportId + ".log";
            this.logger.info("\u63d2\u4ef6\u8c03\u7528\u65b9\u5f0f\uff0c\u8f93\u51fa\u65e5\u5fd7\u5230 " + fullLogFileName);
            pluginOutputLogger = LoggerFactory.makeTxtFileLogger(fullLogFileName, true);
        } else {
            appRepoPath = this.context.getFlowConfSource().getRepoLocalPath();
        }
        File appRepoDir = new File(appRepoPath);
        if (!appRepoDir.exists()) {
            pluginOutputLogger.error("\u5e94\u7528\u4ed3\u5e93\u62c9\u53d6\u5931\u8d25");
            return false;
        }
        pluginOutputLogger.info("\u8bfb\u53d6\u5230\u4ed3\u5e93\u5730\u5740\uff1a" + appRepoPath);
        RecordDependencyLogger recordDependencyLogger = new RecordDependencyLogger(pluginOutputLogger);
        MavenRunner mavenRunner = new MavenRunner("mvn dependency:tree", appRepoDir.getAbsolutePath(), recordDependencyLogger);
        mavenRunner.setMavenHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.path"));
        mavenRunner.setJavaHome(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.java.home.path"));
        mavenRunner.setSetting(PropertiesUtil.getPropertyByKey((String)"application", (String)"tdp.maven.settings.path"));
        mavenRunner.run();
        List<String> dependencies = recordDependencyLogger.getDependencies();
        HashMap<String, String> artifactMap = new HashMap<String, String>();
        int count = 0;
        if (CollectionUtils.isNotEmpty(dependencies)) {
            PaasAppsArtifactDTO deleteParam = new PaasAppsArtifactDTO();
            deleteParam.setAppId(appId);
            this.paasAppsArtifactService.deleteByCond(deleteParam);
            for (String dependency : dependencies) {
                String[] arr;
                if (StringUtils.equalsAny((CharSequence)dependency, (CharSequence[])new CharSequence[]{"-"}) || (arr = StringUtils.split((String)dependency, (String)":")).length < 3) continue;
                String groupId = arr[0];
                String artifactId = arr[1];
                String fileExt = arr[2];
                String versionId = arr[3];
                PaasArtifactResultDTO artifactDTO = new PaasArtifactResultDTO();
                artifactDTO.setRecordKeyid(UUIDUtil.getShortUUID());
                artifactDTO.setGroupId(groupId);
                artifactDTO.setArtifactId(artifactId);
                artifactDTO.setVersionId(versionId);
                artifactDTO.setAppId(appId);
                artifactDTO.setReportId(reportId);
                artifactDTO.setFileExt(fileExt);
                artifactDTO.setFileName(String.format("%s-%s.%s", artifactId, versionId, fileExt));
                artifactDTO.setCreateUser(userId);
                artifactDTO.setCreateTime(now);
                artifactDTO.setLastModifyUser(userId);
                artifactDTO.setLastModifyTime(now);
                TclOpensourceInfoDTO info = this.findOpensourceInfo(artifactDTO);
                if (info == null || artifactMap.get(info.getGroupId() + info.getArtifactId() + info.getVersionId()) != null) continue;
                artifactDTO.setOpensourceId(info.getOpensourceId());
                this.paasArtifactResultService.insert((Object)artifactDTO);
                PaasAppsArtifactDTO appArtifact = new PaasAppsArtifactDTO();
                BeanUtility.beanCopy((Object)artifactDTO, (Object)appArtifact);
                this.paasAppsArtifactService.insert((Object)appArtifact);
                artifactMap.put(info.getGroupId() + info.getArtifactId() + info.getVersionId(), info.getOpensourceId() + info.getVersionId());
                ++count;
            }
        }
        pluginOutputLogger.info("\u5f00\u6e90\u7ec4\u4ef6\u626b\u63cf\u7ed3\u675f\uff0c\u7d2f\u8ba1\u626b\u63cf\u5230\u7ec4\u4ef6 " + count + "\u4e2a");
        PaasAppsMeasureDTO measure = new PaasAppsMeasureDTO();
        HashMap<String, String> measureParam = new HashMap<String, String>();
        measureParam.put("appId", appId);
        measureParam.put("reportId", reportId);
        List measureDataList = this.summaryService.querySummaryByMapperId("queryAppOSScanSummaryReport", measureParam);
        if (CollectionUtils.isNotEmpty((Collection)measureDataList)) {
            for (Map data : measureDataList) {
                if (StringUtils.equals((CharSequence)MapUtils.getString((Map)data, (Object)"name"), (CharSequence)"opensourceCount")) {
                    measure.setOpensourceCount(MapUtils.getInteger((Map)data, (Object)"num"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)MapUtils.getString((Map)data, (Object)"name"), (CharSequence)"vulCount")) {
                    measure.setVulCount(MapUtils.getInteger((Map)data, (Object)"num"));
                    continue;
                }
                if (StringUtils.equals((CharSequence)MapUtils.getString((Map)data, (Object)"name"), (CharSequence)"security")) {
                    measure.setSecurityScore(new BigDecimal(MapUtils.getString((Map)data, (Object)"num", (String)"0")));
                    continue;
                }
                if (StringUtils.equals((CharSequence)MapUtils.getString((Map)data, (Object)"name"), (CharSequence)"license")) {
                    measure.setLicenseScore(new BigDecimal(MapUtils.getString((Map)data, (Object)"num", (String)"0")));
                    continue;
                }
                if (!StringUtils.equals((CharSequence)MapUtils.getString((Map)data, (Object)"name"), (CharSequence)"licenseCount")) continue;
                measure.setLicenseCount(MapUtils.getInteger((Map)data, (Object)"num"));
            }
            measure.setAppId(appId);
            this.paasAppsMeasureService.updateByPk((Object)measure);
        }
        return true;
    }

    public TclOpensourceInfoDTO findOpensourceInfo(PaasArtifactResultDTO artifactDTO) {
        try {
            TclOpensourceInfoDTO info = new TclOpensourceInfoDTO();
            info.setGroupId(artifactDTO.getGroupId());
            info.setArtifactId(artifactDTO.getArtifactId());
            List findInfoList = this.tclOpensourceInfoService.queryListByPage((Object)info);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)findInfoList)) {
                TclOpensourceVersionDTO versionInfo = new TclOpensourceVersionDTO();
                versionInfo.setVersionId(artifactDTO.getVersionId());
                versionInfo.setOpensourceId(((TclOpensourceInfoDTO)findInfoList.get(0)).getOpensourceId());
                versionInfo = (TclOpensourceVersionDTO)this.tclOpensourceVersionService.queryByPk((Object)versionInfo);
                if (versionInfo != null) {
                    if (StringUtils.equals((CharSequence)YesOrNO.YES.getCode(), (CharSequence)versionInfo.getVersionState())) {
                        BeanUtility.beanCopy((Object)versionInfo, findInfoList.get(0));
                        return (TclOpensourceInfoDTO)findInfoList.get(0);
                    }
                    boolean flag = this.fetchVulLibInfo((TclOpensourceInfoDTO)findInfoList.get(0), versionInfo);
                    if (flag) {
                        versionInfo.setVersionState(YesOrNO.NO.getCode());
                        this.tclOpensourceVersionService.updateByPk((Object)versionInfo);
                    }
                    BeanUtility.beanCopy((Object)versionInfo, findInfoList.get(0));
                    return (TclOpensourceInfoDTO)findInfoList.get(0);
                }
                versionInfo = new TclOpensourceVersionDTO();
                BeanUtility.beanCopy(findInfoList.get(0), (Object)versionInfo);
                versionInfo.setVersionId(artifactDTO.getVersionId());
                versionInfo.setFileExt(artifactDTO.getFileExt());
                versionInfo.setFileName(artifactDTO.getFileName());
                this.fetchVulLibInfo((TclOpensourceInfoDTO)findInfoList.get(0), versionInfo);
                this.tclOpensourceVersionService.insert((Object)versionInfo);
                BeanUtility.beanCopy((Object)versionInfo, findInfoList.get(0));
                return (TclOpensourceInfoDTO)findInfoList.get(0);
            }
            BeanUtility.beanCopy((Object)artifactDTO, (Object)info);
            info.setOpensourceId(UUIDUtil.getShortUUID());
            info.setLanguage("java");
            TclOpensourceVersionDTO versionInfo = new TclOpensourceVersionDTO();
            BeanUtility.beanCopy((Object)info, (Object)versionInfo);
            this.fetchVulLibInfo(info, versionInfo);
            this.tclOpensourceVersionService.insert((Object)versionInfo);
            this.tclOpensourceInfoService.insert((Object)info);
            return info;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    public boolean fetchVulLibInfo(TclOpensourceInfoDTO info, TclOpensourceVersionDTO versionInfo) {
        return false;
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }

    public static class RecordDependencyLogger
    implements ILogger {
        List<String> dependencies = new ArrayList<String>();
        ILogger logger = null;
        Pattern pattern = Pattern.compile("^\\[INFO\\][\\s\\+\\-\\\\\\|]+(\\S++)$");

        public RecordDependencyLogger(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void info(Object message) {
            Matcher m;
            String console = message.toString();
            if (StringUtils.startsWith((CharSequence)console, (CharSequence)"[INFO]") && StringUtils.indexOf((CharSequence)console, (CharSequence)"-----------<") <= 0 && (m = this.pattern.matcher(console)).matches()) {
                this.logger.info("\u8bfb\u53d6\u5230\u4f9d\u8d56 " + console);
                String dependency = m.group(1);
                this.dependencies.add(dependency);
            }
        }

        @Override
        public void debug(Object message) {
            this.info(message);
        }

        @Override
        public void debug(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void error(Object message) {
            this.info(message);
        }

        @Override
        public void error(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void fatal(Object message) {
            this.info(message);
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void info(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void warn(Object message) {
            this.info(message);
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.info(message);
        }

        @Override
        public void setName(String categoryName) {
        }

        @Override
        public ILogger makeSubLogger(String subCategoryName) {
            return null;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }
    }
}

