/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.scan;

import com.irdstudio.allinapaas.design.console.facade.PaasAppsInfoService;
import com.irdstudio.allinapaas.design.console.facade.PaasAppsMeasureService;
import com.irdstudio.allinapaas.design.console.facade.SSubsInfoService;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsInfoDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.PaasAppsMeasureDTO;
import com.irdstudio.allinapaas.design.console.facade.dto.SSubsInfoDTO;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.AbstractPlugin;
import com.irdstudio.allinapaas.executor.facade.dto.ValidateRtnDTO;
import com.irdstudio.paas.dbo.facade.DataQualityProblemService;
import com.irdstudio.paas.dbo.facade.dto.DataQualityProblemDTO;
import com.irdstudio.sdk.beans.core.util.CurrentDateUtil;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.UUIDUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class SqlQualityScanPlugin
extends AbstractPlugin {
    protected FlowInstMaster batchInst = null;
    protected Map<String, Object> extParam;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        return true;
    }

    @Override
    public boolean execute() {
        DataQualityProblemService dataQualityProblemService = (DataQualityProblemService)SpringContextUtils.getBean(DataQualityProblemService.class);
        SSubsInfoService sSubsInfoService = (SSubsInfoService)SpringContextUtils.getBean(SSubsInfoService.class);
        PaasAppsInfoService paasAppsInfoService = (PaasAppsInfoService)SpringContextUtils.getBean(PaasAppsInfoService.class);
        PaasAppsMeasureService paasAppsMeasureService = (PaasAppsMeasureService)SpringContextUtils.getBean(PaasAppsMeasureService.class);
        SSubsInfoDTO subsInfo = new SSubsInfoDTO();
        subsInfo.setSubsId(this.batchInst.getSubsId());
        subsInfo = (SSubsInfoDTO)sSubsInfoService.queryByPk((Object)subsInfo);
        PaasAppsInfoDTO appInfo = new PaasAppsInfoDTO();
        appInfo.setAppId(this.batchInst.getAppId());
        appInfo = (PaasAppsInfoDTO)paasAppsInfoService.queryByPk((Object)appInfo);
        DataQualityProblemDTO problem = new DataQualityProblemDTO();
        String reportId = MapUtils.getString(this.extParam, (Object)"reportId");
        String userId = MapUtils.getString(this.extParam, (Object)"createUserId");
        String now = CurrentDateUtil.getTodayDateEx2();
        problem.setProblemId(UUIDUtil.getShortUUID());
        problem.setRuleName("\u6d4b\u8bd5");
        problem.setSubsId(this.batchInst.getSubsId());
        problem.setSubsCode(subsInfo.getSubsCode());
        problem.setSubsName(subsInfo.getSubsName());
        problem.setAppId(appInfo.getAppId());
        problem.setAppCode(appInfo.getAppCode());
        problem.setAppName(appInfo.getAppName());
        problem.setProblemStat("6");
        problem.setChargeMan(userId);
        problem.setCreateUser(userId);
        problem.setCreateTime(now);
        problem.setReportId(reportId);
        problem.setBatchSerialNo(this.batchInst.getBatchSerialNo());
        dataQualityProblemService.insert((Object)problem);
        PaasAppsMeasureDTO measure = new PaasAppsMeasureDTO();
        measure.setAppId(this.batchInst.getAppId());
        measure.setSqlProblemCount(Integer.valueOf(1));
        paasAppsMeasureService.updateByPk((Object)measure);
        return true;
    }

    @Override
    public boolean validate(String batchId, String taskId, ValidateRtnDTO message) {
        return true;
    }

    @Override
    public boolean copyConfig(String batchId, String taskId, String newTaskId) {
        return true;
    }
}

