/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean;

import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.bean.FileReplacePattern;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceDirAndFileBean {
    private static Logger logger = LoggerFactory.getLogger(ReplaceDirAndFileBean.class);
    private List<String> srcStrList = new ArrayList<String>();
    private List<String> outStrList = new ArrayList<String>();
    private List<FileReplacePattern> replacePatternList = null;
    private String srcFilePath;
    private String outFilePath;
    private String defFindStr;
    private String defReplaceStr;
    private String[] ignorePostfixArray;

    public ReplaceDirAndFileBean(String srcFilePath, String outFilePath, String defFindStr, String defReplaceStr) {
        this.srcFilePath = srcFilePath;
        this.outFilePath = outFilePath;
        this.defFindStr = defFindStr;
        this.defReplaceStr = defReplaceStr;
    }

    public void addFileReplacePattern(FileReplacePattern pattern) {
        if (this.replacePatternList == null) {
            this.replacePatternList = new ArrayList<FileReplacePattern>();
        }
        this.replacePatternList.add(pattern);
    }

    public void execute() {
        logger.info("\u6267\u884c\u66ff\u6362,\u6e90\u76ee\u5f55:{},\u8f93\u51fa\u76ee\u5f55:{}", (Object)this.srcFilePath, (Object)this.outFilePath);
        if (!(Objects.nonNull(this.srcFilePath) && Objects.nonNull(this.outFilePath) && Objects.nonNull(this.defFindStr) && Objects.nonNull(this.defReplaceStr))) {
            throw new RuntimeException("\u53c2\u6570\u8f93\u5165\u4e0d\u6b63\u786e");
        }
        String[] srcStrArr = this.defFindStr.split("\\.");
        String[] outStrArr = this.defReplaceStr.split("\\.");
        this.srcStrList = Arrays.asList(srcStrArr);
        this.outStrList = Arrays.asList(outStrArr);
        this.changeAndGeneratorFile(this.srcFilePath, this.outFilePath, this.defFindStr, this.defReplaceStr);
    }

    public void changeAndGeneratorFile(String srcDir, String outDir, String srcStr, String replaceStr) {
        File srcFile = new File(srcDir);
        File outFile = new File(outDir);
        if (srcFile.exists()) {
            this.searchFile(srcFile, srcStr, replaceStr);
        }
    }

    private void searchFile(File file, String srcStr, String replaceStr) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File srcFile : files = file.listFiles()) {
                    if (srcFile.isDirectory()) {
                        this.createDir(srcFile, srcStr, replaceStr);
                        this.searchFile(srcFile, srcStr, replaceStr);
                        continue;
                    }
                    if (!srcFile.isFile()) continue;
                    this.createFile(srcFile, srcStr, replaceStr);
                }
            } else if (file.isFile()) {
                this.createFile(file, srcStr, replaceStr);
            }
        }
    }

    private StringBuffer replaceSrcFileContent(File srcFile, String srcStr, String replaceStr) {
        logger.info("\u66ff\u6362{}\u6587\u4ef6\u5185\u5bb9...", (Object)srcFile.getAbsolutePath());
        StringBuffer strBuffer = null;
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(srcFile)));){
            strBuffer = new StringBuffer();
            String temp = null;
            while ((temp = bufReader.readLine()) != null) {
                if (temp.indexOf(srcStr) != -1) {
                    temp = temp.replace(srcStr, replaceStr);
                }
                if (this.replacePatternList != null) {
                    for (FileReplacePattern frp : this.replacePatternList) {
                        if (!"*".equals(frp.getFilePattern()) && !srcFile.getName().contains(frp.getFilePattern()) || temp.indexOf(frp.getFindValue()) == -1) continue;
                        temp = temp.replace(frp.getFindValue(), frp.getReplaceValue());
                    }
                }
                strBuffer.append(temp);
                strBuffer.append(System.getProperty("line.separator"));
                temp = null;
            }
            bufReader.close();
        }
        catch (FileNotFoundException e) {
            String msg = "\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + e;
            System.out.println(msg);
        }
        catch (IOException e) {
            String msg = "IO\u51fa\u73b0\u5f02\u5e38\uff1a" + e;
            System.out.println(msg);
        }
        return strBuffer;
    }

    private void writeToNewFile(String newFilePath, StringBuffer strBuffer) {
        try {
            File file = new File(newFilePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintWriter printWriter = new PrintWriter(file);
            printWriter.write(strBuffer.toString().toCharArray());
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            String msg = "\u8f93\u5165\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38" + e;
            System.out.println(msg);
        }
    }

    private void createFile(File srcFile, String srcStr, String replaceStr) {
        String newFilePath = this.handleReplaceName(srcFile, srcStr, replaceStr);
        if (!this.isBinary(srcFile) && !this.isIgnorePostfix(srcFile)) {
            StringBuffer strBuffer = this.replaceSrcFileContent(srcFile, srcStr, replaceStr);
            this.writeToNewFile(newFilePath, strBuffer);
        } else {
            logger.info("\u4e8c\u8fdb\u5236\u6587\u4ef6:{}", (Object)srcFile.getAbsolutePath());
            try {
                FileUtils.copyFile((File)srcFile, (File)new File(newFilePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isIgnorePostfix(File srcFile) {
        if (null == this.ignorePostfixArray) {
            return false;
        }
        String extension = FilenameUtils.getExtension((String)srcFile.getName());
        for (int i = 0; i < this.ignorePostfixArray.length; ++i) {
            if (!extension.equals(this.ignorePostfixArray[i])) continue;
            return true;
        }
        return false;
    }

    public void createDir(File srcFile, String srcStr, String replaceStr) {
        String newFilePath = this.handleReplaceName(srcFile, srcStr, replaceStr);
        logger.info("\u65b0\u6587\u4ef6\u5939\u8def\u5f84\uff1a{}", (Object)newFilePath);
        File directory = new File(newFilePath);
        if (srcFile.isDirectory()) {
            directory.mkdirs();
        }
    }

    public String handleReplaceName(File srcFile, String srcStr, String replaceStr) {
        String filePath = srcFile.getAbsolutePath();
        filePath = filePath.replace(this.srcFilePath, this.outFilePath);
        boolean ignoreFile = this.isIgnorePostfix(srcFile);
        File file = new File(filePath);
        filePath = !ignoreFile ? file.getAbsolutePath() : file.getParentFile().getAbsolutePath();
        if (this.replacePatternList != null) {
            for (FileReplacePattern frp : this.replacePatternList) {
                if (!"*".equals(frp.getFilePattern()) && !srcFile.getName().contains(frp.getFilePattern()) || frp.getReplaceType().equals("fileContent") || filePath.indexOf(frp.getFindValue()) == -1) continue;
                filePath = filePath.replace(frp.getFindValue(), frp.getReplaceValue());
            }
        }
        for (String str : this.srcStrList) {
            if (!filePath.contains(str) || this.outStrList.size() <= this.srcStrList.indexOf(str)) continue;
            filePath = filePath.replace(str, this.outStrList.get(this.srcStrList.indexOf(str)));
        }
        if (ignoreFile) {
            filePath = new File(filePath, file.getName()).getAbsolutePath();
        }
        return filePath;
    }

    public boolean isBinary(File file) {
        boolean isBinary = false;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            long len = file.length();
            for (int j = 0; j < (int)len; ++j) {
                int t = fin.read();
                if (t >= 32 || t == 9 || t == 10 || t == 13) continue;
                isBinary = true;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isBinary;
    }

    public void setIgnorePostfix(String ignorePostfix) {
        this.ignorePostfixArray = ignorePostfix.split(",");
    }
}

