/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.zcpaas.plugin;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasDeployInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEcsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEcsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.zcpaas.plugin.ZcpaasAbstractPlugin;
import com.irdstudio.sdk.beans.core.util.PropertiesUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AppBaseDataDeployPlugin
extends ZcpaasAbstractPlugin {
    @Override
    public boolean execute() {
        this.logger.info(String.format("\u6267\u884c\u90e8\u7f72\u5e94\u7528[%s]\u57fa\u7840\u6570\u636e\u63d2\u4ef6\u5f00\u59cb...", this.appInfo.getAppId()));
        try {
            List<String> baseTables = Arrays.asList("s_org", "s_resource", "s_resourceaction", "s_role", "s_roleright", "s_roleuser", "s_user");
            this.deal(baseTables);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void deal(List<String> tableNames) throws SQLException {
        Connection mysqlConn;
        Connection conn;
        block14: {
            conn = null;
            mysqlConn = null;
            try {
                conn = this.getPluginConnection();
                FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
                PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
                FlowInstMaster flowInstMaster = flowInstMasterDao.queryByBatchSerialNo(this.context.getSzBatchSn());
                String currEnvId = flowInstMaster.getEnvId();
                PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
                PaasEnvInfo envInfo = paasEnvInfoDao.queryByPk(currEnvId);
                PaasDeployInfoDao paasDeployInfoDao = new PaasDeployInfoDao(conn);
                PaasEcsInfoDao paasEcsInfoDao = new PaasEcsInfoDao(conn);
                PaasEcsInfo ecsParam = new PaasEcsInfo();
                ecsParam.setSubsId(this.appInfo.getSubsId());
                ecsParam.setAppId(this.appInfo.getAppId());
                ecsParam.setEnvId(currEnvId);
                List<PaasEcsInfo> ecsList = paasEcsInfoDao.queryPaasEcsInfo(ecsParam);
                Map<String, Object> appParam = paasAppsParamDao.queryAppParamMap(this.appInfo.getAppId(), this.batInst.getEnvId());
                String publicKey = PropertiesUtil.getPropertyByKey((String)"key", (String)"rsa.publicKey");
                String database_ip = "";
                String database_port = "";
                String database_name = AppBaseDataDeployPlugin.getAppDatabaseName(this.appInfo.getAppCode());
                String database_username = MapUtils.getString(appParam, (Object)"database_username");
                String database_password = MapUtils.getString(appParam, (Object)"database_password");
                if (CollectionUtils.isNotEmpty(ecsList)) {
                    PaasEcsInfo db = ecsList.get(0);
                    database_ip = db.getEcsIp();
                    database_port = db.getEcsPort();
                }
                appParam.put("database_ip", database_ip);
                appParam.put("database_port", database_port);
                appParam.put("database_name", database_name);
                mysqlConn = TdpAgentCommonUtil.getNativeConnection(appParam, false);
                PreparedStatement mysqlPstmt = null;
                for (String tableName : tableNames) {
                    Integer page = 1;
                    Integer size = 500;
                    Integer total = 0;
                    mysqlPstmt = mysqlConn.prepareStatement("delete from " + tableName);
                    mysqlPstmt.executeUpdate();
                    String sql = String.format("select * from %s where app_id = ?", tableName);
                    PreparedStatement ps = null;
                    ResultSet rs = null;
                    ArrayList list = new ArrayList();
                    try {
                        ps.setObject(1, this.appInfo.getAppId());
                        rs = ps.executeQuery();
                        mysqlConn.setAutoCommit(false);
                        while (rs.next()) {
                            ArrayList<String> columns = new ArrayList<String>();
                            ArrayList<String> placeholders = new ArrayList<String>();
                            ArrayList<Object> values = new ArrayList<Object>();
                            ResultSetMetaData metaData = rs.getMetaData();
                            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                                String colName = metaData.getColumnName(i);
                                if (StringUtils.equals((CharSequence)"app_id", (CharSequence)colName)) continue;
                                columns.add(colName);
                                values.add(rs.getObject(colName));
                                placeholders.add("?");
                            }
                            String insertSql = String.format("insert into %s(%s) values (%s)", tableName, StringUtils.join(columns, (String)","), StringUtils.join(placeholders, (String)","));
                            PreparedStatement insertPs = mysqlConn.prepareStatement(insertSql);
                            for (int i = 0; i < values.size(); ++i) {
                                insertPs.setObject(i + 1, values.get(i));
                            }
                            insertPs.executeUpdate();
                            insertPs.close();
                        }
                        mysqlConn.setAutoCommit(true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("query queryByPk is wrong", e);
                    }
                }
                if (mysqlConn == null) break block14;
            }
            catch (Exception e) {
                try {
                    this.logger.error("\u590d\u5236\u57fa\u7840\u6570\u636e\u5931\u8d25", e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (mysqlConn != null) {
                        this.closePluginConnection(mysqlConn);
                    }
                    if (conn != null) {
                        this.closePluginConnection(mysqlConn);
                    }
                    throw throwable;
                }
            }
            this.closePluginConnection(mysqlConn);
        }
        if (conn != null) {
            this.closePluginConnection(mysqlConn);
        }
    }
}

