/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.zcpaas.plugin;

import com.alibaba.fastjson.JSON;
import com.irdstudio.allinapaas.design.console.types.AppType;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.ModelTableInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.SrvModelInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsParam;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.SrvModelInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.FadpaasPageRenderFactory;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.fadpaas.IFadpaasPageRender;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.db.TdpAgentCommonUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.gencode.CodeGenerateConstant;
import com.irdstudio.allinapaas.executor.application.executor.core.util.date.CurrentDateUtil;
import com.irdstudio.allinapaas.portal.console.types.ArchType;
import com.irdstudio.allinrdm.dam.console.types.ObjectType;
import com.irdstudio.allinrdm.dev.console.facade.AppResourceService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelFieldService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelInfoService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelLogService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelPackageService;
import com.irdstudio.allinrdm.dev.console.facade.PageModelParamService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateFileService;
import com.irdstudio.allinrdm.dev.console.facade.PageTemplateInfoService;
import com.irdstudio.allinrdm.dev.console.facade.dto.AppResourceDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelInfoDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelPackageDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageModelParamDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateFileDTO;
import com.irdstudio.allinrdm.dev.console.facade.dto.PageTemplateInfoDTO;
import com.irdstudio.allinrdm.dev.console.types.PageTemplateType;
import com.irdstudio.allinrdm.dev.console.types.SrvModelCatalogEnum;
import com.irdstudio.sdk.beans.core.util.BeanUtility;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.bo.TmProjectInfoBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class NcdpaasStartPlugin
extends AbstractBuilderPlugin {
    private PaasAppsInfo appInfo = null;
    private FlowInstMaster batchInst;
    private Map<String, Object> extParam;
    private String loginUserId = "";

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        this.batchInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batchInst.getAppId());
        this.extParam = flowInstMasterDao.getExtParam(this.batchInst);
        this.loginUserId = MapUtils.getString(this.extParam, (Object)"createUserId");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean execute() {
        boolean result = true;
        Connection conn = null;
        try {
            TmProjectInfoBo tpib;
            String subsId = this.appInfo.getSubsId();
            String subsCode = this.appInfo.getAppCode();
            conn = this.getPluginConnection();
            PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
            ModelTableInfoDao modelTableInfoDao = new ModelTableInfoDao(conn);
            SrvModelInfoDao srvModelInfoDao = new SrvModelInfoDao(conn);
            PaasAppsInfo e4aParam = new PaasAppsInfo();
            e4aParam.setSubsId(subsId);
            e4aParam.setAppType(AppType.A10.getCode());
            e4aParam.setAppTemplateId("A13SPR");
            List<PaasAppsInfo> e4aList = paasAppsInfoDao.queryPaasAppsInfoList(e4aParam);
            Map e4aMap = Collections.emptyMap();
            if (CollectionUtils.isNotEmpty(e4aList)) {
                PaasAppsInfo e4aApp = e4aList.get(0);
                Map<String, Object> e4aAppParam = this.wrapAppsParam(e4aApp.getAppId(), null, conn);
                String appCode = SdEnvUtil.wrapperAppCode(e4aApp.getAppCode());
                String package_prefix = MapUtils.getString(e4aAppParam, (Object)"package_prefix", (String)"com.irdstudio");
                String newAppCode = StringUtils.replace((String)appCode, (String)"-", (String)".");
                String replacePackage = (String)package_prefix + "." + newAppCode;
                e4aMap = BeanUtility.bean2Map((Object)((Object)e4aApp));
                e4aMap.put("filterClass", String.format("%s.facade.filter.E4AFilter", replacePackage));
            }
            List<ModelTableInfo> tableList = modelTableInfoDao.queryModelTableInfoList(this.appInfo.getAppId());
            ArrayList<Object> ctdbList = new ArrayList<Object>(tableList.size());
            ArrayList<Object> tableCodeList = new ArrayList<Object>();
            if (CollectionUtils.isNotEmpty(tableList)) {
                for (ModelTableInfo table : tableList) {
                    int serNum;
                    CodeTemplateDataBo bo = new CodeTemplateDataBo();
                    String TablebjectType2 = String.valueOf(table.getObjectType());
                    tpib = new TmProjectInfoBo();
                    tpib.setProjectId(this.appInfo.getAppCode());
                    tpib.setProjectCode(this.appInfo.getAppCode());
                    tpib.setProjectName(this.appInfo.getAppName());
                    tpib.setProjectType(TablebjectType2);
                    bo.setTmProjectInfo(tpib);
                    bo.getEnvBo().setAuthor(this.loginUserId);
                    bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                    bo.getEnvBo().setDesc(String.format("%s Dao %s-%s", this.appInfo.getAppName(), table.getObjectName(), table.getObjectCode()));
                    ModelTableInfoBo tableBo = this.generateTableBO(table, conn);
                    bo.setMainTableModel(tableBo);
                    bo.getMapData().put("tableModelCode", table.getObjectCode());
                    this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
                    ctdbList.add(bo);
                    if (table.getObjectType().intValue() == Integer.valueOf(ObjectType.Inout.getCode()).intValue() || (serNum = srvModelInfoDao.countByTableModelId(this.appInfo.getAppId(), table.getObjectId())) == 0 && table.getObjectType().intValue() == Integer.valueOf(ObjectType.Data.getCode()).intValue()) continue;
                    Object serviceClassName = TmModelUtil.tableCodeToClassName((String)table.getObjectCode());
                    serviceClassName = StringUtils.uncapitalize((String)serviceClassName);
                    tableCodeList.add(serviceClassName);
                }
            }
            SrvModelInfo modelParam = new SrvModelInfo();
            modelParam.setAppId(this.appInfo.getAppId());
            List<SrvModelInfo> modelList = srvModelInfoDao.querySrvModelInfoList(modelParam, Arrays.asList(SrvModelCatalogEnum.TradeServer.getCode(), SrvModelCatalogEnum.BackServer.getCode()));
            if (CollectionUtils.isNotEmpty(modelList)) {
                for (SrvModelInfo model : modelList) {
                    String tableClassName = TmModelUtil.modelCodeToClassName((String)model.getSrvModelCode());
                    tableClassName = StringUtils.uncapitalize((String)tableClassName);
                    tableCodeList.add(tableClassName);
                }
            }
            CodeTemplateDataBo ctdb = null;
            if (CollectionUtils.isEmpty(ctdbList)) {
                CodeTemplateDataBo bo = new CodeTemplateDataBo();
                tpib = new TmProjectInfoBo();
                tpib.setProjectId(this.appInfo.getAppCode());
                tpib.setProjectCode(this.appInfo.getAppCode());
                tpib.setProjectName(this.appInfo.getAppName());
                bo.setTmProjectInfo(tpib);
                bo.getEnvBo().setAuthor(this.loginUserId);
                bo.getEnvBo().setCurrentDate(CurrentDateUtil.getTodayDate());
                bo.getEnvBo().setDesc(String.format("%s start", this.appInfo.getAppName()));
                this.wrapAppsParam(this.appInfo.getAppId(), bo, conn);
                ctdb = bo;
            } else {
                ctdb = (CodeTemplateDataBo)ctdbList.get(0);
            }
            String package_prefix = this.getPackagePrefix(ctdb);
            ctdb.getMapData().put("tableModelCode", this.appInfo.getAppCode());
            ctdb.getMapData().put("tableCodeToClassName", TmModelUtil.tableCodeToClassName((String)this.appInfo.getAppCode()));
            ctdb.getMapData().put("database_name", TdpAgentCommonUtil.getAppDatabaseName(this.appInfo));
            ArrayList appCodes = new ArrayList();
            List<PaasAppsInfo> referenceApps = paasAppsInfoDao.queryReferenceApp(this.appInfo.getAppId());
            if (CollectionUtils.isNotEmpty(referenceApps)) {
                List<String> compTypes = Arrays.asList(AppType.A10.getCode(), AppType.A10.getCode());
                for (PaasAppsInfo paas : referenceApps) {
                    if (compTypes.contains(paas.getAppType())) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("appCode", paas.getAppCode());
                    appCodes.add(map);
                }
            }
            ctdb.getMapData().put("appCodes", appCodes);
            ctdb.getMapData().put("hasAppCode", appCodes.size() > 0 ? "Y" : "N");
            if (!StringUtils.equals((CharSequence)AppType.M81.getCode(), (CharSequence)this.appInfo.getAppType())) {
                ctdb.getMapData().put("e4a", e4aMap);
                this.produceCodeFile("XXXApplication.java", "start", "src/main/java/" + package_prefix + "/" + NcdpaasStartPlugin.formatClassPath(subsCode) + "/start/", this.appInfo, ctdb);
            }
            ctdb.getMapData().put("MethodDealList", tableCodeList);
            ArchType archTypeEnum = ArchType.get((String)this.appInfo.getArchType());
            if (StringUtils.isNotBlank((CharSequence)archTypeEnum.getXmlPrefix())) {
                String xmlPrefix = archTypeEnum != null ? archTypeEnum.getXmlPrefix() : ArchType.Sofa.getXmlPrefix();
                this.produceCodeFile(xmlPrefix + "-provider-XXX.xml", this.appInfo.getAppCode(), CodeGenerateConstant.TABLE_VAR_NOSPLIT, "start", "src/main/resources/" + xmlPrefix + "/", this.appInfo, ctdb);
            }
            PaasEnvInfoDao paasEnvInfoDao = new PaasEnvInfoDao(conn);
            List<PaasEnvInfo> envList = paasEnvInfoDao.queryPaasEnvInfo(null);
            this.wrapEnvInfoParam("dev", this.appInfo, ctdb, conn);
            this.wrapComponentParams("dev", this.appInfo, ctdb, conn);
            String appNameUnicode = StringEscapeUtils.escapeJava((String)this.appInfo.getAppName());
            ctdb.getMapData().put("appNameUnicode", appNameUnicode);
            this.produceCodeFile("application.properties", "start", "src/main/resources/", this.appInfo, ctdb);
            CodeTemplateDataBo pomBo = new CodeTemplateDataBo();
            TmProjectInfoBo pomTp = new TmProjectInfoBo();
            pomTp.setProjectId(this.appInfo.getAppCode());
            pomTp.setProjectCode(this.appInfo.getAppCode());
            pomTp.setProjectName(this.appInfo.getAppName());
            pomBo.setTmProjectInfo(pomTp);
            this.wrapAppsParam(this.appInfo.getAppId(), pomBo, conn);
            pomBo.getMapData().put("e4a", e4aMap);
            this.produceCodeFile("start-pom.xml", "", "start-", "start", "", this.appInfo, pomBo);
            this.produceCodeFile("logback-spring.xml", "", "", "start", "src/main/resources/", this.appInfo, pomBo);
            this.produceCodeFile("DruidConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + NcdpaasStartPlugin.formatClassPath(subsCode) + "/start/config/", this.appInfo, pomBo);
            this.produceCodeFile("TransactionAspConfig.java", "", "", "start", "src/main/java/" + package_prefix + "/" + NcdpaasStartPlugin.formatClassPath(subsCode) + "/start/config/", this.appInfo, pomBo);
            ctdb.getMapData().put("menuJSON", this.ncdpaasAppMenuData(this.appInfo.getAppId()));
            this.produceCodeFile("index.html", "start", "src/main/resources/front/page/", this.appInfo, ctdb);
            this.executeWebPageGenerate();
            if (conn == null) return result;
        }
        catch (SQLException e) {
            this.logger.error("\u6267\u884c SQL \u5f02\u5e38", e);
            result = false;
            if (conn == null) return result;
            this.closePluginConnection(conn);
            return result;
        }
        catch (Exception e2) {
            this.logger.error(e2.getMessage(), e2);
            result = false;
            if (conn == null) return result;
            {
                catch (Throwable throwable) {
                    if (conn == null) throw throwable;
                    this.closePluginConnection(conn);
                    throw throwable;
                }
            }
            this.closePluginConnection(conn);
            return result;
        }
        this.closePluginConnection(conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeWebPageGenerate() {
        boolean result;
        block41: {
            this.logger.info("\u9875\u9762\u6a21\u578b\u4ee3\u7801\u751f\u6210\u63d2\u4ef6");
            result = true;
            Connection conn = null;
            try {
                File routeTemplateFile;
                String subsCode = this.appInfo.getAppCode();
                conn = this.getPluginConnection();
                PageModelPackageService pageModelPackageService = (PageModelPackageService)SpringContextUtils.getBean(PageModelPackageService.class);
                PageModelInfoService pageModelInfoService = (PageModelInfoService)SpringContextUtils.getBean(PageModelInfoService.class);
                PageModelLogService pageModelLogService = (PageModelLogService)SpringContextUtils.getBean(PageModelLogService.class);
                PageModelParamService pageModelParamService = (PageModelParamService)SpringContextUtils.getBean(PageModelParamService.class);
                PageTemplateInfoService pageTemplateInfoService = (PageTemplateInfoService)SpringContextUtils.getBean(PageTemplateInfoService.class);
                PageTemplateFileService pageTemplateFileService = (PageTemplateFileService)SpringContextUtils.getBean(PageTemplateFileService.class);
                PageModelFieldService pageModelFieldService = (PageModelFieldService)SpringContextUtils.getBean(PageModelFieldService.class);
                PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
                PaasAppsParam gen_path = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "gen_path");
                String genTargetPath = "page";
                if (gen_path != null) {
                    genTargetPath = gen_path.getParamValue();
                }
                String appTemplatePath = SdEnvUtil.getTemplatePath(this.appInfo, this.getSdTemplate());
                String appCode = SdEnvUtil.wrapperAppCode(this.appInfo.getAppCode());
                String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + String.format("%s-start", appCode).replace(".", "-") + File.separator + "src/main/resources/front/" + genTargetPath;
                PageModelInfoDTO modelParam = new PageModelInfoDTO();
                modelParam.setPageModelCatalog(PageTemplateType.Page.getCode());
                modelParam.setAppId(this.appInfo.getAppId());
                List modelList = pageModelInfoService.queryList((Object)modelParam);
                PageModelPackageDTO packageParam = new PageModelPackageDTO();
                packageParam.setAppId(this.appInfo.getAppId());
                List packageList = pageModelPackageService.queryList((Object)packageParam);
                Map<String, String> modelPathMap = this.createPackageMap(packageList);
                ArrayList<Map<String, String>> routes = new ArrayList<Map<String, String>>();
                if (!CollectionUtils.isNotEmpty((Collection)modelList)) break block41;
                for (PageModelInfoDTO modelInfo : modelList) {
                    IFadpaasPageRender render = FadpaasPageRenderFactory.get(modelInfo.getPageModelType());
                    if (render != null) {
                        render.setModelCode("ncdpaas");
                        render.render(modelInfo, appTemplatePath, targetPath, modelPathMap, routes);
                        continue;
                    }
                    PageModelParamDTO param = new PageModelParamDTO();
                    param.setPageModelId(modelInfo.getPageModelId());
                    param.setQueryRef("query");
                    List paramList = pageModelParamService.queryList((Object)param);
                    if (StringUtils.isBlank((CharSequence)modelInfo.getPageTemplateId())) {
                        this.logger.error(String.format("\u9875\u9762\u6a21\u677f\u672a\u914d\u7f6e\u6a21\u677f %s", modelInfo.getPageModelCode()));
                        continue;
                    }
                    PageTemplateInfoDTO template = new PageTemplateInfoDTO();
                    template.setPageTemplateId(modelInfo.getPageTemplateId());
                    template = (PageTemplateInfoDTO)pageTemplateInfoService.queryByPk((Object)template);
                    PageTemplateFileDTO fileParam = new PageTemplateFileDTO();
                    fileParam.setPageTemplateId(template.getPageTemplateId());
                    fileParam.setSize(Integer.valueOf(1000));
                    List fileList = pageTemplateFileService.queryList((Object)fileParam);
                    String localAppTemplatePath = appTemplatePath + File.separator + template.getPageTemplateCode();
                    if (!CollectionUtils.isNotEmpty((Collection)fileList)) continue;
                    for (PageTemplateFileDTO file : fileList) {
                        String templateName = file.getFileName() + ".vm";
                        String tempPath = localAppTemplatePath + File.separator + templateName;
                        File tempFile = new File(tempPath);
                        if (!tempFile.exists()) continue;
                        try {
                            String oriFileName;
                            String packagePath = modelPathMap.get(modelInfo.getPackageId());
                            if (StringUtils.isBlank((CharSequence)packagePath)) {
                                packagePath = "";
                            }
                            String basePath = this.getBasePath(packagePath);
                            Map<String, Object> root = this.prepareParam(modelInfo, paramList, appTemplatePath, basePath);
                            ArrayList dataCodes = new ArrayList();
                            paramList.forEach(pageModelParamVO -> {
                                List fields = pageModelParamVO.getFields();
                                if (CollectionUtils.isNotEmpty((Collection)fields)) {
                                    fields.forEach(f -> {
                                        if (StringUtils.isNotEmpty((CharSequence)f.getFieldOption()) && !dataCodes.contains(f)) {
                                            dataCodes.add(f.getFieldOption());
                                        }
                                    });
                                }
                            });
                            String dataCodeJoin = String.join((CharSequence)",", dataCodes);
                            root.put("BASE_PATH", basePath);
                            root.put("pageModelInfo", modelInfo);
                            root.put("dataCodeJoin", dataCodeJoin);
                            root.put("localAppTemplatePath", localAppTemplatePath);
                            String html = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)templateName, root);
                            File targetDir = new File(targetPath + File.separator + packagePath);
                            if (!targetDir.exists()) {
                                targetDir.mkdirs();
                            }
                            if (!StringUtils.endsWith((CharSequence)(oriFileName = modelInfo.getPageModelCode()), (CharSequence)".html")) {
                                oriFileName = oriFileName + ".html";
                            }
                            File targetFile = new File(targetDir, oriFileName);
                            try (FileOutputStream output = new FileOutputStream(targetFile);){
                                IOUtils.write((String)html, (OutputStream)output, (String)"utf-8");
                            }
                            boolean jsFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".js", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                            boolean cssFlag = this.renderOtherTemplate(modelInfo.getPageModelCode(), this.replaceSuffix(file.getFileName()), ".ccs", localAppTemplatePath, root, targetPath, packagePath, targetDir);
                            Map<String, String> route = this.createRoute(packagePath, targetFile);
                            route.put("jsFlag", String.valueOf(jsFlag));
                            route.put("cssFlag", String.valueOf(cssFlag));
                            route.put("cnname", modelInfo.getPageModelName());
                            routes.add(route);
                        }
                        catch (Exception e) {
                            this.logger.error("\u83b7\u53d6\u9875\u9762\u6a21\u578b\u9884\u89c8html\u5931\u8d25 " + file.getFileId(), e);
                        }
                    }
                }
                if (!CollectionUtils.isNotEmpty(routes) || !(routeTemplateFile = new File(appTemplatePath + File.separator + "views-routes.js.vm")).exists()) break block41;
                HashMap<String, ArrayList<Map<String, String>>> root = new HashMap<String, ArrayList<Map<String, String>>>();
                root.put("routes", routes);
                String localAppTemplatePath = appTemplatePath;
                String routesJs = FreemarkerUtil.produceStringByTemplate((String)localAppTemplatePath, (String)routeTemplateFile.getName(), root);
                PaasAppsParam routePath = paasAppsParamDao.queryPaasAppsParamByCode(this.appInfo.getAppId(), "route_path");
                String routeTargetPath = "router";
                if (routePath != null) {
                    routeTargetPath = routePath.getParamValue();
                }
                File targetFile = new File(new File(targetPath).getParent() + File.separator + routeTargetPath + File.separator + "views-routes.js");
                try (FileOutputStream output = new FileOutputStream(targetFile);){
                    IOUtils.write((String)routesJs, (OutputStream)output, (String)"utf-8");
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), e);
                result = false;
            }
            finally {
                if (conn != null) {
                    this.closePluginConnection(conn);
                }
            }
        }
        return result;
    }

    public String ncdpaasAppMenuData(String appId) {
        AppResourceService appResourceService = (AppResourceService)SpringContextUtils.getBean(AppResourceService.class);
        AppResourceDTO param = new AppResourceDTO();
        param.setAppId(appId);
        List<AppResourceDTO> rows = appResourceService.queryList((Object)param);
        if (CollectionUtils.isEmpty((Collection)rows)) {
            rows = Collections.emptyList();
        }
        ArrayList<Map> mapRows = new ArrayList<Map>(rows.size());
        ArrayList<Map> root = new ArrayList<Map>(rows.size());
        HashMap<String, Object> menuMap = new HashMap<String, Object>(rows.size());
        for (AppResourceDTO resource : rows) {
            Map reMap = BeanUtility.bean2Map((Object)resource);
            reMap.put("id", resource.getResourceid());
            reMap.put("text", resource.getCnname());
            reMap.put("parentId", resource.getParentid());
            menuMap.put(resource.getResourceid(), reMap);
            mapRows.add(reMap);
        }
        for (Map resourceMap : mapRows) {
            String id = MapUtils.getString((Map)resourceMap, (Object)"id");
            String parentId = MapUtils.getString((Map)resourceMap, (Object)"parentId");
            Map parent = (Map)menuMap.get(parentId);
            if (parent == null) {
                root.add(resourceMap);
                continue;
            }
            ArrayList<Map> child = (ArrayList<Map>)parent.get("children");
            if (CollectionUtils.isEmpty((Collection)child)) {
                child = new ArrayList<Map>();
                menuMap.put("children", child);
            }
            child.add(resourceMap);
        }
        return JSON.toJSONString(root);
    }
}

