/*
 * Decompiled with CFR 0.152.
 */
package com.irdstudio.allinapaas.executor.application.executor.core.plugin.zcpaas.plugin;

import com.irdstudio.allinapaas.executor.application.executor.core.dao.FlowInstMasterDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsInfoDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasAppsParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.PaasEnvParamDao;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.FlowInstMaster;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.ModelTableInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasAppsInfo;
import com.irdstudio.allinapaas.executor.application.executor.core.dao.domain.PaasEnvParam;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.apps.SdEnvUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.builder.AbstractBuilderPlugin;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.util.MyFileUtil;
import com.irdstudio.allinapaas.executor.application.executor.core.plugin.zcpaas.constant.CodeGenerateConstant;
import com.irdstudio.allinrdm.dam.console.facade.ModelTableFieldService;
import com.irdstudio.allinrdm.dam.console.facade.dto.ModelTableFieldDTO;
import com.irdstudio.sdk.beans.core.util.SpringContextUtils;
import com.irdstudio.sdk.beans.core.util.TmModelUtil;
import com.irdstudio.sdk.beans.freemarker.bo.CodeTemplateDataBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableFieldBo;
import com.irdstudio.sdk.beans.freemarker.bo.ModelTableInfoBo;
import com.irdstudio.sdk.beans.freemarker.util.FreemarkerUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public abstract class ZcpaasAbstractPlugin
extends AbstractBuilderPlugin {
    private String sdTemplate = null;
    FlowInstMaster batInst = null;
    Map<String, Object> extParam = null;
    PaasAppsInfo appInfo = null;
    Map<String, Object> appParam = null;

    @Override
    protected boolean doReadConfigureFromDB(Connection conn, String szConfIdentify) throws SQLException {
        String batchSerialNo = this.context.getSzBatchSn();
        String szSubsCode = this.context.getSzSubsCode();
        FlowInstMasterDao flowInstMasterDao = new FlowInstMasterDao(conn);
        PaasAppsParamDao paasAppsParamDao = new PaasAppsParamDao(conn);
        PaasAppsInfoDao paasAppsInfoDao = new PaasAppsInfoDao(conn);
        this.batInst = flowInstMasterDao.queryByBatchSerialNo(batchSerialNo);
        this.extParam = flowInstMasterDao.getExtParam(this.batInst);
        this.appInfo = paasAppsInfoDao.queryByAppId(this.batInst.getAppId());
        this.appParam = paasAppsParamDao.queryAppParamMap(this.batInst.getAppId(), this.batInst.getEnvId());
        return true;
    }

    ModelTableInfoBo generateTableBO(ModelTableInfo table) {
        try {
            ModelTableFieldService modelTableFieldService = (ModelTableFieldService)SpringContextUtils.getBean(ModelTableFieldService.class);
            ModelTableFieldDTO fieldParam = new ModelTableFieldDTO();
            fieldParam.setObjectId(table.getObjectId());
            List fields = modelTableFieldService.queryList((Object)fieldParam);
            ModelTableInfoBo tableBo = new ModelTableInfoBo();
            tableBo.setTableId(table.getObjectId());
            tableBo.setTableCode(table.getObjectCode());
            tableBo.setTableName(table.getObjectName());
            tableBo.setModelClassName(TmModelUtil.tableCodeToClassName((String)table.getObjectCode()));
            tableBo.setJavaPropertyName(TmModelUtil.fieldToProperty((String)table.getObjectCode()));
            if (CollectionUtils.isNotEmpty((Collection)fields)) {
                ArrayList<ModelTableFieldBo> fieldBos = new ArrayList<ModelTableFieldBo>(fields.size());
                HashMap<String, ModelTableFieldBo> fieldMap = new HashMap<String, ModelTableFieldBo>(fields.size());
                for (ModelTableFieldDTO field : fields) {
                    ModelTableFieldBo fieldBo = new ModelTableFieldBo();
                    BeanUtils.copyProperties((Object)field, (Object)fieldBo);
                    String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
                    fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
                    fieldBo.setJavaPropertyName(javaPropertyName);
                    fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
                    fieldBos.add(fieldBo);
                    fieldMap.put(field.getFieldId(), fieldBo);
                }
                tableBo.setFieldList(fieldBos);
                tableBo.setFieldMap(fieldMap);
            }
            return tableBo;
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa ModelTableInfoBo \u5f02\u5e38" + e.getMessage(), e);
            return null;
        }
    }

    ModelTableFieldBo generateTableFieldBO(ModelTableFieldDTO field) {
        ModelTableFieldBo fieldBo = new ModelTableFieldBo();
        BeanUtils.copyProperties((Object)field, (Object)fieldBo);
        String javaPropertyName = TmModelUtil.fieldToProperty((String)field.getFieldCode());
        fieldBo.setJavaMethodName(StringUtils.capitalize((String)javaPropertyName));
        fieldBo.setJavaPropertyName(javaPropertyName);
        fieldBo.setJavaType(TmModelUtil.fieldTypeToJavaType((String)field.getFieldType()));
        return fieldBo;
    }

    public static final String getAppDatabaseName(String appCode) {
        String code = appCode;
        return code.replaceAll("[\\.-]", "_");
    }

    void wrapEnvInfoParam(PaasAppsInfo appInfo, CodeTemplateDataBo dataBo, Connection conn) throws Exception {
        PaasEnvParamDao paasEnvParamDao = new PaasEnvParamDao(conn);
        PaasEnvParam paasEnvParam = new PaasEnvParam();
        paasEnvParam.setEnvId("paas");
        List<PaasEnvParam> envList = paasEnvParamDao.queryPaasEnvParamList(paasEnvParam);
        HashMap<String, String> envParam = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(envList)) {
            for (PaasEnvParam ep : envList) {
                envParam.put(ep.getParamCode(), ep.getParamValue());
            }
        }
        dataBo.getMapData().put("envParam", envParam);
    }

    void produceCodeFile(String templateFile, String codePath, PaasAppsInfo appInfo, ModelTableInfoBo mtib, CodeTemplateDataBo ctdb) {
        String appCode = SdEnvUtil.wrapperAppCode(appInfo.getAppCode());
        String templatePath = SdEnvUtil.getTemplatePath(appInfo.getAppTemplateId());
        String targetPath = SdEnvUtil.PROJECT_PATH + appCode + File.separator + codePath;
        if (!MyFileUtil.checkFileExist(targetPath = ZcpaasAbstractPlugin.pathMatchSystem(targetPath)).booleanValue()) {
            File targetDic = new File(targetPath);
            targetDic.mkdirs();
        }
        String fileNameResult = null;
        String tableModelCode = (String)ctdb.getMapData().get("tableModelCode");
        if (mtib != null) {
            fileNameResult = templateFile.replaceAll(CodeGenerateConstant.TABLE_VAR_NOSPLIT, mtib.getModelClassName());
            fileNameResult = fileNameResult.replaceAll(CodeGenerateConstant.TABLE_VAR_SPLIT, mtib.getTableCode().replace("_", "-"));
        } else if (StringUtils.isNotBlank((CharSequence)tableModelCode)) {
            String modelClassName = TmModelUtil.tableCodeToClassName((String)tableModelCode);
            fileNameResult = templateFile.replaceAll(CodeGenerateConstant.TABLE_VAR_NOSPLIT, modelClassName);
            fileNameResult = fileNameResult.replaceAll(CodeGenerateConstant.TABLE_VAR_SPLIT, tableModelCode.replace("_", "-"));
        } else {
            fileNameResult = templateFile;
        }
        String outputFileName = targetPath + fileNameResult;
        FreemarkerUtil.produceSingleFile((CodeTemplateDataBo)ctdb, (String)templatePath, (String)(templateFile + ".vm"), (String)outputFileName);
    }
}

